/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.popupmenu;

import com.github.weisj.darklaf.components.OverlayScrollPane;
import com.github.weisj.darklaf.ui.popupmenu.DarkPopupMenuUI;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.security.AccessController;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JWindow;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import sun.awt.SunToolkit;
import sun.awt.UngrabEvent;

public class MouseGrabber
implements ChangeListener,
AWTEventListener,
ComponentListener,
WindowListener {
    Window grabbedWindow;
    MenuElement[] lastPathSelected;

    public void install() {
        MenuSelectionManager msm = MenuSelectionManager.defaultManager();
        msm.addChangeListener(this);
        this.lastPathSelected = msm.getSelectedPath();
        if (this.lastPathSelected.length != 0) {
            this.grabWindow(this.lastPathSelected);
        }
    }

    protected void grabWindow(MenuElement[] newPath) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        AccessController.doPrivileged(() -> {
            tk.addAWTEventListener(this, -2147352464L);
            return null;
        });
        Component invoker = newPath[0].getComponent();
        if (invoker instanceof JPopupMenu) {
            invoker = ((JPopupMenu)invoker).getInvoker();
        }
        this.grabbedWindow = DarkUIUtil.getWindow(invoker);
        if (this.grabbedWindow != null) {
            if (tk instanceof SunToolkit) {
                ((SunToolkit)tk).grab(this.grabbedWindow);
            } else {
                this.grabbedWindow.addComponentListener(this);
                this.grabbedWindow.addWindowListener(this);
            }
        }
    }

    public void uninstall() {
        MenuSelectionManager.defaultManager().removeChangeListener(this);
        this.ungrabWindow();
    }

    protected void ungrabWindow() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        AccessController.doPrivileged(() -> {
            tk.removeAWTEventListener(this);
            return null;
        });
        this.realUngrabWindow();
    }

    protected void realUngrabWindow() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        if (this.grabbedWindow != null) {
            if (tk instanceof SunToolkit) {
                ((SunToolkit)tk).ungrab(this.grabbedWindow);
            } else {
                this.grabbedWindow.removeComponentListener(this);
                this.grabbedWindow.removeWindowListener(this);
            }
            this.grabbedWindow = null;
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        MenuSelectionManager msm = MenuSelectionManager.defaultManager();
        MenuElement[] p = msm.getSelectedPath();
        if (this.lastPathSelected.length == 0 && p.length != 0) {
            this.grabWindow(p);
        }
        if (this.lastPathSelected.length != 0 && p.length == 0) {
            this.ungrabWindow();
        }
        this.repaintIfNecessary(e);
        this.lastPathSelected = p;
    }

    protected void repaintIfNecessary(ChangeEvent e) {
        Object source = e.getSource();
        if (source instanceof MenuSelectionManager) {
            MenuSelectionManager manager = (MenuSelectionManager)source;
            MenuElement[] path = manager.getSelectedPath();
            this.repaintPath(path);
            this.repaintPath(this.lastPathSelected);
        }
    }

    private void repaintPath(MenuElement[] path) {
        OverlayScrollPane sp;
        MenuElement menuElement;
        Component comp;
        if (path != null && path.length > 0 && (comp = (menuElement = path[path.length - 1]).getComponent()).isVisible() && !(comp instanceof JPopupMenu) && (sp = DarkUIUtil.getParentOfType(OverlayScrollPane.class, comp, 5)) != null) {
            DarkUIUtil.repaint(sp, SwingUtilities.convertRectangle(comp, comp.getBounds(), sp));
        }
    }

    @Override
    public void eventDispatched(AWTEvent ev) {
        if (ev instanceof UngrabEvent) {
            this.cancelPopupMenu();
            return;
        }
        if (!(ev instanceof MouseEvent)) {
            return;
        }
        MouseEvent me = (MouseEvent)ev;
        Component src = me.getComponent();
        switch (me.getID()) {
            case 501: {
                if (this.isInPopup(src) || src instanceof JMenu && ((JMenu)src).isSelected()) {
                    return;
                }
                if (PropertyUtil.isPropertyEqual((Component)src, (String)"doNotCancelPopup", (Object)"doNotCancelPopup")) break;
                this.cancelPopupMenu();
                boolean consumeEvent = UIManager.getBoolean("PopupMenu.consumeEventOnClose");
                if (!consumeEvent || src instanceof MenuElement) break;
                me.consume();
                break;
            }
            case 502: {
                if (!(src instanceof MenuElement) && this.isInPopup(src) || !(src instanceof JMenu) && src instanceof JMenuItem) break;
                MenuSelectionManager.defaultManager().processMouseEvent(me);
                break;
            }
            case 506: {
                if (!(src instanceof MenuElement) && this.isInPopup(src)) break;
                MenuSelectionManager.defaultManager().processMouseEvent(me);
                break;
            }
            case 507: {
                if (this.isInPopup(src) || src instanceof JComboBox && ((JComboBox)src).isPopupVisible() || src instanceof JWindow && src.isVisible() || src instanceof JMenuItem && src.isVisible() || src instanceof JFrame || src instanceof JDialog) {
                    return;
                }
                this.cancelPopupMenu();
            }
        }
    }

    protected void cancelPopupMenu() {
        try {
            List<JPopupMenu> popups = DarkPopupMenuUI.getPopups();
            for (JPopupMenu popup : popups) {
                popup.putClientProperty("JPopupMenu.firePopupMenuCanceled", Boolean.TRUE);
            }
            MenuSelectionManager.defaultManager().clearSelectedPath();
        }
        catch (Error | RuntimeException ex) {
            this.realUngrabWindow();
            throw ex;
        }
    }

    protected boolean isInPopup(Component src) {
        for (Component c = src; c != null && !(c instanceof Applet) && !(c instanceof Window); c = c.getParent()) {
            if (c instanceof JPopupMenu) {
                return true;
            }
            if (!PropertyUtil.getBooleanProperty((Component)c, (String)"doNotCancelOnScroll")) continue;
            return true;
        }
        return false;
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.cancelPopupMenu();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        this.cancelPopupMenu();
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.cancelPopupMenu();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        this.cancelPopupMenu();
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.cancelPopupMenu();
    }

    @Override
    public void windowClosed(WindowEvent e) {
        this.cancelPopupMenu();
    }

    @Override
    public void windowIconified(WindowEvent e) {
        this.cancelPopupMenu();
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
        this.cancelPopupMenu();
    }
}

