/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.settings;

import com.github.weisj.darklaf.LafManager;
import com.github.weisj.darklaf.components.ColoredRadioButton;
import com.github.weisj.darklaf.components.color.QuickColorChooser;
import com.github.weisj.darklaf.components.tooltip.ToolTipContext;
import com.github.weisj.darklaf.components.tristate.TristateCheckBox;
import com.github.weisj.darklaf.components.tristate.TristateState;
import com.github.weisj.darklaf.graphics.ThemedColor;
import com.github.weisj.darklaf.listener.UIUpdater;
import com.github.weisj.darklaf.platform.ThemePreferencesHandler;
import com.github.weisj.darklaf.platform.macos.theme.MacOSColors;
import com.github.weisj.darklaf.settings.SettingsConfiguration;
import com.github.weisj.darklaf.settings.ThemeSettings;
import com.github.weisj.darklaf.theme.Theme;
import com.github.weisj.darklaf.theme.info.AccentColorRule;
import com.github.weisj.darklaf.theme.info.FontSizePreset;
import com.github.weisj.darklaf.theme.info.FontSizeRule;
import com.github.weisj.darklaf.theme.info.PreferredThemeStyle;
import com.github.weisj.darklaf.ui.slider.DarkSliderUI;
import com.github.weisj.darklaf.util.Alignment;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.plaf.SliderUI;

public class ThemeSettingsPanel
extends JPanel {
    private final SettingsPanelConfiguration settingsConfiguration = new SettingsPanelConfiguration();
    private JCheckBox fontSizeFollowsSystem;
    private JCheckBox accentColorFollowsSystem;
    private JCheckBox selectionColorFollowsSystem;
    private JComboBox<Theme> themeComboBox;
    private JCheckBox themeFollowsSystem;
    private JSlider fontSlider;
    private TristateCheckBox enabledSystemPreferences;
    private ButtonGroup bgSelection;
    private ButtonGroup bgAccent;
    private Color defaultAccentColor;
    private Color defaultSelectionColor;
    private ColoredRadioButton customAccent;
    private ColoredRadioButton defaultAccent;
    private ColoredRadioButton customSelection;
    private ColoredRadioButton defaultSelection;

    public ThemeSettingsPanel() {
        this.init();
    }

    protected void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add(this.createGeneralSettings(), "Center");
        this.add(this.createMonitorSettings(), "South");
    }

    public void loadConfiguration(SettingsConfiguration configuration) {
        this.themeComboBox.setModel(LafManager.getThemeComboBoxModel());
        this.settingsConfiguration.load(configuration);
        this.settingsConfiguration.setAccentColorRule(this.settingsConfiguration.getAccentColorRule());
        this.update();
    }

    private void update() {
        boolean enabled = !this.enabledSystemPreferences.getTristateModel().isDeselected();
        this.enabledSystemPreferences.setEnabled(this.settingsConfiguration.isSystemPreferencesSupported());
        this.themeFollowsSystem.setEnabled(enabled && this.settingsConfiguration.isSystemThemeSupported());
        this.accentColorFollowsSystem.setEnabled(enabled && this.settingsConfiguration.isSystemAccentColorSupported());
        this.selectionColorFollowsSystem.setEnabled(enabled && this.settingsConfiguration.isSystemSelectionColorSupported());
        this.fontSizeFollowsSystem.setEnabled(enabled && this.settingsConfiguration.isSystemFontSizeSupported());
        this.settingsConfiguration.setSystemPreferencesEnabled(this.settingsConfiguration.isSystemPreferencesEnabled());
        this.enableButtonGroup(this.bgAccent, !this.settingsConfiguration.isAccentColorFollowsSystem() && this.settingsConfiguration.getSelectedTheme().supportsCustomAccentColor());
        this.enableButtonGroup(this.bgSelection, !this.settingsConfiguration.isSelectionColorFollowsSystem() && this.settingsConfiguration.getSelectedTheme().supportsCustomSelectionColor());
        this.themeComboBox.setEnabled(!this.settingsConfiguration.isThemeFollowsSystem());
        this.fontSlider.setEnabled(!this.settingsConfiguration.isFontSizeFollowsSystem());
    }

    public void updateConfiguration() {
        ThemeSettings.getInstance().setConfiguration(this.settingsConfiguration);
    }

    private boolean updateButtonGroup(ButtonGroup bg, Color currentColor, AbstractButton defaultButton, Color defaultColor) {
        Enumeration<AbstractButton> buttons = bg.getElements();
        while (buttons.hasMoreElements()) {
            ColoredRadioButton radioButton = (ColoredRadioButton)buttons.nextElement();
            boolean selected = Objects.equals(radioButton.getColor(), currentColor) || radioButton == defaultButton && Objects.equals(defaultColor, currentColor);
            bg.setSelected(radioButton.getModel(), selected);
            if (!selected) continue;
            return true;
        }
        return false;
    }

    protected Color getSelectedColor(ButtonGroup bg, AbstractButton defaultButton) {
        Enumeration<AbstractButton> enumeration = bg.getElements();
        while (enumeration.hasMoreElements()) {
            ColoredRadioButton button = (ColoredRadioButton)enumeration.nextElement();
            if (!button.isSelected()) continue;
            Color c = button.getColor();
            return button != defaultButton ? c : null;
        }
        return null;
    }

    private Component createGeneralSettings() {
        Locale l = this.getLocale();
        JLabel themeLabel = new JLabel(UIManager.getString((Object)"label_theme", l));
        this.themeComboBox = new JComboBox<Theme>(LafManager.getThemeComboBoxModel());
        this.themeComboBox.setRenderer(LafManager.getThemeListCellRenderer());
        this.themeComboBox.setSelectedItem(LafManager.getTheme());
        this.themeComboBox.putClientProperty("JComboBox.isTableCellEditor", true);
        this.themeComboBox.addItemListener(e -> this.update());
        themeLabel.setLabelFor(this.themeComboBox);
        JPanel themeBox = new JPanel(new FlowLayout(0));
        themeBox.setAlignmentX(0.0f);
        themeBox.add(themeLabel);
        themeBox.add(this.themeComboBox);
        this.add(themeBox);
        Color currentAccentColor = LafManager.getTheme().getAccentColorRule().getAccentColor();
        Color currentSelectionColor = LafManager.getTheme().getAccentColorRule().getSelectionColor();
        Box selectionBox = Box.createHorizontalBox();
        JLabel selectionColorLabel = new JLabel(UIManager.getString((Object)"label_selection_color", l));
        selectionColorLabel.setLabelFor(selectionBox);
        this.bgSelection = new ButtonGroup();
        this.defaultSelectionColor = this.createDefaultColor("themeSelectionColor");
        this.defaultSelection = this.addColoredButton(this.bgSelection, (JComponent)selectionBox, this.defaultSelectionColor, ColoredRadioButton.DEFAULT_COLOR, UIManager.getString((Object)"color_default", l));
        ColoredRadioButton selectionBlue = this.addColoredButton(this.bgSelection, (JComponent)selectionBox, MacOSColors.SELECTION_BLUE, MacOSColors.ACCENT_BLUE, UIManager.getString((Object)"color_blue", l));
        ColoredRadioButton selectionPurple = this.addColoredButton(this.bgSelection, (JComponent)selectionBox, MacOSColors.SELECTION_PURPLE, MacOSColors.ACCENT_LILAC, UIManager.getString((Object)"color_purple", l));
        ColoredRadioButton selectionPink = this.addColoredButton(this.bgSelection, (JComponent)selectionBox, MacOSColors.SELECTION_PINK, MacOSColors.ACCENT_ROSE, UIManager.getString((Object)"color_pink", l));
        ColoredRadioButton selectionRed = this.addColoredButton(this.bgSelection, (JComponent)selectionBox, MacOSColors.SELECTION_RED, MacOSColors.ACCENT_RED, UIManager.getString((Object)"color_red", l));
        ColoredRadioButton selectionOrange = this.addColoredButton(this.bgSelection, (JComponent)selectionBox, MacOSColors.SELECTION_ORANGE, MacOSColors.ACCENT_ORANGE, UIManager.getString((Object)"color_orange", l));
        ColoredRadioButton selectionYellow = this.addColoredButton(this.bgSelection, (JComponent)selectionBox, MacOSColors.SELECTION_YELLOW, MacOSColors.ACCENT_YELLOW, UIManager.getString((Object)"color_yellow", l));
        ColoredRadioButton selectionGreen = this.addColoredButton(this.bgSelection, (JComponent)selectionBox, MacOSColors.SELECTION_GREEN, MacOSColors.ACCENT_GREEN, UIManager.getString((Object)"color_green", l));
        ColoredRadioButton selectionGraphite = this.addColoredButton(this.bgSelection, (JComponent)selectionBox, MacOSColors.SELECTION_GRAPHITE, MacOSColors.ACCENT_GRAPHITE, UIManager.getString((Object)"color_gray", l));
        this.customSelection = this.addCustomButton(this.bgSelection, selectionBox, currentSelectionColor, this.defaultSelectionColor, UIManager.getString((Object)"color_custom", l));
        Box accentBox = Box.createHorizontalBox();
        JLabel accentColorLabel = new JLabel(UIManager.getString((Object)"label_accent_color", l));
        accentColorLabel.setLabelFor(accentBox);
        this.defaultAccentColor = this.createDefaultColor("themeAccentColor");
        this.bgAccent = new ButtonGroup();
        this.defaultAccent = this.addColoredButton(this.bgAccent, (JComponent)accentBox, ColoredRadioButton.DEFAULT_COLOR, this.defaultSelection, UIManager.getString((Object)"color_default", l));
        this.addColoredButton(this.bgAccent, (JComponent)accentBox, MacOSColors.ACCENT_BLUE, selectionBlue, UIManager.getString((Object)"color_blue", l));
        this.addColoredButton(this.bgAccent, (JComponent)accentBox, MacOSColors.ACCENT_LILAC, selectionPurple, UIManager.getString((Object)"color_lilac", l));
        this.addColoredButton(this.bgAccent, (JComponent)accentBox, MacOSColors.ACCENT_ROSE, selectionPink, UIManager.getString((Object)"color_rose", l));
        this.addColoredButton(this.bgAccent, (JComponent)accentBox, MacOSColors.ACCENT_RED, selectionRed, UIManager.getString((Object)"color_red", l));
        this.addColoredButton(this.bgAccent, (JComponent)accentBox, MacOSColors.ACCENT_ORANGE, selectionOrange, UIManager.getString((Object)"color_orange", l));
        this.addColoredButton(this.bgAccent, (JComponent)accentBox, MacOSColors.ACCENT_YELLOW, selectionYellow, UIManager.getString((Object)"color_yellow", l));
        this.addColoredButton(this.bgAccent, (JComponent)accentBox, MacOSColors.ACCENT_GREEN, selectionGreen, UIManager.getString((Object)"color_green", l));
        this.addColoredButton(this.bgAccent, (JComponent)accentBox, MacOSColors.ACCENT_GRAPHITE, selectionGraphite, UIManager.getString((Object)"color_gray", l));
        this.customAccent = this.addCustomButton(this.bgAccent, accentBox, currentAccentColor, this.defaultAccentColor, UIManager.getString((Object)"color_custom", l));
        this.fontSlider = this.createFontSlider();
        JLabel fontSizeLabel = new JLabel(UIManager.getString((Object)"label_font_size", l));
        fontSizeLabel.setLabelFor(this.fontSlider);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder(UIManager.getString((Object)"title_general", l)));
        panel.add(this.getTwoColumnLayout(new JLabel[]{themeLabel, accentColorLabel, selectionColorLabel, fontSizeLabel}, new JComponent[]{this.themeComboBox, accentBox, selectionBox, this.fontSlider}));
        return panel;
    }

    protected ColoredRadioButton addCustomButton(ButtonGroup bg, JComponent parent, Color currentColor, Color defaultColor, String tipText) {
        Supplier<Color> supplier = () -> Optional.ofNullable(currentColor).orElse(defaultColor);
        ColoredRadioButton button = this.addColoredButton(bg, parent, supplier, tipText);
        QuickColorChooser.attachToComponent(button, button::setColor, () -> Optional.ofNullable(button.getColor()).orElse((Color)supplier.get()), button::isSelected);
        return button;
    }

    protected Color createDefaultColor(String key) {
        return new ThemedColor(key);
    }

    protected void setAccentColor(Color accentColor) {
        this.setXColor(accentColor, this.bgAccent, this.customAccent, this.defaultAccent, this.defaultAccentColor);
    }

    protected void setSelectionColor(Color selectionColor) {
        this.setXColor(selectionColor, this.bgSelection, this.customSelection, this.defaultSelection, this.defaultSelectionColor);
    }

    protected void setXColor(Color color, ButtonGroup bg, ColoredRadioButton customButton, ColoredRadioButton defaultButton, Color defaultColor) {
        if (color == null) {
            defaultButton.setSelected(true);
            return;
        }
        if (!this.updateButtonGroup(bg, color, defaultButton, defaultColor)) {
            customButton.setSelected(true);
            if (customButton.getColor() == null) {
                customButton.setColor(color);
            }
        }
    }

    private JSlider createFontSlider() {
        Locale l = this.getLocale();
        JSlider fontSlider = new JSlider(){

            @Override
            public String getToolTipText(MouseEvent event) {
                return this.getValue() + "%";
            }
        };
        ToolTipContext context = new ToolTipContext().setAlignment(Alignment.CENTER).setCenterAlignment(Alignment.NORTH).setUseBestFit(true).setToolTipRectSupplier(e -> {
            SliderUI ui = fontSlider.getUI();
            if (ui instanceof DarkSliderUI) {
                Rectangle r = ((DarkSliderUI)ui).getThumbRect();
                --r.x;
                return r;
            }
            return new Rectangle(0, 0, fontSlider.getWidth(), fontSlider.getHeight());
        });
        fontSlider.putClientProperty("JSlider.instantScrollEnabled", true);
        fontSlider.putClientProperty("JToolTip.toolTipContext", context);
        fontSlider.putClientProperty("JToolTip.style", "balloon");
        fontSlider.setToolTipText(String.valueOf(fontSlider.getValue()));
        fontSlider.setOrientation(0);
        fontSlider.setPaintTicks(true);
        fontSlider.setMinimum(FontSizePreset.TINY.getPercentage());
        fontSlider.setMaximum(FontSizePreset.HUGE.getPercentage());
        int tickSpacing = 25;
        Hashtable<Integer, JComponent> dict = fontSlider.createStandardLabels(tickSpacing);
        JLabel min = (JLabel)((Dictionary)dict).get(fontSlider.getMinimum());
        UIUpdater.registerComponent(min);
        min.setText(UIManager.getString((Object)"label_font_smaller", l));
        min.setAlignmentX(0.0f);
        min.putClientProperty("JSlider.manualLabelAlign", true);
        JLabel mid = (JLabel)((Dictionary)dict).get(fontSlider.getMinimum() + tickSpacing);
        UIUpdater.registerComponent(mid);
        ((Dictionary)dict).remove(fontSlider.getMinimum() + tickSpacing);
        ((Dictionary)dict).put(FontSizePreset.NORMAL.getPercentage(), mid);
        mid.setText(UIManager.getString((Object)"label_font_default", l));
        mid.setAlignmentX(0.5f);
        mid.setHorizontalTextPosition(4);
        JLabel max = (JLabel)((Dictionary)dict).get(fontSlider.getMaximum());
        max.putClientProperty("JSlider.manualLabelAlign", true);
        max.setText(UIManager.getString((Object)"label_font_bigger", l));
        max.setAlignmentX(1.0f);
        max.putClientProperty("JSlider.manualLabelAlign", true);
        UIUpdater.registerComponent(max);
        ((Dictionary)dict).remove(FontSizePreset.Small.getPercentage());
        ((Dictionary)dict).remove(FontSizePreset.SMALL.getPercentage());
        ((Dictionary)dict).remove(FontSizePreset.Large.getPercentage());
        ((Dictionary)dict).remove(FontSizePreset.LARGE.getPercentage());
        ((Dictionary)dict).remove(FontSizePreset.Huge.getPercentage());
        fontSlider.setLabelTable(dict);
        fontSlider.setMajorTickSpacing(tickSpacing);
        fontSlider.setMinorTickSpacing(tickSpacing);
        fontSlider.setPaintLabels(true);
        fontSlider.setSnapToTicks(true);
        return fontSlider;
    }

    private Component createMonitorSettings() {
        Locale l = this.getLocale();
        this.accentColorFollowsSystem = new JCheckBox(UIManager.getString((Object)"check_system_accent_color", l)){

            @Override
            public void setEnabled(boolean b) {
                boolean enabled = b && ThemePreferencesHandler.getSharedInstance().supportsNativeAccentColor();
                super.setEnabled(enabled);
            }
        };
        this.accentColorFollowsSystem.setEnabled(false);
        this.accentColorFollowsSystem.setSelected(false);
        this.selectionColorFollowsSystem = new JCheckBox(UIManager.getString((Object)"check_system_selection_color", l)){

            @Override
            public void setEnabled(boolean b) {
                boolean enabled = b && ThemePreferencesHandler.getSharedInstance().supportsNativeSelectionColor();
                super.setEnabled(enabled);
            }
        };
        this.selectionColorFollowsSystem.setEnabled(false);
        this.selectionColorFollowsSystem.setSelected(false);
        this.fontSizeFollowsSystem = new JCheckBox(UIManager.getString((Object)"check_system_font", l)){

            @Override
            public void setEnabled(boolean b) {
                boolean enabled = b && ThemePreferencesHandler.getSharedInstance().supportsNativeFontSize();
                super.setEnabled(enabled);
            }
        };
        this.fontSizeFollowsSystem.setEnabled(false);
        this.fontSizeFollowsSystem.setSelected(false);
        this.themeFollowsSystem = new JCheckBox(UIManager.getString((Object)"check_system_theme", l)){

            @Override
            public void setEnabled(boolean b) {
                boolean enabled = b && ThemePreferencesHandler.getSharedInstance().supportsNativeTheme();
                super.setEnabled(enabled);
            }
        };
        this.themeFollowsSystem.setEnabled(false);
        this.themeFollowsSystem.setSelected(false);
        this.enabledSystemPreferences = new TristateCheckBox(UIManager.getString((Object)"check_system_preferences", l));
        this.enabledSystemPreferences.addChangeListener(e -> {
            if (!this.enabledSystemPreferences.getTristateModel().isIndeterminate()) {
                boolean selected = this.enabledSystemPreferences.getTristateModel().isSelected();
                if (this.themeFollowsSystem.isEnabled()) {
                    this.themeFollowsSystem.setSelected(selected);
                }
                if (this.accentColorFollowsSystem.isEnabled()) {
                    this.accentColorFollowsSystem.setSelected(selected);
                }
                if (this.selectionColorFollowsSystem.isEnabled()) {
                    this.selectionColorFollowsSystem.setSelected(selected);
                }
                if (this.fontSizeFollowsSystem.isEnabled()) {
                    this.fontSizeFollowsSystem.setSelected(selected);
                }
            }
            this.update();
        });
        this.themeFollowsSystem.addActionListener(e -> this.update());
        this.accentColorFollowsSystem.addActionListener(e -> this.update());
        this.selectionColorFollowsSystem.addActionListener(e -> this.update());
        this.fontSizeFollowsSystem.addActionListener(e -> this.update());
        this.enabledSystemPreferences.setSelected(LafManager.isPreferenceChangeReportingEnabled());
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder(UIManager.getString((Object)"title_monitoring", l)));
        panel.add(this.getTwoColumnLayout(new JComponent[]{this.enabledSystemPreferences, this.themeFollowsSystem, this.accentColorFollowsSystem}, new JComponent[]{new JLabel(), this.fontSizeFollowsSystem, this.selectionColorFollowsSystem}, GroupLayout.Alignment.LEADING, GroupLayout.Alignment.LEADING));
        return panel;
    }

    private JComponent getTwoColumnLayout(JComponent[] left, JComponent[] right) {
        return this.getTwoColumnLayout(left, right, GroupLayout.Alignment.TRAILING, GroupLayout.Alignment.LEADING);
    }

    private JComponent getTwoColumnLayout(JComponent[] left, JComponent[] right, GroupLayout.Alignment leftColumn, GroupLayout.Alignment rightColumn) {
        if (left.length != right.length) {
            String s = left.length + " labels supplied for " + right.length + " fields!";
            throw new IllegalArgumentException(s);
        }
        JPanel panel = new JPanel();
        GroupLayout layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(false);
        GroupLayout.SequentialGroup horizontalGroup = layout.createSequentialGroup();
        GroupLayout.ParallelGroup verticalLabelGroup = layout.createParallelGroup(leftColumn);
        horizontalGroup.addGroup(verticalLabelGroup);
        GroupLayout.ParallelGroup verticalComponentGroup = layout.createParallelGroup(rightColumn);
        horizontalGroup.addGroup(verticalComponentGroup);
        layout.setHorizontalGroup(horizontalGroup);
        GroupLayout.SequentialGroup verticalGroup = layout.createSequentialGroup();
        layout.setVerticalGroup(verticalGroup);
        int p = -2;
        for (JComponent label : left) {
            ((GroupLayout.Group)verticalLabelGroup).addComponent(label);
        }
        for (JComponent field : right) {
            ((GroupLayout.Group)verticalComponentGroup).addComponent(field, p, p, p);
        }
        for (int i = 0; i < left.length; ++i) {
            verticalGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(left[i]).addComponent(right[i], p, p, p));
        }
        return panel;
    }

    private void enableButtonGroup(ButtonGroup bg, boolean enabled) {
        Enumeration<AbstractButton> buttons = bg.getElements();
        while (buttons.hasMoreElements()) {
            buttons.nextElement().setEnabled(enabled);
        }
    }

    private ColoredRadioButton addColoredButton(ButtonGroup bg, JComponent parent, Color color, String tipText) {
        return this.addColoredButton(bg, parent, color, color, tipText);
    }

    private ColoredRadioButton addColoredButton(ButtonGroup bg, JComponent parent, Color color, AbstractButton peer, String tipText) {
        return this.addColoredButton(bg, parent, color, color, peer, tipText);
    }

    private ColoredRadioButton addColoredButton(ButtonGroup bg, JComponent parent, Color color, Color focusColor, String tipText) {
        return this.addColoredButton(bg, parent, color, focusColor, null, tipText);
    }

    private ColoredRadioButton addColoredButton(ButtonGroup bg, JComponent parent, Color color, Color focusColor, AbstractButton peer, String tipText) {
        ColoredRadioButton button = this.addColoredButtonImpl(new ColoredRadioButton(null, color, focusColor), bg, parent, tipText);
        if (peer != null) {
            button.addActionListener(e -> {
                if (button.isSelected()) {
                    peer.setSelected(true);
                }
            });
        }
        return button;
    }

    private ColoredRadioButton addColoredButton(ButtonGroup bg, JComponent parent, Supplier<Color> colorSupplier, String tipText) {
        return this.addColoredButton(bg, parent, colorSupplier, colorSupplier, tipText);
    }

    private ColoredRadioButton addColoredButton(ButtonGroup bg, JComponent parent, final Supplier<Color> colorSupplier, final Supplier<Color> focusColorSupplier, String tipText) {
        return this.addColoredButtonImpl(new ColoredRadioButton(null, null){
            {
                super(text, color);
                this.addActionListener(e -> this.getColor());
            }

            @Override
            public Color getColor() {
                Color c = super.getColor();
                if (c == null) {
                    this.setColors((Color)colorSupplier.get(), (Color)focusColorSupplier.get());
                }
                return super.getColor();
            }
        }, bg, parent, tipText);
    }

    private ColoredRadioButton addColoredButtonImpl(ColoredRadioButton button, ButtonGroup bg, JComponent parent, String tipText) {
        this.setupButton(button, bg, tipText);
        parent.add(button);
        return button;
    }

    private void setupButton(ColoredRadioButton button, ButtonGroup bg, String tipText) {
        bg.add(button);
        button.setName(tipText);
        ToolTipContext context = new ToolTipContext().setAlignment(Alignment.CENTER).setCenterAlignment(Alignment.NORTH);
        button.setToolTipText(tipText);
        button.putClientProperty("JToolTip.style", "balloon");
        button.putClientProperty("JToolTip.toolTipContext", context);
    }

    private class SettingsPanelConfiguration
    extends SettingsConfiguration {
        private SettingsPanelConfiguration() {
        }

        @Override
        public boolean isSystemPreferencesEnabled() {
            return !ThemeSettingsPanel.this.enabledSystemPreferences.getTristateModel().isDeselected() && this.isSystemPreferencesSupported();
        }

        @Override
        public boolean isAccentColorFollowsSystem() {
            return ThemeSettingsPanel.this.accentColorFollowsSystem.isSelected() && this.isSystemAccentColorSupported();
        }

        @Override
        public boolean isFontSizeFollowsSystem() {
            return ThemeSettingsPanel.this.fontSizeFollowsSystem.isSelected() && this.isSystemFontSizeSupported();
        }

        @Override
        public boolean isSelectionColorFollowsSystem() {
            return ThemeSettingsPanel.this.selectionColorFollowsSystem.isSelected() && this.isSystemSelectionColorSupported();
        }

        @Override
        public boolean isThemeFollowsSystem() {
            return ThemeSettingsPanel.this.themeFollowsSystem.isSelected() && this.isSystemThemeSupported();
        }

        @Override
        public boolean isSystemAccentColorSupported() {
            return super.isSystemAccentColorSupported() && this.getSelectedTheme().supportsCustomAccentColor();
        }

        @Override
        public boolean isSystemSelectionColorSupported() {
            return super.isSystemSelectionColorSupported() && this.getSelectedTheme().supportsCustomSelectionColor();
        }

        @Override
        public AccentColorRule getAccentColorRule() {
            PreferredThemeStyle preferredThemeStyle = LafManager.getPreferredThemeStyle();
            return this.getAccentColorRule(this.getTheme(preferredThemeStyle));
        }

        private AccentColorRule getAccentColorRule(Theme theme) {
            if (theme == null) {
                return AccentColorRule.getDefault();
            }
            Color accentColor = this.getAccentColor(theme, this.isAccentColorFollowsSystem());
            Color selectionColor = this.getSelectionColor(theme, this.isSelectionColorFollowsSystem());
            return AccentColorRule.fromColor((Color)accentColor, (Color)selectionColor);
        }

        private Color getAccentColor(Theme theme, boolean useThemeColor) {
            return theme.supportsCustomAccentColor() ? (useThemeColor ? theme.getAccentColorRule().getAccentColor() : ThemeSettingsPanel.this.getSelectedColor(ThemeSettingsPanel.this.bgAccent, ThemeSettingsPanel.this.defaultAccent)) : null;
        }

        private Color getSelectionColor(Theme theme, boolean useThemeColor) {
            return theme.supportsCustomSelectionColor() ? (useThemeColor ? theme.getAccentColorRule().getSelectionColor() : ThemeSettingsPanel.this.getSelectedColor(ThemeSettingsPanel.this.bgSelection, ThemeSettingsPanel.this.defaultSelection)) : null;
        }

        @Override
        public FontSizeRule getFontSizeRule() {
            PreferredThemeStyle preferredThemeStyle = LafManager.getPreferredThemeStyle();
            return this.getFontSizeRule(this.getTheme(preferredThemeStyle), preferredThemeStyle);
        }

        private FontSizeRule getFontSizeRule(Theme theme, PreferredThemeStyle preferredThemeStyle) {
            if (theme == null) {
                return FontSizeRule.getDefault();
            }
            return this.isFontSizeFollowsSystem() ? preferredThemeStyle.getFontSizeRule() : FontSizeRule.relativeAdjustment((int)ThemeSettingsPanel.this.fontSlider.getValue());
        }

        @Override
        public Theme getTheme() {
            return this.getTheme(LafManager.getPreferredThemeStyle());
        }

        private Theme getTheme(PreferredThemeStyle preferredThemeStyle) {
            return this.isThemeFollowsSystem() ? LafManager.themeForPreferredStyle(preferredThemeStyle) : this.getSelectedTheme();
        }

        private Theme getSelectedTheme() {
            return (Theme)ThemeSettingsPanel.this.themeComboBox.getSelectedItem();
        }

        @Override
        public void setSystemPreferencesEnabled(boolean enabled) {
            TristateState state = TristateState.DESELECTED;
            if (!(!enabled || !this.isFontSizeFollowsSystem() && ThemeSettingsPanel.this.fontSizeFollowsSystem.isEnabled() || !this.isThemeFollowsSystem() && ThemeSettingsPanel.this.themeFollowsSystem.isEnabled() || !this.isAccentColorFollowsSystem() && ThemeSettingsPanel.this.accentColorFollowsSystem.isEnabled() || !this.isSelectionColorFollowsSystem() && ThemeSettingsPanel.this.selectionColorFollowsSystem.isEnabled())) {
                state = TristateState.SELECTED;
            } else if (enabled) {
                ThemeSettingsPanel.this.enabledSystemPreferences.getTristateModel().setIndeterminate();
                return;
            }
            ThemeSettingsPanel.this.enabledSystemPreferences.getTristateModel().setState(state);
        }

        @Override
        public void setAccentColorFollowsSystem(boolean accentColorFollowsSystem) {
            ThemeSettingsPanel.this.accentColorFollowsSystem.setSelected(accentColorFollowsSystem);
        }

        @Override
        public void setFontSizeFollowsSystem(boolean fontSizeFollowsSystem) {
            ThemeSettingsPanel.this.fontSizeFollowsSystem.setSelected(fontSizeFollowsSystem);
        }

        @Override
        public void setSelectionColorFollowsSystem(boolean selectionColorFollowsSystem) {
            ThemeSettingsPanel.this.selectionColorFollowsSystem.setSelected(selectionColorFollowsSystem);
        }

        @Override
        public void setThemeFollowsSystem(boolean themeFollowsSystem) {
            ThemeSettingsPanel.this.themeFollowsSystem.setSelected(themeFollowsSystem);
        }

        @Override
        public void setAccentColorRule(AccentColorRule accentColorRule) {
            if (accentColorRule == null) {
                this.setAccentColorRule(null, null);
            } else {
                this.setAccentColorRule(accentColorRule.getAccentColor(), accentColorRule.getSelectionColor());
            }
        }

        protected void setAccentColorRule(Color accentColor, Color selectionColor) {
            ThemeSettingsPanel.this.setAccentColor(accentColor);
            ThemeSettingsPanel.this.setSelectionColor(selectionColor);
        }

        @Override
        public void setFontSizeRule(FontSizeRule fontSizeRule) {
            if (fontSizeRule == null) {
                ThemeSettingsPanel.this.fontSlider.setValue(FontSizePreset.NORMAL.getPercentage());
            } else {
                ThemeSettingsPanel.this.fontSlider.setValue(fontSizeRule.getPercentage());
            }
        }

        @Override
        public void setTheme(Theme theme) {
            ThemeSettingsPanel.this.themeComboBox.setSelectedItem(LafManager.getClosestMatchForTheme(theme));
        }
    }
}

