/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.jmeter.control.WhileController;
import org.apache.jmeter.control.gui.AbstractControllerGui;
import org.apache.jmeter.gui.GUIMenuSortOrder;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.gui.util.JSyntaxTextArea;
import org.apache.jmeter.gui.util.JTextScrollPane;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;

@GUIMenuSortOrder(value=4)
@TestElementMetadata(labelResource="while_controller_title")
public class WhileControllerGui
extends AbstractControllerGui {
    private static final long serialVersionUID = 240L;
    private JSyntaxTextArea theCondition;
    private static final String CONDITION = "While_Condition";

    public WhileControllerGui() {
        this.init();
    }

    @Override
    public void configure(TestElement element) {
        super.configure(element);
        if (element instanceof WhileController) {
            this.theCondition.setText(((WhileController)element).getCondition());
        }
    }

    @Override
    public TestElement createTestElement() {
        WhileController controller = new WhileController();
        this.modifyTestElement(controller);
        return controller;
    }

    @Override
    public void modifyTestElement(TestElement controller) {
        this.configureTestElement(controller);
        if (controller instanceof WhileController) {
            if (this.theCondition.getText().length() > 0) {
                ((WhileController)controller).setCondition(this.theCondition.getText());
            } else {
                ((WhileController)controller).setCondition("");
            }
        }
    }

    @Override
    public void clearGui() {
        super.clearGui();
        this.theCondition.setText("");
    }

    @Override
    public String getLabelResource() {
        return "while_controller_title";
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add((Component)this.makeTitlePanel(), "North");
        this.add((Component)this.createConditionPanel(), "Center");
    }

    private JPanel createConditionPanel() {
        JPanel conditionPanel = new JPanel((LayoutManager)new MigLayout("fillx, wrap 2, insets 0", "[][fill,grow]"));
        this.theCondition = JSyntaxTextArea.getInstance(5, 50);
        JTextScrollPane theConditionJSP = JTextScrollPane.getInstance(this.theCondition);
        conditionPanel.add(JMeterUtils.labelFor((Component)((Object)theConditionJSP), "while_controller_label"));
        this.theCondition.setName(CONDITION);
        conditionPanel.add((Component)((Object)theConditionJSP));
        return conditionPanel;
    }
}

