/*
 * Decompiled with CFR 0.152.
 */
package io.burt.jmespath.node;

import io.burt.jmespath.Adapter;
import io.burt.jmespath.node.Node;

public class JsonLiteralNode<T>
extends Node<T> {
    private final String rawValue;
    private final T value;

    public JsonLiteralNode(Adapter<T> runtime, String rawValue) {
        super(runtime);
        this.rawValue = rawValue;
        this.value = runtime.parseString(rawValue);
    }

    @Override
    public T search(T input) {
        return this.value;
    }

    @Override
    protected String internalToString() {
        return this.rawValue;
    }

    @Override
    protected boolean internalEquals(Object o) {
        JsonLiteralNode other = (JsonLiteralNode)o;
        return this.rawValue.equals(other.rawValue);
    }

    @Override
    protected int internalHashCode() {
        return this.rawValue.hashCode();
    }
}

