/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.icons;

import com.github.weisj.darklaf.icons.IconLoader;
import com.github.weisj.darklaf.util.ColorUtil;
import com.github.weisj.darklaf.util.LogUtil;
import com.github.weisj.darklaf.util.Pair;
import com.kitfox.svg.Defs;
import com.kitfox.svg.LinearGradient;
import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGElement;
import com.kitfox.svg.SVGElementException;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.SVGRoot;
import com.kitfox.svg.SVGUniverse;
import com.kitfox.svg.Stop;
import com.kitfox.svg.app.beans.SVGIcon;
import com.kitfox.svg.xml.StyleAttribute;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.UIManager;

public final class IconColorMapper {
    private static final Logger LOGGER = LogUtil.getLogger(IconLoader.class);
    private static final Color FALLBACK_COLOR = Color.RED;

    public static void patchColors(SVGIcon svgIcon) {
        IconColorMapper.patchColors(svgIcon, UIManager.getDefaults());
    }

    public static void patchColors(SVGIcon svgIcon, Map<Object, Object> defaults) {
        SVGUniverse universe = svgIcon.getSvgUniverse();
        SVGDiagram diagram = universe.getDiagram(svgIcon.getSvgURI());
        LOGGER.finer(() -> "Patching colors of icon " + svgIcon.getSvgURI());
        try {
            IconColorMapper.loadColors(diagram, defaults);
        }
        catch (SVGElementException e) {
            LOGGER.log(Level.SEVERE, "Failed patching colors. " + e.getMessage(), e.getStackTrace());
        }
    }

    private static void loadColors(SVGDiagram diagram, Map<Object, Object> defaults) throws SVGElementException {
        SVGRoot root = diagram.getRoot();
        SVGElement defs = diagram.getElement("colors");
        if (defs == null) {
            LOGGER.info(() -> {
                String uri = diagram.getXMLBase().toASCIIString();
                String name = uri.substring(Math.min(uri.lastIndexOf(47) + 1, uri.length() - 1));
                return "Themed icon '" + name + "' has no color definitions. Consider loading it as a standard icon or add missing definitions";
            });
            return;
        }
        List children = defs.getChildren(null);
        root.removeChild(defs);
        Defs themedDefs = new Defs();
        themedDefs.addAttribute("id", 1, "colors");
        root.loaderAddChild(null, (SVGElement)themedDefs);
        for (Object child : children) {
            float opacity;
            if (!(child instanceof LinearGradient)) continue;
            LinearGradient grad = (LinearGradient)child;
            String id = grad.getId();
            StyleAttribute colorFallbacks = IconColorMapper.getAttribute("fallback", grad);
            StyleAttribute opacityFallbacks = IconColorMapper.getAttribute("opacity-fallback", grad);
            String opacityKey = IconColorMapper.getOpacityKey(grad);
            float opacity1 = opacity = IconColorMapper.getOpacity(opacityKey, IconColorMapper.getFallbacks(opacityFallbacks), defaults);
            float opacity2 = opacity;
            if (opacity < 0.0f) {
                SVGElement elem;
                opacity = 1.0f;
                int childCount = grad.getNumChildren();
                if (childCount > 0 && (elem = grad.getChild(0)) instanceof Stop) {
                    opacity1 = IconColorMapper.getStopOpacity((Stop)elem);
                }
                if (childCount > 1 && (elem = grad.getChild(1)) instanceof Stop) {
                    opacity2 = IconColorMapper.getStopOpacity((Stop)elem);
                }
                if (opacity1 < 0.0f) {
                    opacity1 = opacity;
                }
                if (opacity2 < 0.0f) {
                    opacity2 = opacity;
                }
            }
            Color c = IconColorMapper.resolveColor(id, IconColorMapper.getFallbacks(colorFallbacks), FALLBACK_COLOR, defaults);
            Pair<LinearGradient, Runnable> result = IconColorMapper.createColor(c, id, opacityKey, colorFallbacks, opacity1, opacity2);
            LinearGradient gradient = (LinearGradient)result.getFirst();
            Runnable finalizer = (Runnable)result.getSecond();
            themedDefs.loaderAddChild(null, (SVGElement)gradient);
            finalizer.run();
        }
    }

    public static float getOpacity(LinearGradient gradient, Map<Object, Object> propertyMap) {
        String opacityKey = IconColorMapper.getOpacityKey(gradient);
        return IconColorMapper.getOpacity(opacityKey, null, propertyMap);
    }

    public static Color getColor(LinearGradient gradient, Map<Object, Object> propertyMap) {
        String id = gradient.getId();
        StyleAttribute fallbacks = IconColorMapper.getAttribute("fallback", gradient);
        return IconColorMapper.resolveColor(id, IconColorMapper.getFallbacks(fallbacks), FALLBACK_COLOR, propertyMap);
    }

    private static Color resolveColor(String key, String[] fallbacks, Color fallbackColor, Map<Object, Object> propertyMap) {
        Color color = IconColorMapper.get(propertyMap, key, fallbacks, Color.class);
        if (color == null) {
            color = fallbackColor;
            LOGGER.warning("Could not load color with id '" + key + "' fallbacks" + Arrays.toString(fallbacks) + ". Using color '" + fallbackColor + "' instead.");
        }
        return color;
    }

    private static StyleAttribute getAttribute(String key, LinearGradient child) {
        StyleAttribute attribute = new StyleAttribute();
        attribute.setName(key);
        try {
            child.getStyle(attribute);
        }
        catch (SVGException e) {
            return null;
        }
        return attribute;
    }

    private static float getStopOpacity(Stop stop) {
        StyleAttribute attribute = new StyleAttribute();
        attribute.setName("stop-opacity");
        try {
            stop.getStyle(attribute);
        }
        catch (SVGException e) {
            return -1.0f;
        }
        return !attribute.getStringValue().isEmpty() ? attribute.getFloatValue() : -1.0f;
    }

    private static String[] getFallbacks(StyleAttribute fallbacks) {
        if (fallbacks == null) {
            return new String[0];
        }
        return fallbacks.getStringList();
    }

    private static float getOpacity(String key, String[] fallbacks, Map<Object, Object> propertyMap) {
        if (!(key != null && !key.isEmpty() || fallbacks != null && fallbacks.length != 0)) {
            return -1.0f;
        }
        Number obj = IconColorMapper.get(propertyMap, key, fallbacks, Number.class);
        if (obj instanceof Integer) {
            return (float)obj.intValue() / 100.0f;
        }
        if (obj instanceof Long) {
            return (float)obj.intValue() / 100.0f;
        }
        if (obj instanceof Float) {
            return obj.floatValue();
        }
        if (obj instanceof Double) {
            return obj.floatValue();
        }
        LOGGER.warning(obj + " is an invalid opacity value. Key = '" + key + "'");
        return -1.0f;
    }

    private static String getOpacityKey(LinearGradient child) {
        StyleAttribute attribute = new StyleAttribute();
        attribute.setName("opacity");
        try {
            child.getStyle(attribute);
        }
        catch (SVGException e) {
            e.printStackTrace();
            return null;
        }
        return attribute.getStringValue();
    }

    private static Pair<LinearGradient, Runnable> createColor(Color c, String name, String opacityKey, StyleAttribute fallbacks, float opacity1, float opacity2) throws SVGElementException {
        LinearGradient grad = new LinearGradient();
        grad.addAttribute("id", 1, name);
        if (opacityKey != null && !opacityKey.isEmpty()) {
            grad.addAttribute("opacity", 1, opacityKey);
        }
        if (fallbacks != null && !fallbacks.getStringValue().isEmpty()) {
            grad.addAttribute(fallbacks.getName(), 1, fallbacks.getStringValue());
        }
        return new Pair((Object)grad, () -> {
            Stop stop1 = new Stop();
            Stop stop2 = new Stop();
            String color = IconColorMapper.toHexString(c);
            try {
                stop1.addAttribute("stop-color", 1, color);
                stop1.addAttribute("offset", 1, "0");
                stop2.addAttribute("stop-color", 1, color);
                stop2.addAttribute("offset", 1, "1");
                if (opacity1 != 1.0f) {
                    stop1.addAttribute("stop-opacity", 1, String.valueOf(opacity1));
                }
                if (opacity2 != 1.0f) {
                    stop2.addAttribute("stop-opacity", 1, String.valueOf(opacity2));
                }
                grad.loaderAddChild(null, (SVGElement)stop1);
                grad.loaderAddChild(null, (SVGElement)stop2);
            }
            catch (SVGException e) {
                e.printStackTrace();
            }
        });
    }

    private static <T> T get(Map<Object, Object> map, Object key, Class<T> type) {
        return IconColorMapper.getFromMap(map, key, null, type);
    }

    private static <T> T get(Map<Object, Object> map, Object key, Object[] fallbacks, Class<T> type) {
        T obj = IconColorMapper.getFromMap(map, key, fallbacks, type);
        if (obj == null) {
            return IconColorMapper.getFromMap(UIManager.getDefaults(), key, fallbacks, type);
        }
        return obj;
    }

    private static <T> T getFromMap(Map<Object, Object> map, Object key, Object[] fallbacks, Class<T> type) {
        Object obj = map.get(key);
        if (fallbacks != null) {
            for (int i = 0; i < fallbacks.length && !type.isInstance(obj); ++i) {
                obj = map.get(fallbacks[i]);
            }
        }
        if (type.isInstance(obj)) {
            return type.cast(obj);
        }
        return null;
    }

    private static String toHexString(Color color) {
        return "#" + ColorUtil.toHex((Color)color);
    }
}

