/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.processor;

import java.math.BigDecimal;
import org.apache.jmeter.report.core.Sample;
import org.apache.jmeter.report.processor.AbstractSummaryConsumer;
import org.apache.jmeter.report.processor.ListResultData;
import org.apache.jmeter.report.processor.StatisticsSummaryData;
import org.apache.jmeter.report.processor.ValueResultData;
import org.apache.jmeter.util.JMeterUtils;

public class StatisticsSummaryConsumer
extends AbstractSummaryConsumer<StatisticsSummaryData> {
    private static final String PCT1_LABEL = JMeterUtils.getPropDefault("aggregate_rpt_pct1", "90");
    private static final String PCT2_LABEL = JMeterUtils.getPropDefault("aggregate_rpt_pct2", "95");
    private static final String PCT3_LABEL = JMeterUtils.getPropDefault("aggregate_rpt_pct3", "99");
    private static final double PERCENTILE_INDEX1 = new BigDecimal(PCT1_LABEL).doubleValue();
    private static final double PERCENTILE_INDEX2 = new BigDecimal(PCT2_LABEL).doubleValue();
    private static final double PERCENTILE_INDEX3 = new BigDecimal(PCT3_LABEL).doubleValue();

    public StatisticsSummaryConsumer() {
        super(true);
    }

    private void aggregateSample(Sample sample, StatisticsSummaryData data, boolean isOverall) {
        if (isOverall && sample.isController()) {
            return;
        }
        data.incTotal();
        data.incBytes(sample.getReceivedBytes());
        data.incSentBytes(sample.getSentBytes());
        if (!sample.getSuccess()) {
            data.incErrors();
        }
        long elapsedTime = sample.getElapsedTime();
        data.getPercentile1().addValue(elapsedTime);
        data.getPercentile2().addValue(elapsedTime);
        data.getPercentile3().addValue(elapsedTime);
        data.getMean().addValue(elapsedTime);
        data.getMedian().addValue(elapsedTime);
        data.setMin(elapsedTime);
        data.setMax(elapsedTime);
        data.setFirstTime(sample.getStartTime());
        data.setEndTime(sample.getEndTime());
    }

    @Override
    protected void updateData(AbstractSummaryConsumer.SummaryInfo info, Sample sample) {
        StatisticsSummaryData data;
        AbstractSummaryConsumer.SummaryInfo overallInfo = this.getOverallInfo();
        StatisticsSummaryData overallData = (StatisticsSummaryData)overallInfo.getData();
        if (overallData == null) {
            overallData = new StatisticsSummaryData(PERCENTILE_INDEX1, PERCENTILE_INDEX2, PERCENTILE_INDEX3);
            overallInfo.setData(overallData);
        }
        if ((data = (StatisticsSummaryData)info.getData()) == null) {
            data = new StatisticsSummaryData(PERCENTILE_INDEX1, PERCENTILE_INDEX2, PERCENTILE_INDEX3);
            info.setData(data);
        }
        if (!sample.isEmptyController()) {
            this.aggregateSample(sample, data, false);
            this.aggregateSample(sample, overallData, true);
        }
    }

    @Override
    protected ListResultData createDataResult(String key, StatisticsSummaryData data) {
        ListResultData result = new ListResultData();
        result.addResult(new ValueResultData(key != null ? key : JMeterUtils.getResString("reportgenerator_summary_total")));
        long total = data.getTotal();
        long errors = data.getErrors();
        result.addResult(new ValueResultData(total));
        result.addResult(new ValueResultData(errors));
        result.addResult(new ValueResultData((double)errors * 100.0 / (double)total));
        result.addResult(new ValueResultData(data.getMean().getResult()));
        result.addResult(new ValueResultData(data.getMin()));
        result.addResult(new ValueResultData(data.getMax()));
        result.addResult(new ValueResultData(data.getMedian().getResult()));
        result.addResult(new ValueResultData(data.getPercentile1().getResult()));
        result.addResult(new ValueResultData(data.getPercentile2().getResult()));
        result.addResult(new ValueResultData(data.getPercentile3().getResult()));
        result.addResult(new ValueResultData(data.getThroughput()));
        result.addResult(new ValueResultData(data.getKBytesPerSecond()));
        result.addResult(new ValueResultData(data.getSentKBytesPerSecond()));
        return result;
    }

    @Override
    protected String getKeyFromSample(Sample sample) {
        return sample.getName();
    }

    @Override
    protected ListResultData createResultTitles() {
        ListResultData titles = new ListResultData();
        titles.addResult(new ValueResultData(JMeterUtils.getResString("reportgenerator_summary_statistics_label")));
        titles.addResult(new ValueResultData(JMeterUtils.getResString("reportgenerator_summary_statistics_count")));
        titles.addResult(new ValueResultData(JMeterUtils.getResString("reportgenerator_summary_statistics_error_count")));
        titles.addResult(new ValueResultData(JMeterUtils.getResString("reportgenerator_summary_statistics_error_percent")));
        titles.addResult(new ValueResultData(JMeterUtils.getResString("reportgenerator_summary_statistics_mean")));
        titles.addResult(new ValueResultData(JMeterUtils.getResString("reportgenerator_summary_statistics_min")));
        titles.addResult(new ValueResultData(JMeterUtils.getResString("reportgenerator_summary_statistics_max")));
        titles.addResult(new ValueResultData(JMeterUtils.getResString("reportgenerator_summary_statistics_median")));
        titles.addResult(new ValueResultData(this.formatPercentile(PCT1_LABEL)));
        titles.addResult(new ValueResultData(this.formatPercentile(PCT2_LABEL)));
        titles.addResult(new ValueResultData(this.formatPercentile(PCT3_LABEL)));
        titles.addResult(new ValueResultData(JMeterUtils.getResString("reportgenerator_summary_statistics_throughput")));
        titles.addResult(new ValueResultData(JMeterUtils.getResString("reportgenerator_summary_statistics_kbytes")));
        titles.addResult(new ValueResultData(JMeterUtils.getResString("reportgenerator_summary_statistics_sent_kbytes")));
        return titles;
    }

    private String formatPercentile(String percentileLabel) {
        return String.format(JMeterUtils.getResString("reportgenerator_summary_statistics_percentile_fmt"), percentileLabel);
    }
}

