/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.stream;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.ArrayHelper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.InputStream;
import java.io.Serializable;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class NonBlockingByteArrayInputStream
extends InputStream
implements Serializable {
    public static final boolean DEFAULT_COPY_NEEDED = false;
    protected byte[] m_aBuf;
    protected int m_nPos;
    protected int m_nMark;
    protected int m_nCount;
    private final boolean m_bIsCopy;

    public NonBlockingByteArrayInputStream(@Nonnull byte[] byArray) {
        this(byArray, 0, byArray.length, false);
    }

    public NonBlockingByteArrayInputStream(@Nonnull byte[] byArray, boolean bl) {
        this(byArray, 0, byArray.length, bl);
    }

    public NonBlockingByteArrayInputStream(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        this(byArray, n, n2, false);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public NonBlockingByteArrayInputStream(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2, boolean bl) {
        ValueEnforcer.isArrayOfsLen(byArray, n, n2);
        this.m_aBuf = bl ? ArrayHelper.getCopy(byArray, n, n2) : byArray;
        this.m_nPos = bl ? 0 : n;
        this.m_nCount = bl ? n2 : Math.min(n + n2, byArray.length);
        this.m_nMark = this.m_nPos;
        this.m_bIsCopy = bl;
    }

    public final boolean isCopy() {
        return this.m_bIsCopy;
    }

    @Override
    public int read() {
        if (this.m_nPos >= this.m_nCount) {
            return -1;
        }
        int n = this.m_aBuf[this.m_nPos] & 0xFF;
        ++this.m_nPos;
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        int n3;
        ValueEnforcer.isArrayOfsLen(byArray, n, n2);
        if (this.m_nPos >= this.m_nCount) {
            return -1;
        }
        int n4 = n3 = this.m_nPos + n2 > this.m_nCount ? this.m_nCount - this.m_nPos : n2;
        if (n3 <= 0) {
            return 0;
        }
        System.arraycopy(this.m_aBuf, this.m_nPos, byArray, n, n3);
        this.m_nPos += n3;
        return n3;
    }

    @Override
    public long skip(long l) {
        long l2;
        long l3 = l2 = (long)this.m_nPos + l > (long)this.m_nCount ? (long)(this.m_nCount - this.m_nPos) : l;
        if (l2 <= 0L) {
            return 0L;
        }
        this.m_nPos += (int)l2;
        return l2;
    }

    @Override
    public int available() {
        return this.m_nCount - this.m_nPos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int n) {
        this.m_nMark = this.m_nPos;
    }

    @Override
    public void reset() {
        this.m_nPos = this.m_nMark;
    }

    @Override
    public void close() {
    }

    @Nonnegative
    public int getPosition() {
        return this.m_nPos;
    }
}

