/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.concurrent;

import com.helger.commons.callback.IThrowingRunnable;
import com.helger.commons.functional.IThrowingSupplier;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class SimpleReadWriteLock
extends ReentrantReadWriteLock {
    public SimpleReadWriteLock() {
    }

    public SimpleReadWriteLock(boolean bl) {
        super(bl);
    }

    @Deprecated
    public <T> T readLocked(@Nonnull Supplier<? extends T> supplier) {
        return this.readLockedGet(supplier);
    }

    public <T> T readLockedGet(@Nonnull Supplier<? extends T> supplier) {
        this.readLock().lock();
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            this.readLock().unlock();
        }
    }

    public void readLocked(@Nonnull Runnable runnable) {
        this.readLock().lock();
        try {
            runnable.run();
        }
        finally {
            this.readLock().unlock();
        }
    }

    public <EXTYPE extends Exception> void readLockedThrowing(@Nonnull IThrowingRunnable<EXTYPE> iThrowingRunnable) throws EXTYPE {
        this.readLock().lock();
        try {
            iThrowingRunnable.run();
        }
        finally {
            this.readLock().unlock();
        }
    }

    @Deprecated
    public <T, EXTYPE extends Exception> T readLockedThrowing(@Nonnull IThrowingSupplier<? extends T, EXTYPE> iThrowingSupplier) throws EXTYPE {
        return this.readLockedGetThrowing(iThrowingSupplier);
    }

    public <T, EXTYPE extends Exception> T readLockedGetThrowing(@Nonnull IThrowingSupplier<? extends T, EXTYPE> iThrowingSupplier) throws EXTYPE {
        this.readLock().lock();
        try {
            T t = iThrowingSupplier.get();
            return t;
        }
        finally {
            this.readLock().unlock();
        }
    }

    @Deprecated
    public boolean readLocked(@Nonnull BooleanSupplier booleanSupplier) {
        return this.readLockedBoolean(booleanSupplier);
    }

    public boolean readLockedBoolean(@Nonnull BooleanSupplier booleanSupplier) {
        this.readLock().lock();
        try {
            boolean bl = booleanSupplier.getAsBoolean();
            return bl;
        }
        finally {
            this.readLock().unlock();
        }
    }

    @Deprecated
    public double readLocked(@Nonnull DoubleSupplier doubleSupplier) {
        return this.readLockedDouble(doubleSupplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double readLockedDouble(@Nonnull DoubleSupplier doubleSupplier) {
        this.readLock().lock();
        try {
            double d = doubleSupplier.getAsDouble();
            return d;
        }
        finally {
            this.readLock().unlock();
        }
    }

    @Deprecated
    public int readLocked(@Nonnull IntSupplier intSupplier) {
        return this.readLockedInt(intSupplier);
    }

    public int readLockedInt(@Nonnull IntSupplier intSupplier) {
        this.readLock().lock();
        try {
            int n = intSupplier.getAsInt();
            return n;
        }
        finally {
            this.readLock().unlock();
        }
    }

    @Deprecated
    public long readLocked(@Nonnull LongSupplier longSupplier) {
        return this.readLockedLong(longSupplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long readLockedLong(@Nonnull LongSupplier longSupplier) {
        this.readLock().lock();
        try {
            long l = longSupplier.getAsLong();
            return l;
        }
        finally {
            this.readLock().unlock();
        }
    }

    public void writeLocked(@Nonnull Runnable runnable) {
        this.writeLock().lock();
        try {
            runnable.run();
        }
        finally {
            this.writeLock().unlock();
        }
    }

    public <EXTYPE extends Exception> void writeLockedThrowing(@Nonnull IThrowingRunnable<EXTYPE> iThrowingRunnable) throws EXTYPE {
        this.writeLock().lock();
        try {
            iThrowingRunnable.run();
        }
        finally {
            this.writeLock().unlock();
        }
    }

    @Deprecated
    public <T> T writeLocked(@Nonnull Supplier<? extends T> supplier) {
        return this.writeLockedGet(supplier);
    }

    public <T> T writeLockedGet(@Nonnull Supplier<? extends T> supplier) {
        this.writeLock().lock();
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    @Deprecated
    public <T, EXTYPE extends Exception> T writeLockedThrowing(@Nonnull IThrowingSupplier<? extends T, EXTYPE> iThrowingSupplier) throws EXTYPE {
        return this.writeLockedGetThrowing(iThrowingSupplier);
    }

    public <T, EXTYPE extends Exception> T writeLockedGetThrowing(@Nonnull IThrowingSupplier<? extends T, EXTYPE> iThrowingSupplier) throws EXTYPE {
        this.writeLock().lock();
        try {
            T t = iThrowingSupplier.get();
            return t;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    @Deprecated
    public boolean writeLocked(@Nonnull BooleanSupplier booleanSupplier) {
        return this.writeLockedBoolean(booleanSupplier);
    }

    public boolean writeLockedBoolean(@Nonnull BooleanSupplier booleanSupplier) {
        this.writeLock().lock();
        try {
            boolean bl = booleanSupplier.getAsBoolean();
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    @Deprecated
    public double writeLocked(@Nonnull DoubleSupplier doubleSupplier) {
        return this.writeLockedDouble(doubleSupplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double writeLockedDouble(@Nonnull DoubleSupplier doubleSupplier) {
        this.writeLock().lock();
        try {
            double d = doubleSupplier.getAsDouble();
            return d;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    @Deprecated
    public int writeLocked(@Nonnull IntSupplier intSupplier) {
        return this.writeLockedInt(intSupplier);
    }

    public int writeLockedInt(@Nonnull IntSupplier intSupplier) {
        this.writeLock().lock();
        try {
            int n = intSupplier.getAsInt();
            return n;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    @Deprecated
    public long writeLocked(@Nonnull LongSupplier longSupplier) {
        return this.writeLockedLong(longSupplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long writeLockedLong(@Nonnull LongSupplier longSupplier) {
        this.writeLock().lock();
        try {
            long l = longSupplier.getAsLong();
            return l;
        }
        finally {
            this.writeLock().unlock();
        }
    }
}

