/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.tree;

import com.github.weisj.darklaf.graphics.PaintUtil;
import com.github.weisj.darklaf.icons.RotatableIcon;
import com.github.weisj.darklaf.ui.cell.CellConstants;
import com.github.weisj.darklaf.ui.cell.CellUtil;
import com.github.weisj.darklaf.ui.cell.DarkCellRendererPane;
import com.github.weisj.darklaf.ui.cell.hint.CellHintPopupListener;
import com.github.weisj.darklaf.ui.tree.DarkDefaultTreeEditor;
import com.github.weisj.darklaf.ui.tree.DarkTreeCellRendererDelegate;
import com.github.weisj.darklaf.ui.tree.DarkTreeExpansionAnimationListener;
import com.github.weisj.darklaf.ui.tree.TreeCellContainer;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.PropertyUtil;
import com.github.weisj.darklaf.util.SystemInfo;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class DarkTreeUI
extends BasicTreeUI
implements PropertyChangeListener,
CellConstants {
    protected static final String KEY_PREFIX = "JTree.";
    public static final String KEY_ALTERNATE_ROW_COLOR = "JTree.alternateRowColor";
    public static final String KEY_RENDER_BOOLEAN_AS_CHECKBOX = "JTree.renderBooleanAsCheckBox";
    public static final String KEY_BOOLEAN_RENDER_TYPE = "JTree.booleanRenderType";
    public static final String KEY_LINE_STYLE = "JTree.lineStyle";
    public static final String KEY_MAC_ACTIONS_INSTALLED = "MacTreeUi.actionsInstalled";
    public static final String STYLE_LINE = "line";
    public static final String STYLE_DASHED = "dashed";
    public static final String STYLE_NONE = "none";
    public static final String KEY_IS_TREE_EDITOR = "JComponent.isTreeEditor";
    public static final String KEY_IS_TREE_RENDERER = "JComponent.isTreeRenderer";
    public static final String KEY_IS_TABLE_TREE = "JComponent.isTableTree";
    protected static final Rectangle boundsBuffer = new Rectangle();
    protected static final RotatableIcon paintingIcon = new RotatableIcon();
    protected MouseListener selectionListener;
    protected Color lineColor;
    protected Color focusSelectedLineColor;
    protected Color selectedLineColor;
    protected Icon expandedFocusSelected;
    protected Icon expandedSelected;
    protected Icon expandedFocus;
    protected Icon expanded;
    protected Icon expandedDisabled;
    protected Icon collapsedFocusSelected;
    protected Icon collapsedSelected;
    protected Icon collapsedFocus;
    protected Icon collapsed;
    protected Icon collapsedDisabled;
    protected Insets leadSelectionBorderInsets;
    private boolean oldRepaintAllRowValue;
    protected CellHintPopupListener<JTree, ?> popupListener;
    protected DarkTreeCellRendererDelegate rendererDelegate;
    private int dashLength;
    private int dashGapLength;
    private DarkTreeExpansionAnimationListener treeExpansionAnimationListener;

    public static ComponentUI createUI(JComponent c) {
        return new DarkTreeUI();
    }

    protected boolean isSelected(MouseEvent e) {
        JTree tree = (JTree)e.getSource();
        int selected = tree.getClosestRowForLocation(e.getX(), e.getY());
        int[] rows = tree.getSelectionRows();
        if (rows != null) {
            for (int row : rows) {
                if (row != selected) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void completeUIInstall() {
        super.completeUIInstall();
        this.oldRepaintAllRowValue = UIManager.getBoolean("Tree.repaintWholeRow");
        UIManager.put("Tree.repaintWholeRow", true);
        this.tree.putClientProperty(KEY_ALTERNATE_ROW_COLOR, UIManager.getBoolean("Tree.alternateRowColor"));
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.rendererDelegate = new DarkTreeCellRendererDelegate(null);
        this.rendererPane = this.createCellRendererPane();
        LookAndFeel.installColors(this.tree, "Tree.background", "Tree.foreground");
        this.focusSelectedLineColor = UIManager.getColor("Tree.lineFocusSelected");
        this.selectedLineColor = UIManager.getColor("Tree.lineSelected");
        this.lineColor = UIManager.getColor("Tree.lineUnselected");
        this.expandedFocusSelected = UIManager.getIcon("Tree.expanded.selected.focused.icon");
        this.expandedSelected = UIManager.getIcon("Tree.expanded.selected.unfocused.icon");
        this.expandedFocus = UIManager.getIcon("Tree.expanded.unselected.focused.icon");
        this.expanded = UIManager.getIcon("Tree.expanded.unselected.unfocused.icon");
        this.expandedDisabled = UIManager.getIcon("Tree.expanded.disabled.icon");
        this.collapsedFocusSelected = UIManager.getIcon("Tree.collapsed.selected.focused.icon");
        this.collapsedSelected = UIManager.getIcon("Tree.collapsed.selected.unfocused.icon");
        this.collapsedFocus = UIManager.getIcon("Tree.collapsed.unselected.focused.icon");
        this.collapsed = UIManager.getIcon("Tree.collapsed.unselected.unfocused.icon");
        this.collapsedDisabled = UIManager.getIcon("Tree.collapsed.disabled.icon");
        this.leadSelectionBorderInsets = UIManager.getInsets("Tree.leadSelectionBorderInsets");
        if (this.leadSelectionBorderInsets == null) {
            this.leadSelectionBorderInsets = new Insets(1, 1, 1, 1);
        }
        PropertyUtil.installBooleanProperty((JComponent)this.tree, (String)KEY_RENDER_BOOLEAN_AS_CHECKBOX, (String)"Tree.renderBooleanAsCheckBox");
        PropertyUtil.installProperty((JComponent)this.tree, (String)KEY_BOOLEAN_RENDER_TYPE, (Object)UIManager.getString("Tree.booleanRenderType"));
        PropertyUtil.installProperty((JComponent)this.tree, (String)KEY_LINE_STYLE, (Object)UIManager.getString("Tree.defaultLineStyle"));
        LookAndFeel.installProperty(this.tree, "showsRootHandles", true);
        this.dashLength = UIManager.getInt("Tree.dash.length");
        this.dashGapLength = UIManager.getInt("Tree.dash.gaplength");
    }

    @Override
    protected CellRendererPane createCellRendererPane() {
        return new DarkCellRendererPane();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        if (UIManager.getBoolean("Tree.showFullRowInPopup")) {
            this.popupListener = this.createPopupMouseListener();
            this.popupListener.install();
        }
        this.tree.addPropertyChangeListener(this);
        this.selectionListener = this.createMouseSelectionListener();
        this.tree.addMouseListener(this.selectionListener);
        this.treeExpansionAnimationListener = this.createExpansionAnimationListener();
        this.tree.addTreeExpansionListener(this.treeExpansionAnimationListener);
    }

    protected DarkTreeExpansionAnimationListener createExpansionAnimationListener() {
        return new DarkTreeExpansionAnimationListener(this.tree);
    }

    protected MouseListener createMouseSelectionListener() {
        return new DarkTreeMouseListener();
    }

    protected CellHintPopupListener<JTree, ?> createPopupMouseListener() {
        return new CellHintPopupListener<JTree, Integer>(new TreeCellContainer(this.tree, this));
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        TreeUIAction.installActions(this.tree);
    }

    @Override
    protected FocusListener createFocusListener() {
        return new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                DarkTreeUI.this.tree.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                boolean focused = DarkTreeUI.this.hasFocus(e != null ? e.getOppositeComponent() : null);
                if (!focused) {
                    DarkTreeUI.this.tree.stopEditing();
                    DarkTreeUI.this.tree.repaint();
                }
            }
        };
    }

    protected boolean hasFocus() {
        return this.hasFocus(null);
    }

    protected boolean hasFocus(Component other) {
        Component owner = other;
        if (!DarkUIUtil.hasFocus(this.tree)) {
            boolean treeEditor;
            if (owner == null) {
                owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            }
            boolean treeRenderer = !(treeEditor = PropertyUtil.getBooleanProperty((Component)owner, (String)KEY_IS_TREE_EDITOR)) && PropertyUtil.getBooleanProperty((Component)owner, (String)KEY_IS_TREE_RENDERER);
            return treeEditor || treeRenderer;
        }
        return true;
    }

    @Override
    protected TreeCellEditor createDefaultCellEditor() {
        if (this.currentCellRenderer instanceof DefaultTreeCellRenderer) {
            return new DarkDefaultTreeEditor(this.tree, (DefaultTreeCellRenderer)this.currentCellRenderer);
        }
        return new DarkDefaultTreeEditor(this.tree, null);
    }

    @Override
    protected TreeCellRenderer createDefaultCellRenderer() {
        TreeCellRenderer renderer = super.createDefaultCellRenderer();
        this.rendererDelegate.setDelegate(renderer);
        return renderer;
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        UIManager.put("Tree.repaintWholeRow", this.oldRepaintAllRowValue);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this.popupListener != null) {
            this.popupListener.uninstall();
            this.popupListener = null;
        }
        this.tree.removeMouseListener(this.selectionListener);
        this.selectionListener = null;
        this.tree.removePropertyChangeListener(this);
        this.tree.removeTreeExpansionListener(this.treeExpansionAnimationListener);
        this.treeExpansionAnimationListener = null;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.tree != c) {
            throw new InternalError("incorrect component");
        }
        if (this.treeState == null) {
            return;
        }
        Rectangle paintBounds = g.getClipBounds();
        Insets insets = this.tree.getInsets();
        TreePath initialPath = this.getClosestPathForLocation(this.tree, 0, paintBounds.y);
        Enumeration<TreePath> paintingEnumerator = this.treeState.getVisiblePathsFrom(initialPath);
        if (initialPath != null && paintingEnumerator != null) {
            int row = this.treeState.getRowForPath(initialPath);
            boolean done = false;
            while (!done && paintingEnumerator.hasMoreElements()) {
                TreePath path = paintingEnumerator.nextElement();
                Rectangle cellBounds = this.paintSingleRow(g, paintBounds, insets, path, row);
                if (cellBounds == null || cellBounds.y + cellBounds.height >= paintBounds.y + paintBounds.height) {
                    done = true;
                }
                ++row;
            }
        }
        this.paintDropLine(g);
        this.rendererPane.removeAll();
    }

    public void paintRow(Graphics g, int row) {
        TreePath path = this.getPathForRow(this.tree, row);
        Rectangle paintBounds = g.getClipBounds();
        Insets insets = this.tree.getInsets();
        Rectangle rowBounds = this.getPathBounds(path, insets, boundsBuffer);
        g.translate(0, -rowBounds.y);
        paintBounds.y += rowBounds.y;
        this.paintSingleRow(g, paintBounds, insets, path, row);
        this.rendererPane.removeAll();
        g.translate(0, rowBounds.y);
    }

    protected Rectangle paintSingleRow(Graphics g, Rectangle paintBounds, Insets insets, TreePath path, int row) {
        boolean hasBeenExpanded;
        boolean isLeaf;
        if (path == null) {
            return null;
        }
        int xOffset = this.tree.getParent() instanceof JViewport ? ((JViewport)this.tree.getParent()).getViewPosition().x : 0;
        int containerWidth = this.tree.getParent() instanceof JViewport ? this.tree.getParent().getWidth() : this.tree.getWidth();
        Rectangle cellBounds = this.getPathBounds(path, insets, boundsBuffer);
        if (cellBounds == null) {
            return null;
        }
        int boundsX = cellBounds.x;
        int boundsWidth = cellBounds.width;
        boolean selected = this.tree.isPathSelected(path);
        cellBounds.x = xOffset;
        cellBounds.width = containerWidth;
        this.paintRowBackground(g, cellBounds, path, row, selected);
        cellBounds.x = boundsX;
        cellBounds.width = boundsWidth;
        if (path.getParentPath() != null) {
            this.paintVerticalLegs(g, paintBounds, cellBounds, insets, path);
        }
        boolean isExpanded = !(isLeaf = this.treeModel.isLeaf(path.getLastPathComponent())) && this.treeState.getExpandedState(path);
        boolean bl = hasBeenExpanded = !isLeaf && this.tree.hasBeenExpanded(path);
        if (this.shouldPaintExpandControl(path, row, isExpanded, hasBeenExpanded, isLeaf)) {
            this.paintExpandControl(g, paintBounds, insets, cellBounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
        }
        this.paintRow(g, paintBounds, insets, cellBounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
        if (!selected && this.tree.getLeadSelectionRow() == row && this.tree.hasFocus()) {
            g.setColor(CellUtil.getTreeBackground(this.tree, true, row));
            cellBounds.x = xOffset;
            cellBounds.width = containerWidth;
            PaintUtil.drawRect(g, cellBounds, this.leadSelectionBorderInsets);
        }
        return cellBounds;
    }

    protected void paintRowBackground(Graphics g, Rectangle bounds, TreePath path, int row, boolean selected) {
        if (path != null) {
            g.setColor(CellUtil.getTreeBackground(this.tree, selected, row));
            g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
        }
    }

    protected void paintVerticalLegs(Graphics g, Rectangle clipBounds, Rectangle rowBounds, Insets insets, TreePath path) {
        if (!this.shouldPaintLines()) {
            return;
        }
        int depth = path.getPathCount() - 1;
        if (!(depth != 0 || this.isRootVisible() && this.getShowsRootHandles())) {
            return;
        }
        int clipLeft = clipBounds.x;
        int clipRight = clipBounds.x + (clipBounds.width - 1);
        TreePath parentPath = path;
        for (int currentDepth = depth - 1; currentDepth >= 0; --currentDepth) {
            if (currentDepth == 0 && !this.isRootVisible()) continue;
            int lineX = this.getRowX(-1, currentDepth);
            lineX = this.tree.getComponentOrientation().isLeftToRight() ? lineX - this.getRightChildIndent() + insets.left : this.tree.getWidth() - lineX - insets.right + this.getRightChildIndent() - 1;
            if (lineX > clipRight || lineX < clipLeft) continue;
            parentPath = parentPath.getParentPath();
            g.setColor(this.getLineColor(parentPath));
            this.paintVerticalLine(g, this.tree, lineX, rowBounds.y, rowBounds.y + rowBounds.height);
        }
    }

    @Override
    public TreeCellRenderer getCellRenderer() {
        return super.getCellRenderer();
    }

    public Component getEditingComponent() {
        return this.editingComponent;
    }

    public int getEditingRow() {
        return this.editingRow;
    }

    protected Rectangle getPathBounds(TreePath path, Insets insets, Rectangle bounds) {
        if ((bounds = this.treeState.getBounds(path, bounds)) != null) {
            bounds.x = this.tree.getComponentOrientation().isLeftToRight() ? (bounds.x += insets.left) : this.tree.getWidth() - (bounds.x + bounds.width) - insets.right;
            bounds.y += insets.top;
        }
        return bounds;
    }

    @Override
    public void update(Graphics g, JComponent c) {
        if (this.popupListener != null) {
            this.popupListener.repaint();
        }
        super.update(g, c);
    }

    public CellHintPopupListener<JTree, ?> getPopupListener() {
        return this.popupListener;
    }

    @Override
    protected void updateRenderer() {
        super.updateRenderer();
        if (this.currentCellRenderer != this.rendererDelegate) {
            this.rendererDelegate.setDelegate(this.currentCellRenderer);
        }
        this.currentCellRenderer = this.rendererDelegate;
    }

    protected boolean shouldPaintLines() {
        return !STYLE_NONE.equals(this.getLineStyle());
    }

    protected Color getLineColor(TreePath path) {
        if (this.isChildOfSelectionPath(path)) {
            if (this.tree.isEditing() || DarkUIUtil.hasFocus(this.tree)) {
                return this.focusSelectedLineColor;
            }
            return this.selectedLineColor;
        }
        return this.lineColor;
    }

    protected Icon getExpandedIcon(boolean selected, boolean focused) {
        if (!this.tree.isEnabled()) {
            return this.expandedDisabled;
        }
        if (selected) {
            return focused ? this.expandedFocusSelected : this.expandedSelected;
        }
        return focused ? this.expandedFocus : this.expanded;
    }

    protected Icon getCollapsedIcon(boolean selected, boolean focused) {
        if (!this.tree.isEnabled()) {
            return this.collapsedDisabled;
        }
        if (selected) {
            return focused ? this.collapsedFocusSelected : this.collapsedSelected;
        }
        return focused ? this.collapsedFocus : this.collapsed;
    }

    protected String getLineStyle() {
        return PropertyUtil.getString((JComponent)this.tree, (String)KEY_LINE_STYLE, (String)"");
    }

    protected boolean isChildOfSelectionPath(TreePath path) {
        TreePath p;
        TreePath treePath = p = this.tree.isEditing() ? this.tree.getEditingPath() : this.tree.getSelectionPath();
        if (p == null) {
            return false;
        }
        if (Objects.equals(p, path)) {
            return true;
        }
        if (this.tree.isExpanded(p)) {
            return false;
        }
        TreePath parent = p.getParentPath();
        if (parent == null) {
            return false;
        }
        return Objects.equals(parent.getLastPathComponent(), path.getLastPathComponent());
    }

    protected boolean isDashedLine() {
        return STYLE_DASHED.equals(this.getLineStyle());
    }

    private void drawDashedLine(Graphics g, int x, int y1, int y2) {
        if (y1 >= y2) {
            return;
        }
        y1 += y1 % 2;
        Graphics2D g2d = (Graphics2D)g;
        Stroke oldStroke = g2d.getStroke();
        float[] dash = new float[]{this.dashLength, this.dashGapLength};
        float phase = y1 % (this.dashLength + this.dashGapLength);
        BasicStroke dashedStroke = new BasicStroke(2.0f, 0, 1, 0.0f, dash, phase);
        g2d.setStroke(dashedStroke);
        g2d.drawLine(x, y1, x, y2);
        g2d.setStroke(oldStroke);
    }

    @Override
    protected void paintHorizontalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
    }

    @Override
    protected void paintVerticalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, TreePath path) {
    }

    @Override
    protected void paintExpandControl(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        if (!this.isLeaf(row)) {
            boolean isPathSelected = this.tree.isPathSelected(path);
            this.setExpandedIcon(this.getExpandedIcon(isPathSelected, this.tree.hasFocus() || this.tree.isEditing()));
            this.setCollapsedIcon(this.getCollapsedIcon(isPathSelected, this.tree.hasFocus() || this.tree.isEditing()));
        }
        if (!isLeaf) {
            int iconCenterX = this.tree.getComponentOrientation().isLeftToRight() ? bounds.x - this.getRightChildIndent() + 1 : bounds.x + bounds.width + this.getRightChildIndent() - 1;
            int iconCenterY = bounds.y + bounds.height / 2;
            if (isExpanded) {
                Icon expIcon = this.getExpandedIcon();
                if (expIcon != null) {
                    if (Objects.equals(this.treeExpansionAnimationListener.getAnimationPath(), path)) {
                        paintingIcon.setIcon(expIcon);
                        paintingIcon.setRotation((double)(this.treeExpansionAnimationListener.getAnimationState() - 1.0f) * Math.PI / 2.0);
                        expIcon = paintingIcon;
                    }
                    this.drawCentered(this.tree, g, expIcon, iconCenterX, iconCenterY);
                }
            } else {
                Icon collIcon = this.getCollapsedIcon();
                if (collIcon != null) {
                    if (Objects.equals(this.treeExpansionAnimationListener.getAnimationPath(), path)) {
                        paintingIcon.setIcon(collIcon);
                        paintingIcon.setRotation((double)(1.0f - this.treeExpansionAnimationListener.getAnimationState()) * Math.PI / 2.0);
                        collIcon = paintingIcon;
                    }
                    this.drawCentered(this.tree, g, collIcon, iconCenterX, iconCenterY);
                }
            }
        }
    }

    @Override
    protected void paintVerticalLine(Graphics g, JComponent c, int x, int top, int bottom) {
        if (this.isDashedLine()) {
            this.drawDashedLine(g, x, top, bottom);
        } else {
            g.fillRect(x, top, 1, bottom - top);
        }
    }

    @Override
    protected void completeEditing() {
        if (this.tree.getInvokesStopCellEditing() && this.stopEditingInCompleteEditing && this.editingComponent != null) {
            this.cellEditor.stopCellEditing();
        }
        this.completeEditing(false, true, true);
    }

    @Override
    protected boolean isToggleSelectionEvent(MouseEvent e) {
        return SwingUtilities.isLeftMouseButton(e) && (SystemInfo.isMac ? e.isMetaDown() : e.isControlDown()) && !e.isPopupTrigger();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String key = evt.getPropertyName();
        if (KEY_ALTERNATE_ROW_COLOR.equals(key)) {
            this.tree.repaint();
        } else if (KEY_RENDER_BOOLEAN_AS_CHECKBOX.equals(key)) {
            this.tree.repaint();
        } else if (KEY_BOOLEAN_RENDER_TYPE.equals(key)) {
            this.tree.repaint();
        } else if (KEY_LINE_STYLE.equals(key)) {
            this.tree.repaint();
        }
    }

    protected static boolean isLeaf(JTree tree, int row) {
        TreePath path = tree.getPathForRow(row);
        if (path != null) {
            return tree.getModel().isLeaf(path.getLastPathComponent());
        }
        return true;
    }

    private class DarkTreeMouseListener
    extends MouseAdapter {
        boolean handled = false;

        private DarkTreeMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.handled = false;
            DarkTreeUI.this.tree.repaint();
            if (!DarkTreeUI.this.isSelected(e)) {
                this.handled = true;
                this.handle(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!this.handled) {
                this.handle(e);
            }
        }

        private void handle(MouseEvent e) {
            JTree tree = (JTree)e.getSource();
            if (SwingUtilities.isLeftMouseButton(e) && !e.isPopupTrigger()) {
                if (DarkTreeUI.this.isEditing(tree) && tree.getInvokesStopCellEditing() && !DarkTreeUI.this.stopEditing(tree)) {
                    return;
                }
                TreePath pressedPath = DarkTreeUI.this.getClosestPathForLocation(tree, e.getX(), e.getY());
                if (pressedPath != null) {
                    Rectangle bounds = DarkTreeUI.this.getPathBounds(tree, pressedPath);
                    if (e.getY() >= bounds.y + bounds.height) {
                        return;
                    }
                    if (bounds.contains(e.getPoint()) || DarkTreeUI.this.isLocationInExpandControl(pressedPath, e.getX(), e.getY())) {
                        return;
                    }
                    if (tree.getDragEnabled() || !DarkTreeUI.this.startEditing(pressedPath, e)) {
                        DarkTreeUI.this.selectPathForEvent(pressedPath, e);
                    }
                }
            }
        }
    }

    protected static abstract class TreeUIAction
    extends AbstractAction
    implements UIResource {
        protected TreeUIAction() {
        }

        protected static void installActions(JTree tree) {
            if (PropertyUtil.getBooleanProperty((JComponent)tree, (String)DarkTreeUI.KEY_MAC_ACTIONS_INSTALLED)) {
                return;
            }
            tree.putClientProperty(DarkTreeUI.KEY_MAC_ACTIONS_INSTALLED, Boolean.TRUE);
            TreeUIAction.installInputMap(tree.getInputMap(0));
            ActionMap actionMap = tree.getActionMap();
            actionMap.put("expand_or_move_down", new TreeUIAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JTree tree = this.getTree(e);
                    if (tree == null) {
                        return;
                    }
                    int selectionRow = tree.getLeadSelectionRow();
                    if (selectionRow == -1) {
                        return;
                    }
                    if (DarkTreeUI.isLeaf(tree, selectionRow) || tree.isExpanded(selectionRow)) {
                        if (!PropertyUtil.getBooleanProperty((JComponent)tree, (String)DarkTreeUI.KEY_IS_TABLE_TREE)) {
                            this.moveTo(tree, selectionRow + 1);
                        }
                    } else {
                        tree.expandRow(selectionRow);
                    }
                    tree.repaint();
                }

                @Override
                public boolean accept(Object sender) {
                    return this.acceptExpandCollapseAction(sender, false);
                }
            });
            actionMap.put("collapse_or_move_up", new TreeUIAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JTree tree = this.getTree(e);
                    if (tree == null) {
                        return;
                    }
                    int selectionRow = tree.getLeadSelectionRow();
                    if (selectionRow == -1) {
                        return;
                    }
                    if (DarkTreeUI.isLeaf(tree, selectionRow) || tree.isCollapsed(selectionRow)) {
                        if (!PropertyUtil.getBooleanProperty((JComponent)tree, (String)DarkTreeUI.KEY_IS_TABLE_TREE)) {
                            this.moveTo(tree, selectionRow - 1);
                        }
                    } else {
                        tree.collapseRow(selectionRow);
                    }
                    tree.repaint();
                }

                @Override
                public boolean accept(Object sender) {
                    return this.acceptExpandCollapseAction(sender, true);
                }
            });
            actionMap.put("move_down", new TreeUIAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.move(this.getTree(e), 1);
                }
            });
            actionMap.put("move_up", new TreeUIAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.move(this.getTree(e), -1);
                }
            });
            actionMap.put("toggle_edit", new TreeUIAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.toggleEdit(this.getTree(e));
                }
            });
        }

        protected static void installInputMap(InputMap inputMap) {
            inputMap.put(KeyStroke.getKeyStroke("pressed LEFT"), "collapse_or_move_up");
            inputMap.put(KeyStroke.getKeyStroke("pressed RIGHT"), "expand_or_move_down");
            inputMap.put(KeyStroke.getKeyStroke("pressed DOWN"), "move_down");
            inputMap.put(KeyStroke.getKeyStroke("pressed UP"), "move_up");
            inputMap.put(KeyStroke.getKeyStroke("pressed ENTER"), "toggle_edit");
        }

        protected JTree getTree(ActionEvent e) {
            return DarkUIUtil.nullableCast(JTree.class, e.getSource());
        }

        protected void toggleEdit(JTree tree) {
            if (tree == null) {
                return;
            }
            if (tree.isEditing()) {
                tree.stopEditing();
                return;
            }
            int selectionRow = tree.getLeadSelectionRow();
            if (selectionRow == -1) {
                return;
            }
            tree.startEditingAtPath(tree.getPathForRow(selectionRow));
        }

        protected void move(JTree tree, int offset) {
            if (tree == null) {
                return;
            }
            int selectionRow = tree.getLeadSelectionRow();
            if (selectionRow == -1) {
                return;
            }
            this.moveTo(tree, selectionRow + offset);
        }

        protected void moveTo(JTree tree, int row) {
            int newRow = Math.max(Math.min(row, tree.getRowCount() - 1), 0);
            tree.setSelectionRow(newRow);
            this.scrollRowToVisible(tree, newRow);
            tree.repaint();
        }

        protected void scrollRowToVisible(JTree tree, int row) {
            Rectangle bounds = tree.getRowBounds(row);
            boolean expanded = tree.isExpanded(row);
            BasicTreeUI ui = DarkUIUtil.getUIOfType(tree.getUI(), BasicTreeUI.class);
            if (ui != null) {
                Icon icon = expanded ? ui.getExpandedIcon() : ui.getCollapsedIcon();
                boolean ltr = tree.getComponentOrientation().isLeftToRight();
                int ident = ui.getRightChildIndent();
                int extra = ident - 1 + icon.getIconWidth() / 2;
                if (ltr) {
                    bounds.x -= extra;
                }
                bounds.width += extra;
            }
            tree.scrollRectToVisible(bounds);
        }

        protected boolean acceptExpandCollapseAction(Object sender, boolean collapsed) {
            boolean collapsedOrExpanded;
            JTree tree = DarkUIUtil.nullableCast(JTree.class, sender);
            if (tree == null) {
                return false;
            }
            int selectionRow = tree.getLeadSelectionRow();
            if (selectionRow == -1) {
                return false;
            }
            boolean bl = collapsedOrExpanded = collapsed ? tree.isCollapsed(selectionRow) : tree.isExpanded(selectionRow);
            if (DarkTreeUI.isLeaf(tree, selectionRow) || collapsedOrExpanded) {
                return !PropertyUtil.getBooleanProperty((JComponent)tree, (String)DarkTreeUI.KEY_IS_TABLE_TREE);
            }
            return true;
        }
    }
}

