/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ECSSVersion;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSDeclaration;
import com.helger.css.decl.CSSExpression;
import com.helger.css.decl.ICSSSupportsConditionMember;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSSupportsConditionDeclaration
implements ICSSSupportsConditionMember,
ICSSSourceLocationAware {
    private final CSSDeclaration m_aDeclaration;
    private CSSSourceLocation m_aSourceLocation;

    public CSSSupportsConditionDeclaration(@Nonnull @Nonempty String string, @Nonnull CSSExpression cSSExpression) {
        this(new CSSDeclaration(string, cSSExpression));
    }

    public CSSSupportsConditionDeclaration(@Nonnull CSSDeclaration cSSDeclaration) {
        this.m_aDeclaration = (CSSDeclaration)ValueEnforcer.notNull((Object)cSSDeclaration, (String)"Declaration");
    }

    @Nonnull
    public CSSDeclaration getDeclaration() {
        return this.m_aDeclaration;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        iCSSWriterSettings.checkVersionRequirements(this);
        return "(" + this.m_aDeclaration.getAsCSSString(iCSSWriterSettings, n) + ")";
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSSupportsConditionDeclaration cSSSupportsConditionDeclaration = (CSSSupportsConditionDeclaration)object;
        return this.m_aDeclaration.equals(cSSSupportsConditionDeclaration.m_aDeclaration);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aDeclaration).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("declaration", (Object)this.m_aDeclaration).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

