/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriteable;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.utils.CSSURLHelper;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSNamespaceRule
implements ICSSWriteable,
ICSSSourceLocationAware {
    private String m_sPrefix;
    private String m_sURL;
    private CSSSourceLocation m_aSourceLocation;

    public CSSNamespaceRule(@Nonnull String string) {
        this(null, string);
    }

    public CSSNamespaceRule(@Nullable String string, @Nonnull String string2) {
        this.setNamespacePrefix(string);
        this.setNamespaceURL(string2);
    }

    @Nullable
    public String getNamespacePrefix() {
        return this.m_sPrefix;
    }

    @Nonnull
    public CSSNamespaceRule setNamespacePrefix(@Nullable String string) {
        this.m_sPrefix = string;
        return this;
    }

    @Nonnull
    public String getNamespaceURL() {
        return this.m_sURL;
    }

    @Nonnull
    public CSSNamespaceRule setNamespaceURL(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"URL");
        this.m_sURL = string;
        return this;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        if (!iCSSWriterSettings.isWriteNamespaceRules()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("@namespace ");
        if (StringHelper.hasText((String)this.m_sPrefix)) {
            stringBuilder.append(this.m_sPrefix).append(' ');
        }
        if (StringHelper.hasText((String)this.m_sURL)) {
            stringBuilder.append(CSSURLHelper.getAsCSSURL(this.m_sURL, false));
        } else {
            stringBuilder.append("\"\"");
        }
        return stringBuilder.append(';').append(iCSSWriterSettings.getNewLineString()).toString();
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSNamespaceRule cSSNamespaceRule = (CSSNamespaceRule)object;
        return EqualsHelper.equals((Object)this.m_sPrefix, (Object)cSSNamespaceRule.m_sPrefix) && this.m_sURL.equals(cSSNamespaceRule.m_sURL);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sPrefix).append((Object)this.m_sURL).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("prefix", (Object)this.m_sPrefix).append("URL", (Object)this.m_sURL).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

