/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.util;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class Lambdas {
    public static final Runnable DO_NOTHING = () -> {};

    private Lambdas() {
    }

    public static <T, K, E extends Throwable> Function<T, K> orDefault(CheckedFunction<T, K, E> wrappee, K fallback) {
        return t -> {
            try {
                return wrappee.apply(t);
            }
            catch (Throwable e) {
                return fallback;
            }
        };
    }

    public static <T, E extends Throwable> Supplier<T> orDefault(CheckedSupplier<T, E> wrappee, T fallback) {
        return () -> {
            try {
                return wrappee.get();
            }
            catch (Throwable e) {
                return fallback;
            }
        };
    }

    public static <T, E extends Throwable> Predicate<T> orDefault(CheckedPredicate<T, E> wrappee, boolean fallback) {
        return t -> {
            try {
                return wrappee.test(t);
            }
            catch (Throwable e) {
                return fallback;
            }
        };
    }

    public static <T, K, E extends Throwable> Function<T, K> wrap(CheckedFunction<T, K, E> wrappee) {
        return t -> {
            try {
                return wrappee.apply(t);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static <T, E extends Throwable> Consumer<T> wrap(CheckedConsumer<T, E> wrappee) {
        return t -> {
            try {
                wrappee.accept(t);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static <T, E extends Throwable> Supplier<T> wrap(CheckedSupplier<T, E> wrappee) {
        return () -> {
            try {
                return wrappee.get();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static <T, E extends Throwable> Predicate<T> wrap(CheckedPredicate<T, E> wrappee) {
        return t -> {
            try {
                return wrappee.test(t);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static <E extends Throwable> Runnable wrap(CheckedRunnable<E> wrappee) {
        return () -> {
            try {
                wrappee.run();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static interface CheckedRunnable<E extends Throwable> {
        public void run() throws E;
    }

    public static interface CheckedPredicate<T, E extends Throwable> {
        public boolean test(T var1) throws E;
    }

    public static interface CheckedSupplier<T, E extends Throwable> {
        public T get() throws E;
    }

    public static interface CheckedConsumer<T, E extends Throwable> {
        public void accept(T var1) throws E;
    }

    public static interface CheckedFunction<T, K, E extends Throwable> {
        public K apply(T var1) throws E;
    }
}

