/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.HashTreeTraverser;
import org.apache.jorphan.collections.ListedHashTree;

public class SearchByClass<T>
implements HashTreeTraverser {
    private final List<T> objectsOfClass = new ArrayList<T>();
    private final Map<Object, ListedHashTree> subTrees = new HashMap<Object, ListedHashTree>();
    private final Class<T> searchClass;

    public SearchByClass(Class<T> searchClass) {
        this.searchClass = searchClass;
    }

    public Collection<T> getSearchResults() {
        return this.objectsOfClass;
    }

    public HashTree getSubTree(Object root) {
        return this.subTrees.get(root);
    }

    @Override
    public void addNode(Object node, HashTree subTree) {
        if (this.searchClass.isAssignableFrom(node.getClass())) {
            this.objectsOfClass.add(node);
            ListedHashTree tree = new ListedHashTree(node);
            tree.set(node, subTree);
            this.subTrees.put(node, tree);
        }
    }

    @Override
    public void subtractNode() {
    }

    @Override
    public void processPath() {
    }
}

