/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.popupmenu;

import com.github.weisj.darklaf.components.ScrollPopupMenu;
import com.github.weisj.darklaf.ui.popupmenu.EventHelperUtil;
import com.github.weisj.darklaf.ui.popupmenu.MouseGrabberUtil;
import com.github.weisj.darklaf.ui.popupmenu.PopupMenuContainer;
import com.github.weisj.darklaf.util.DarkUIUtil;
import java.awt.Graphics;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.Popup;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPopupMenuUI;

public class DarkPopupMenuUI
extends BasicPopupMenuUI {
    public static final String KEY_DO_NOT_CANCEL_POPUP = "doNotCancelPopup";
    public static final String KEY_CONSUME_EVENT_ON_CLOSE = "consumeEventOnClose";
    public static final String KEY_DO_NOT_CANCEL_ON_SCROLL = "doNotCancelOnScroll";
    public static final String HIDE_POPUP_VALUE = "doNotCancelPopup";
    public static final String KEY_DEFAULT_LIGHTWEIGHT_POPUPS = "PopupMenu.defaultLightWeightPopups";
    private PopupMenuContainer popupMenuContainer;

    public static ComponentUI createUI(JComponent x) {
        return new DarkPopupMenuUI();
    }

    public DarkPopupMenuUI() {
        EventHelperUtil.installEventHelper();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Window window = SwingUtilities.getWindowAncestor(c);
        if (window != null && window.getOpacity() != 1.0f) {
            window.setOpacity(1.0f);
        }
        super.paint(g, c);
    }

    public static List<JPopupMenu> getPopups() {
        MenuSelectionManager msm = MenuSelectionManager.defaultManager();
        MenuElement[] p = msm.getSelectedPath();
        ArrayList<JPopupMenu> list = new ArrayList<JPopupMenu>(p.length);
        for (MenuElement element : p) {
            if (!(element instanceof JPopupMenu)) continue;
            list.add((JPopupMenu)element);
        }
        return list;
    }

    @Override
    public void installDefaults() {
        super.installDefaults();
        this.popupMenu.putClientProperty("JPopupFactory.startHidden", true);
    }

    private PopupMenuContainer getPopupMenuContainer() {
        if (this.popupMenuContainer == null && !(this.popupMenu instanceof ScrollPopupMenu)) {
            this.popupMenuContainer = new PopupMenuContainer();
        }
        return this.popupMenuContainer;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        MouseGrabberUtil.installMouseGrabber();
    }

    @Override
    public Popup getPopup(JPopupMenu popup, int x, int y) {
        PopupMenuContainer container = this.getPopupMenuContainer();
        if (container == null) {
            return super.getPopup(popup, x, y);
        }
        int maxHeight = DarkUIUtil.getScreenBounds((JComponent)popup, (int)x, (int)y, (boolean)false).height;
        return container.createPopup(popup, x, y, maxHeight);
    }
}

