/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.filetree;

import com.github.weisj.darklaf.components.filetree.FileNode;
import com.github.weisj.darklaf.components.filetree.FileTreeNode;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.DefaultTreeModel;

public class FileTreeModel
extends DefaultTreeModel {
    protected final FileSystemView fsv;
    protected boolean showHiddenFiles;

    public FileTreeModel(FileSystemView fileSystemView) {
        this(fileSystemView, false, (Path[])null);
    }

    public FileTreeModel(FileSystemView fileSystemView, boolean showHiddenFiles, File ... roots) {
        super(null);
        this.init();
        this.showHiddenFiles = showHiddenFiles;
        this.fsv = fileSystemView;
        this.root = this.createRoot(roots);
    }

    public FileTreeModel(FileSystemView fileSystemView, boolean showHiddenFiles, Path ... roots) {
        super(null);
        this.init();
        this.showHiddenFiles = showHiddenFiles;
        this.fsv = fileSystemView;
        this.root = this.createRoot(roots);
    }

    protected void init() {
    }

    protected FileTreeNode createRoot(Path ... roots) {
        List<FileNode> nodes = roots != null ? Arrays.stream(roots).map(FileNode::fromPath).collect(Collectors.toList()) : null;
        return new FileTreeNode.RootNode(this, nodes);
    }

    protected FileTreeNode createRoot(File ... roots) {
        List<FileNode> nodes = roots != null ? Arrays.stream(roots).map(FileNode::fromFile).collect(Collectors.toList()) : null;
        return new FileTreeNode.RootNode(this, nodes);
    }

    @Override
    public void reload() {
        this.getRoot().reload();
    }

    @Override
    public FileTreeNode getRoot() {
        return (FileTreeNode)super.getRoot();
    }

    public void setShowHiddenFiles(boolean showHiddenFiles) {
        if (showHiddenFiles == this.showHiddenFiles) {
            return;
        }
        this.showHiddenFiles = showHiddenFiles;
        this.reload();
    }

    public boolean isShowHiddenFiles() {
        return this.showHiddenFiles;
    }

    protected FileTreeNode createNode(FileTreeNode parent, FileNode fileNode) {
        return new FileTreeNode(parent, fileNode, this);
    }

    protected void register(FileTreeNode node) {
    }

    protected void unregister(FileTreeNode node) {
    }
}

