/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.datetime;

import com.helger.commons.datetime.EDTFormatterMode;
import com.helger.commons.datetime.PDTFormatter;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class PDTToString {
    private static final PDTToString s_aInstance = new PDTToString();

    private PDTToString() {
    }

    @Nullable
    public static String getAsString(@Nullable LocalDate localDate, @Nonnull Locale locale) {
        return localDate == null ? null : PDTFormatter.getFormatterDate(PDTFormatter.DEFAULT_STYLE, locale, EDTFormatterMode.PRINT).format(localDate);
    }

    @Nullable
    public static String getAsString(@Nullable LocalTime localTime, @Nonnull Locale locale) {
        return localTime == null ? null : PDTFormatter.getFormatterTime(PDTFormatter.DEFAULT_STYLE, locale, EDTFormatterMode.PRINT).format(localTime);
    }

    @Nullable
    public static String getAsString(@Nullable LocalDateTime localDateTime, @Nonnull Locale locale) {
        return localDateTime == null ? null : PDTFormatter.getFormatterDateTime(PDTFormatter.DEFAULT_STYLE, locale, EDTFormatterMode.PRINT).format(localDateTime);
    }

    @Nullable
    public static String getAsString(@Nullable ZonedDateTime zonedDateTime, @Nonnull Locale locale) {
        return zonedDateTime == null ? null : PDTFormatter.getFormatterDateTime(PDTFormatter.DEFAULT_STYLE, locale, EDTFormatterMode.PRINT).format(zonedDateTime);
    }

    @Nullable
    public static String getAsString(@Nullable OffsetDateTime offsetDateTime, @Nonnull Locale locale) {
        return offsetDateTime == null ? null : PDTFormatter.getFormatterDateTime(PDTFormatter.DEFAULT_STYLE, locale, EDTFormatterMode.PRINT).format(offsetDateTime);
    }

    @Nullable
    public static String getAsString(@Nonnull String string, @Nullable TemporalAccessor temporalAccessor) {
        return PDTToString.getAsString(string, temporalAccessor, null);
    }

    @Nullable
    public static String getAsString(@Nonnull String string, @Nullable TemporalAccessor temporalAccessor, @Nullable Locale locale) {
        return temporalAccessor == null ? null : PDTFormatter.getForPattern(string, locale).format(temporalAccessor);
    }
}

