/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.mutable;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.compare.CompareHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.mutable.AbstractMutableInteger;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class MutableLong
extends AbstractMutableInteger<MutableLong> {
    private long m_nValue;

    public MutableLong(@Nonnull Number number) {
        this(number.longValue());
    }

    public MutableLong(long l) {
        this.m_nValue = l;
    }

    @Override
    public long longValue() {
        return this.m_nValue;
    }

    @Override
    public float floatValue() {
        return this.m_nValue;
    }

    @Override
    public double doubleValue() {
        return this.m_nValue;
    }

    @Override
    public int intValue() {
        return (int)this.m_nValue;
    }

    public long inc() {
        return this.inc(1L);
    }

    public long inc(long l) {
        this.m_nValue += l;
        this.onAfterChange();
        return this.m_nValue;
    }

    public long inc(@Nonnull Number number) {
        ValueEnforcer.notNull(number, "Delta");
        return this.inc(number.longValue());
    }

    public long dec() {
        return this.inc(-1L);
    }

    public long dec(long l) {
        return this.inc(-l);
    }

    public long dec(@Nonnull Number number) {
        ValueEnforcer.notNull(number, "Delta");
        return this.inc(-number.longValue());
    }

    public long divide(long l) {
        this.m_nValue /= l;
        this.onAfterChange();
        return this.m_nValue;
    }

    public long divide(@Nonnull Number number) {
        ValueEnforcer.notNull(number, "Divisor");
        return this.divide(number.longValue());
    }

    public long multiply(long l) {
        this.m_nValue *= l;
        this.onAfterChange();
        return this.m_nValue;
    }

    public long multiply(@Nonnull Number number) {
        ValueEnforcer.notNull(number, "Multiplicand");
        return this.multiply(number.longValue());
    }

    @Nonnull
    public EChange set(long l) {
        if (l == this.m_nValue) {
            return EChange.UNCHANGED;
        }
        this.m_nValue = l;
        this.onAfterChange();
        return EChange.CHANGED;
    }

    @Nonnull
    public EChange set(@Nonnull Number number) {
        ValueEnforcer.notNull(number, "Value");
        return this.set(number.longValue());
    }

    @Override
    public boolean is0() {
        return this.m_nValue == 0L;
    }

    @Override
    public boolean isLT0() {
        return this.m_nValue < 0L;
    }

    @Override
    public boolean isLE0() {
        return this.m_nValue <= 0L;
    }

    @Override
    public boolean isGT0() {
        return this.m_nValue > 0L;
    }

    @Override
    public boolean isGE0() {
        return this.m_nValue >= 0L;
    }

    @Override
    public boolean isEven() {
        return this.m_nValue % 2L == 0L;
    }

    @Override
    public int compareTo(@Nonnull MutableLong mutableLong) {
        return CompareHelper.compare(this.m_nValue, mutableLong.m_nValue);
    }

    @Override
    @Nonnull
    public MutableLong getClone() {
        return new MutableLong(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MutableLong mutableLong = (MutableLong)object;
        return this.m_nValue == mutableLong.m_nValue;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_nValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("value", this.m_nValue).getToString();
    }
}

