/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.processor;

import java.io.File;
import org.apache.commons.lang3.Validate;
import org.apache.jmeter.report.core.CsvSampleWriter;
import org.apache.jmeter.report.core.Sample;
import org.apache.jmeter.report.processor.AbstractSampleConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SampleWriterConsumer
extends AbstractSampleConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(SampleWriterConsumer.class);
    private File outputFile;
    private CsvSampleWriter[] csvWriters;
    private boolean shouldWriteHeader;
    private int channelsCount;

    public void setOutputFile(String outputFile) {
        this.setOutputFile(new File(outputFile));
    }

    public void setOutputFile(File outputFile) {
        Validate.notNull((Object)outputFile, (String)"outputFile must not be null", (Object[])new Object[0]);
        this.outputFile = outputFile;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public File getOutputFile(int channel) {
        String ext = null;
        String fName = this.getOutputFile().getName();
        int idx = fName.lastIndexOf(46);
        if (idx >= 0 && idx < fName.length() - 1) {
            String backedName = fName;
            fName = fName.substring(0, idx);
            ext = backedName.substring(idx + 1);
        } else {
            ext = "";
        }
        fName = channel > 0 ? fName + "-" + channel + "." + ext : fName + "." + ext;
        return new File(this.getOutputFile().getParentFile(), fName);
    }

    public void setWriteHeader(boolean writeHeader) {
        this.shouldWriteHeader = writeHeader;
    }

    @Override
    public void startConsuming() {
        if (this.outputFile == null) {
            File wd = this.getWorkingDirectory();
            wd.mkdir();
            if (LOG.isInfoEnabled()) {
                LOG.info("startConsuming(): No output file set, writing to work directory :" + wd.getAbsolutePath());
            }
            this.outputFile = new File(wd, "samples.csv");
        }
        this.outputFile.getParentFile().mkdirs();
        this.channelsCount = this.getConsumedChannelCount();
        this.csvWriters = new CsvSampleWriter[this.channelsCount];
        for (int i = 0; i < this.channelsCount; ++i) {
            this.csvWriters[i] = new CsvSampleWriter(this.getOutputFile(i), this.getConsumedMetadata(i));
            if (!this.shouldWriteHeader) continue;
            this.csvWriters[i].writeHeader();
        }
    }

    @Override
    public void consume(Sample s, int channel) {
        this.csvWriters[channel].write(s);
    }

    @Override
    public void stopConsuming() {
        for (int i = 0; i < this.channelsCount; ++i) {
            this.csvWriters[i].close();
        }
        if (!this.getWorkingDirectory().delete()) {
            LOG.warn("Was not able to delete folder {}", (Object)this.getWorkingDirectory());
        }
    }
}

