/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.filetree;

import com.github.weisj.darklaf.components.filetree.FileTreeModel;
import com.github.weisj.darklaf.components.filetree.FileTreeNode;
import com.github.weisj.darklaf.util.LogUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.Watchable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import javax.swing.filechooser.FileSystemView;

public class WatchFileTreeModel
extends FileTreeModel {
    private static final Logger LOGGER = LogUtil.getLogger(WatchFileTreeModel.class);
    private static final ScheduledExecutorService scheduler = WatchFileTreeModel.createScheduler();
    private WatchService watchService;
    private Map<Watchable, FileTreeNode> nodeMap;
    private Object lock;
    private final AtomicBoolean isScheduled = new AtomicBoolean(false);
    private ScheduledFuture<?> watchTask;

    private static WatchService createWatchService() {
        WatchService ws = null;
        try {
            ws = FileSystems.getDefault().newWatchService();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ws;
    }

    private static ScheduledExecutorService createScheduler() {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, r -> {
            Thread thread = new Thread(r, "File Tree Watch Thread");
            thread.setDaemon(true);
            thread.setPriority(1);
            return thread;
        });
        executor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        return executor;
    }

    public WatchFileTreeModel(FileSystemView fileSystemView) {
        super(fileSystemView);
    }

    public WatchFileTreeModel(FileSystemView fileSystemView, boolean showHiddenFiles, File ... roots) {
        super(fileSystemView, showHiddenFiles, roots);
    }

    public WatchFileTreeModel(FileSystemView fileSystemView, boolean showHiddenFiles, Path ... roots) {
        super(fileSystemView, showHiddenFiles, roots);
    }

    @Override
    protected void init() {
        this.lock = new Object();
        this.watchService = WatchFileTreeModel.createWatchService();
        this.nodeMap = Collections.synchronizedMap(new HashMap());
    }

    private Object getLock() {
        return this.lock;
    }

    protected WatchService getWatchService() {
        return this.watchService;
    }

    protected Map<Watchable, FileTreeNode> getNodeMap() {
        return this.nodeMap;
    }

    public void startWatching() {
        if (this.watchTask != null) {
            return;
        }
        this.isScheduled.set(true);
        this.watchTask = scheduler.schedule(this::watch, 0L, TimeUnit.SECONDS);
    }

    public void stopWatching() {
        if (this.watchTask != null) {
            this.isScheduled.set(false);
            this.watchTask.cancel(true);
            this.watchTask = null;
        }
    }

    private void watch() {
        while (this.isScheduled.get()) {
            WatchKey key;
            try {
                key = this.watchService.take();
            }
            catch (InterruptedException x) {
                x.printStackTrace();
                return;
            }
            FileTreeNode parent = this.getNodeMap().get(key.watchable());
            if (parent != null) {
                LOGGER.fine(() -> "Event for \"" + parent + "\"");
                if (parent.parent != null) {
                    parent.parent.reload(1);
                } else {
                    parent.reload(0);
                }
            }
            List<WatchEvent<?>> watchEventList = key.pollEvents();
            for (WatchEvent<?> event : watchEventList) {
                WatchEvent.Kind<?> kind = event.kind();
                Path path = (Path)event.context();
                if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                LOGGER.finer("Event Type " + kind.name());
                FileTreeNode node = this.getNodeMap().get(((Path)key.watchable()).resolve(path));
                if (node == null) continue;
                LOGGER.finer(() -> "Affected node \"" + node + "\"");
                node.reload(0);
            }
            key.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void register(FileTreeNode node) {
        Object object = this.getLock();
        synchronized (object) {
            WatchService ws = this.getWatchService();
            if (ws == null || !node.fileNode.isDirectory()) {
                return;
            }
            Path path = node.fileNode.getPath();
            if (path == null) {
                return;
            }
            if (this.getNodeMap().containsKey(path)) {
                return;
            }
            try {
                LOGGER.finer(() -> "Register watch service for \"" + node + "\"");
                node.watchKey = path.register(ws, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
                this.getNodeMap().put(path, node);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void unregister(FileTreeNode node) {
        Object object = this.getLock();
        synchronized (object) {
            if (node.watchKey == null) {
                return;
            }
            LOGGER.finer(() -> "Unregister watch service for \"" + node + "\"");
            this.getNodeMap().remove(node.fileNode.getPath());
            node.watchKey.cancel();
        }
    }
}

