/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.registry.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.java.plugin.registry.Identity;
import org.java.plugin.registry.ManifestProcessingException;
import org.java.plugin.registry.PluginAttribute;
import org.java.plugin.registry.xml.ModelAttribute;
import org.java.plugin.registry.xml.PluginDescriptorImpl;
import org.java.plugin.registry.xml.PluginElementImpl;
import org.java.plugin.registry.xml.PluginFragmentImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PluginAttributeImpl
extends PluginElementImpl<PluginAttribute>
implements PluginAttribute {
    private final PluginAttributeImpl superAttribute;
    private final ModelAttribute model;
    private List<PluginAttribute> subAttributes;

    PluginAttributeImpl(PluginDescriptorImpl descr, PluginFragmentImpl aFragment, ModelAttribute aModel, PluginAttributeImpl aSuperAttribute) throws ManifestProcessingException {
        super(descr, aFragment, aModel.getId(), aModel.getDocumentation());
        this.model = aModel;
        this.superAttribute = aSuperAttribute;
        if (this.model.getValue() == null) {
            this.model.setValue("");
        }
        this.subAttributes = new ArrayList<PluginAttribute>(this.model.getAttributes().size());
        for (ModelAttribute modelAttribute : this.model.getAttributes()) {
            this.subAttributes.add(new PluginAttributeImpl(descr, aFragment, modelAttribute, this));
        }
        this.subAttributes = Collections.unmodifiableList(this.subAttributes);
        if (this.log.isDebugEnabled()) {
            this.log.debug("object instantiated: " + this);
        }
    }

    @Override
    public PluginAttribute getSubAttribute(String id) {
        PluginAttributeImpl result = null;
        for (PluginAttribute pluginAttribute : this.subAttributes) {
            PluginAttributeImpl param = (PluginAttributeImpl)pluginAttribute;
            if (!param.getId().equals(id)) continue;
            if (result == null) {
                result = param;
                continue;
            }
            throw new IllegalArgumentException("more than one attribute with ID " + id + " defined in plug-in " + this.getDeclaringPluginDescriptor().getUniqueId());
        }
        return result;
    }

    @Override
    public Collection<PluginAttribute> getSubAttributes() {
        return this.subAttributes;
    }

    @Override
    public Collection<PluginAttribute> getSubAttributes(String id) {
        LinkedList<PluginAttributeImpl> result = new LinkedList<PluginAttributeImpl>();
        for (PluginAttribute pluginAttribute : this.subAttributes) {
            PluginAttributeImpl param = (PluginAttributeImpl)pluginAttribute;
            if (!param.getId().equals(id)) continue;
            result.add(param);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public String getValue() {
        return this.model.getValue();
    }

    @Override
    protected boolean isEqualTo(Identity idt) {
        if (!super.isEqualTo(idt)) {
            return false;
        }
        PluginAttributeImpl other = (PluginAttributeImpl)idt;
        if (this.getSuperAttribute() == null && other.getSuperAttribute() == null) {
            return true;
        }
        if (this.getSuperAttribute() == null || other.getSuperAttribute() == null) {
            return false;
        }
        return this.getSuperAttribute().equals(other.getSuperAttribute());
    }

    @Override
    public PluginAttribute getSuperAttribute() {
        return this.superAttribute;
    }
}

