/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.swing;

import de.hunsicker.jalopy.storage.ConventionDefaults;
import de.hunsicker.jalopy.storage.ConventionKeys;
import de.hunsicker.jalopy.storage.ImportPolicy;
import de.hunsicker.jalopy.swing.AbstractSettingsPage;
import de.hunsicker.jalopy.swing.NumberComboBoxPanel;
import de.hunsicker.jalopy.swing.SettingsContainer;
import de.hunsicker.jalopy.swing.TableList;
import de.hunsicker.swing.EmptyButtonGroup;
import de.hunsicker.swing.util.SwingHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import org.apache.oro.text.perl.Perl5Util;

public class ImportsSettingsPage
extends AbstractSettingsPage {
    private static final String DELIMETER_ENTRY_PAIR = ":";
    private static final String STAR = "*";
    private static final String EMPTY_STRING = "".intern();
    private DefaultTableModel _tableModel;
    private JCheckBox _collapseCheckBox;
    private JCheckBox _expandCheckBox;
    private JCheckBox _sortImportsCheckBox;
    private JComboBox _groupingDepthComboBox;
    private JTable _table;
    private TableList _tableList;
    private boolean _selectionAllowed = true;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$javax$swing$event$ListSelectionListener;

    public ImportsSettingsPage() {
        this.initialize();
    }

    ImportsSettingsPage(SettingsContainer container) {
        super(container);
        this.initialize();
    }

    public void addNotify() {
        super.addNotify();
        this._table.setDefaultEditor(class$java$lang$String == null ? (class$java$lang$String = ImportsSettingsPage.class$("java.lang.String")) : class$java$lang$String, new StringEditor(this._tableList));
        this._table.setDefaultEditor(class$java$lang$Integer == null ? (class$java$lang$Integer = ImportsSettingsPage.class$("java.lang.Integer")) : class$java$lang$Integer, new IntegerEditor(this._tableList));
    }

    public void removeNotify() {
        super.removeNotify();
        this._table.setDefaultEditor(class$java$lang$String == null ? (class$java$lang$String = ImportsSettingsPage.class$("java.lang.String")) : class$java$lang$String, null);
        this._table.setDefaultEditor(class$java$lang$Integer == null ? (class$java$lang$Integer = ImportsSettingsPage.class$("java.lang.Integer")) : class$java$lang$Integer, null);
    }

    public void updateSettings() {
        if (this._expandCheckBox.isSelected()) {
            this.settings.put(ConventionKeys.IMPORT_POLICY, ImportPolicy.EXPAND.getName());
        } else if (this._collapseCheckBox.isSelected()) {
            this.settings.put(ConventionKeys.IMPORT_POLICY, ImportPolicy.COLLAPSE.getName());
        } else {
            this.settings.put(ConventionKeys.IMPORT_POLICY, ImportPolicy.DISABLED.getName());
        }
        this.settings.putBoolean(ConventionKeys.IMPORT_SORT, this._sortImportsCheckBox.isSelected());
        this.settings.put(ConventionKeys.IMPORT_GROUPING_DEPTH, (String)this._groupingDepthComboBox.getSelectedItem());
        ArrayList<ListEntry> values = new ArrayList<ListEntry>(this._tableModel.getRowCount());
        int i = 0;
        while (i < this._tableModel.getRowCount()) {
            Integer depth;
            String name = (String)this._tableModel.getValueAt(i, 0);
            if (name != null && name.length() != 0 && (depth = (Integer)this._tableModel.getValueAt(i, 1)) != null) {
                ListEntry entry = new ListEntry(name, depth.toString());
                values.add(entry);
            }
            ++i;
        }
        this.settings.put(ConventionKeys.IMPORT_GROUPING, this.encodeGroupingInfo(values));
    }

    private JPanel createGeneralPane() {
        JPanel generalPanel = new JPanel();
        GridBagLayout generalLayout = new GridBagLayout();
        generalPanel.setLayout(generalLayout);
        generalPanel.setBorder(BorderFactory.createTitledBorder(this.bundle.getString("BDR_GENERAL")));
        GridBagConstraints c = new GridBagConstraints();
        c.insets.left = 5;
        c.insets.right = 5;
        c.insets.top = 0;
        c.insets.bottom = 0;
        this._sortImportsCheckBox = new JCheckBox(this.bundle.getString("CHK_SORT_IMPORTS"), this.settings.getBoolean(ConventionKeys.IMPORT_SORT, true));
        this._sortImportsCheckBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 0, 0, 0, 1, 1.0, 1.0, 18, 0, c.insets, 0, 0);
        generalLayout.setConstraints(this._sortImportsCheckBox, c);
        generalPanel.add(this._sortImportsCheckBox);
        return generalPanel;
    }

    private JPanel createGroupingPane() {
        JPanel sortPanel = new JPanel();
        GridBagLayout sortLayout = new GridBagLayout();
        sortPanel.setLayout(sortLayout);
        sortPanel.setBorder(BorderFactory.createTitledBorder(this.bundle.getString("BDR_ORDERING")));
        GridBagConstraints c = new GridBagConstraints();
        Object[] depths = this.createItemList(new int[]{0, 1, 2, 3, 4, 5});
        NumberComboBoxPanel groupingDepthPanel = new NumberComboBoxPanel(this.bundle.getString("LBL_DEFAULT_GROUPING_DEPTH"), depths, String.valueOf(this.settings.getInt(ConventionKeys.IMPORT_GROUPING_DEPTH, 3)));
        this._groupingDepthComboBox = groupingDepthPanel.getComboBox();
        this._groupingDepthComboBox.addActionListener(this.trigger);
        c.insets.left = 5;
        c.insets.right = 5;
        c.insets.top = 0;
        c.insets.bottom = 0;
        SwingHelper.setConstraints(c, 0, 0, 0, 1, 1.0, 0.0, 17, 0, c.insets, 0, 0);
        sortLayout.setConstraints(groupingDepthPanel, c);
        sortPanel.add(groupingDepthPanel);
        List info = this.decodeGroupingInfo(this.settings.get(ConventionKeys.IMPORT_GROUPING, "*:0|gnu:2|java:2|javax:2"));
        int rows = info.size();
        Object[][] data = new Object[rows][2];
        int index = 0;
        int i = 0;
        int size = info.size();
        while (i < size) {
            ListEntry entry = (ListEntry)info.get(i);
            data[index][0] = entry.name;
            data[index][1] = new Integer(entry.depth);
            ++index;
            ++i;
        }
        Object[] columnNames = new Object[]{this.bundle.getString("HDR_PACKAGE"), this.bundle.getString("HDR_DEPTH")};
        this._tableModel = new DataModel(data, columnNames);
        this._tableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent ev) {
                if (ev.getType() == -1) {
                    ImportsSettingsPage.this.trigger.actionPerformed(null);
                }
            }
        });
        this._tableList = new TableList(this._tableModel, 3);
        this._table = this._tableList.getTable();
        this._table.setEnabled(this._sortImportsCheckBox.isSelected());
        this._sortImportsCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImportsSettingsPage.this._table.clearSelection();
                if (ImportsSettingsPage.this._sortImportsCheckBox.isSelected()) {
                    ImportsSettingsPage.this._table.setEnabled(true);
                    ((ImportsSettingsPage)ImportsSettingsPage.this)._tableList.addButton.setEnabled(true);
                    ImportsSettingsPage.this._groupingDepthComboBox.setEnabled(true);
                } else {
                    ImportsSettingsPage.this._table.setEnabled(false);
                    ((ImportsSettingsPage)ImportsSettingsPage.this)._tableList.addButton.setEnabled(false);
                    ((ImportsSettingsPage)ImportsSettingsPage.this)._tableList.removeButton.setEnabled(false);
                    ImportsSettingsPage.this._groupingDepthComboBox.setEnabled(false);
                }
            }
        });
        ListSelectionListener selectionListener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent ev) {
                String name;
                if (ev.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel model = (ListSelectionModel)ev.getSource();
                int selectedRow = model.getMinSelectionIndex();
                if (selectedRow > -1 && ImportsSettingsPage.STAR.equals(name = (String)ImportsSettingsPage.this._tableModel.getValueAt(selectedRow, 0))) {
                    ((ImportsSettingsPage)ImportsSettingsPage.this)._tableList.removeButton.setEnabled(false);
                }
            }
        };
        this.updateListenerList(selectionListener);
        JPanel tablePanel = new JPanel();
        GridBagLayout tableLayout = new GridBagLayout();
        tablePanel.setLayout(tableLayout);
        c.insets.left = 0;
        c.insets.right = 0;
        c.insets.top = 10;
        c.insets.bottom = 5;
        SwingHelper.setConstraints(c, 0, 0, 8, 8, 1.0, 1.0, 11, 1, c.insets, 0, 0);
        tableLayout.setConstraints(this._tableList, c);
        tablePanel.add(this._tableList);
        c.insets.bottom = 2;
        c.insets.top = 10;
        c.insets.left = 10;
        c.insets.right = 0;
        SwingHelper.setConstraints(c, 9, 1, 0, 1, 0.0, 0.0, 18, 2, c.insets, 0, 0);
        tableLayout.setConstraints(this._tableList.addButton, c);
        tablePanel.add(this._tableList.addButton);
        this._tableList.removeButton.setEnabled(false);
        c.insets.top = 0;
        SwingHelper.setConstraints(c, 9, 2, 0, 1, 0.0, 0.0, 18, 2, c.insets, 0, 0);
        tableLayout.setConstraints(this._tableList.removeButton, c);
        tablePanel.add(this._tableList.removeButton);
        this._tableList.upButton.setEnabled(false);
        c.insets.top = 10;
        c.insets.bottom = 2;
        SwingHelper.setConstraints(c, 9, 3, 0, 1, 0.0, 0.0, 18, 2, c.insets, 0, 0);
        tableLayout.setConstraints(this._tableList.upButton, c);
        tablePanel.add(this._tableList.upButton);
        this._tableList.downButton.setEnabled(false);
        c.insets.top = 0;
        SwingHelper.setConstraints(c, 9, 4, 0, 1, 0.0, 1.0, 18, 2, c.insets, 0, 0);
        tableLayout.setConstraints(this._tableList.downButton, c);
        tablePanel.add(this._tableList.downButton);
        c.insets.left = 5;
        c.insets.right = 5;
        c.insets.top = 0;
        c.insets.bottom = 0;
        SwingHelper.setConstraints(c, 0, 1, 0, 1, 1.0, 1.0, 18, 1, c.insets, 0, 0);
        sortLayout.setConstraints(tablePanel, c);
        sortPanel.add(tablePanel);
        return sortPanel;
    }

    private JPanel createMiscPane() {
        JPanel miscPanel = new JPanel();
        GridBagLayout miscLayout = new GridBagLayout();
        miscPanel.setLayout(miscLayout);
        miscPanel.setBorder(BorderFactory.createTitledBorder(this.bundle.getString("BDR_OPTIMIZE")));
        GridBagConstraints c = new GridBagConstraints();
        ImportPolicy importPolicy = ImportPolicy.valueOf(this.settings.get(ConventionKeys.IMPORT_POLICY, ConventionDefaults.IMPORT_POLICY));
        this._expandCheckBox = new JCheckBox(this.bundle.getString("CHK_EXPAND"), importPolicy == ImportPolicy.EXPAND);
        c.insets.left = 5;
        c.insets.right = 5;
        c.insets.top = 0;
        c.insets.bottom = 0;
        SwingHelper.setConstraints(c, 0, 0, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
        miscLayout.setConstraints(this._expandCheckBox, c);
        miscPanel.add(this._expandCheckBox);
        this._collapseCheckBox = new JCheckBox(this.bundle.getString("CHK_COLLAPSE"), importPolicy == ImportPolicy.COLLAPSE);
        c.insets.bottom = 5;
        SwingHelper.setConstraints(c, 0, 1, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
        miscLayout.setConstraints(this._collapseCheckBox, c);
        miscPanel.add(this._collapseCheckBox);
        EmptyButtonGroup group = new EmptyButtonGroup();
        ((ButtonGroup)group).add(this._expandCheckBox);
        ((ButtonGroup)group).add(this._collapseCheckBox);
        return miscPanel;
    }

    private List decodeGroupingInfo(String info) {
        ArrayList<ListEntry> result = new ArrayList<ListEntry>();
        StringTokenizer tokens = new StringTokenizer(info, "|");
        while (tokens.hasMoreElements()) {
            String pair = tokens.nextToken();
            int delimOffset = pair.indexOf(58);
            String name = pair.substring(0, delimOffset);
            String depth = pair.substring(delimOffset + 1);
            result.add(new ListEntry(name, depth));
        }
        return result;
    }

    private String encodeGroupingInfo(List info) {
        StringBuffer result = new StringBuffer(60);
        int i = 0;
        int size = info.size();
        while (i < size) {
            ListEntry entry = (ListEntry)info.get(i);
            result.append(entry.name);
            result.append(DELIMETER_ENTRY_PAIR);
            result.append(entry.depth);
            result.append("|");
            ++i;
        }
        if (result.length() > 1) {
            result.deleteCharAt(result.length() - 1);
        }
        return result.toString();
    }

    private void initialize() {
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        GridBagConstraints c = new GridBagConstraints();
        JPanel generalPanel = this.createGeneralPane();
        c.insets.left = 0;
        c.insets.right = 0;
        c.insets.top = 10;
        c.insets.bottom = 10;
        SwingHelper.setConstraints(c, 0, 0, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
        layout.setConstraints(generalPanel, c);
        this.add(generalPanel);
        JPanel sortPanel = this.createGroupingPane();
        c.insets.top = 0;
        SwingHelper.setConstraints(c, 0, 1, 0, 1, 1.0, 0.2, 18, 1, c.insets, 0, 0);
        layout.setConstraints(sortPanel, c);
        this.add(sortPanel);
        JPanel miscPanel = this.createMiscPane();
        SwingHelper.setConstraints(c, 0, 2, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
        layout.setConstraints(miscPanel, c);
        this.add(miscPanel);
    }

    private void updateListenerList(ListSelectionListener selectionListener) {
        DefaultListSelectionModel listSelectionModel = (DefaultListSelectionModel)this._table.getSelectionModel();
        EventListener[] listeners = (EventListener[])listSelectionModel.getListeners(class$javax$swing$event$ListSelectionListener == null ? (class$javax$swing$event$ListSelectionListener = ImportsSettingsPage.class$("javax.swing.event.ListSelectionListener")) : class$javax$swing$event$ListSelectionListener).clone();
        int i = 0;
        while (i < listeners.length) {
            listSelectionModel.removeListSelectionListener((ListSelectionListener)listeners[i]);
            ++i;
        }
        listSelectionModel.addListSelectionListener(selectionListener);
        int i2 = 0;
        while (i2 < listeners.length) {
            listSelectionModel.addListSelectionListener((ListSelectionListener)listeners[i2]);
            ++i2;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class StringEditor
    extends TableList.TableListCellEditor {
        public StringEditor(TableList tableList) {
            super(tableList, new JTextField());
        }

        public boolean isCellEditable(EventObject ev) {
            boolean editable = super.isCellEditable(ev);
            if (editable && ImportsSettingsPage.STAR.equals(ImportsSettingsPage.this._table.getValueAt(ImportsSettingsPage.this._table.getSelectedRow(), 0))) {
                return false;
            }
            return editable;
        }

        public Object getCellEditorValue() {
            return ((String)super.getCellEditorValue()).trim();
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            ((JComponent)this.getComponent()).setBorder(BorderFactory.createLineBorder(Color.black));
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        public boolean stopCellEditing() {
            Perl5Util regex = new Perl5Util();
            String s = (String)super.getCellEditorValue();
            if (!regex.match("m/^[a-zA-Z]+(?:.[a-zA-Z]+)*$|\\*/s", s)) {
                ((JComponent)this.getComponent()).setBorder(BorderFactory.createLineBorder(Color.red));
                return false;
            }
            int row = ImportsSettingsPage.this._table.getEditingRow();
            int column = ImportsSettingsPage.this._table.getEditingColumn() + 1;
            boolean successful = super.stopCellEditing();
            if (successful) {
                if (ImportsSettingsPage.this._table.getValueAt(row, column) == null) {
                    ImportsSettingsPage.this._table.editCellAt(row, column);
                    DefaultCellEditor cellEditor = (DefaultCellEditor)ImportsSettingsPage.this._table.getCellEditor();
                    Component cell = cellEditor.getComponent();
                    cell.requestFocus();
                } else {
                    ImportsSettingsPage.this.trigger.actionPerformed(null);
                }
            }
            return successful;
        }
    }

    private class IntegerEditor
    extends TableList.TableListCellEditor {
        public IntegerEditor(TableList tableList) {
            super(tableList, new JTextField());
            ((JTextField)this.getComponent()).setHorizontalAlignment(4);
        }

        public boolean isCellEditable(EventObject ev) {
            boolean editable = super.isCellEditable(ev);
            if (editable && ImportsSettingsPage.STAR.equals(ImportsSettingsPage.this._table.getValueAt(ImportsSettingsPage.this._table.getSelectedRow(), 0))) {
                return false;
            }
            return editable;
        }

        public Object getCellEditorValue() {
            String value = (String)super.getCellEditorValue();
            if (value == null || value.trim().length() == 0) {
                return EMPTY_STRING;
            }
            return new Integer(value);
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            ((JComponent)this.getComponent()).setBorder(BorderFactory.createLineBorder(Color.black));
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        public boolean stopCellEditing() {
            String s = (String)super.getCellEditorValue();
            if (EMPTY_STRING.equals(s)) {
                ((JComponent)this.getComponent()).setBorder(BorderFactory.createLineBorder(Color.red));
                return false;
            }
            try {
                Integer value = new Integer(s);
                if (value < 1) {
                    ((JComponent)this.getComponent()).setBorder(BorderFactory.createLineBorder(Color.red));
                    return false;
                }
            }
            catch (NumberFormatException ex) {
                ((JComponent)this.getComponent()).setBorder(BorderFactory.createLineBorder(Color.red));
                return false;
            }
            boolean successful = super.stopCellEditing();
            if (successful) {
                ImportsSettingsPage.this.trigger.actionPerformed(null);
            }
            return successful;
        }
    }

    private static final class ListEntry {
        String depth;
        String name;

        public ListEntry(String name, String depth) {
            this.name = name;
            this.depth = depth;
        }
    }

    private static class DataModel
    extends DefaultTableModel {
        static /* synthetic */ Class class$java$lang$Integer;
        static /* synthetic */ Class class$java$lang$String;

        public DataModel(Object[][] data, Object[] columnNames) {
            super(data, columnNames);
        }

        public Class getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 1: {
                    return class$java$lang$Integer == null ? (class$java$lang$Integer = DataModel.class$("java.lang.Integer")) : class$java$lang$Integer;
                }
            }
            return class$java$lang$String == null ? (class$java$lang$String = DataModel.class$("java.lang.String")) : class$java$lang$String;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

