/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.swing;

import de.hunsicker.jalopy.storage.ConventionKeys;
import de.hunsicker.jalopy.swing.AbstractSettingsPage;
import de.hunsicker.jalopy.swing.ComboBoxPanel;
import de.hunsicker.jalopy.swing.NumberComboBoxPanel;
import de.hunsicker.jalopy.swing.NumberComboBoxPanelCheckBox;
import de.hunsicker.jalopy.swing.SettingsContainer;
import de.hunsicker.swing.util.SwingHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BlankLinesSettingsPage
extends AbstractSettingsPage {
    private static final String EMPTY_STRING = "".intern();
    private JCheckBox _blankLinesAfterLeftCurlyCheckBox;
    private JCheckBox _blankLinesBeforeRightCurlyCheckBox;
    private JCheckBox _chunksByBlankLinesCheckBox;
    private JCheckBox _chunksByCommentsCheckBox;
    private JCheckBox _keepBlankLinesCheckBox;
    private JCheckBox _separatorCheckBox;
    private JCheckBox _separatorRecursiveCheckBox;
    private JComboBox _blankLinesAfterLeftCurlyComboBox;
    private JComboBox _blankLinesBeforeRightCurlyComboBox;
    private JComboBox _fillCharacterComboBox;
    private JComboBox _keepBlankLinesComboBox;
    private JComboBox _linesAfterBlockComboBox;
    private JComboBox _linesAfterClassComboBox;
    private JComboBox _linesAfterDeclarationComboBox;
    private JComboBox _linesAfterImportComboBox;
    private JComboBox _linesAfterInterfaceComboBox;
    private JComboBox _linesAfterMethodComboBox;
    private JComboBox _linesAfterPackageComboBox;
    private JComboBox _linesBeforeBlockComboBox;
    private JComboBox _linesBeforeCaseComboBox;
    private JComboBox _linesBeforeControlComboBox;
    private JComboBox _linesBeforeDeclarationComboBox;
    private JComboBox _linesBeforeJavadocComboBox;
    private JComboBox _linesBeforeMultiLineComboBox;
    private JComboBox _linesBeforeSingleLineComboBox;
    private JTabbedPane _tabbedPane;
    private JTextField _classTextField;
    private JTextField _constructorTextField;
    private JTextField _instanceInitTextField;
    private JTextField _instanceVarTextField;
    private JTextField _interfaceTextField;
    private JTextField _methodTextField;
    private JTextField _staticVarInitTextField;

    public BlankLinesSettingsPage() {
        this.initialize();
    }

    BlankLinesSettingsPage(SettingsContainer container) {
        super(container);
        this.initialize();
    }

    public String getPreviewFileName() {
        switch (this._tabbedPane.getSelectedIndex()) {
            case 1: {
                return "separation";
            }
            case 2: {
                return "separationcomments";
            }
        }
        return super.getPreviewFileName();
    }

    public void updateSettings() {
        this.settings.put(ConventionKeys.BLANK_LINES_AFTER_METHOD, (String)this._linesAfterMethodComboBox.getSelectedItem());
        this.settings.put(ConventionKeys.BLANK_LINES_AFTER_CLASS, (String)this._linesAfterClassComboBox.getSelectedItem());
        this.settings.put(ConventionKeys.BLANK_LINES_AFTER_INTERFACE, (String)this._linesAfterInterfaceComboBox.getSelectedItem());
        this.settings.put(ConventionKeys.BLANK_LINES_AFTER_IMPORT, (String)this._linesAfterImportComboBox.getSelectedItem());
        this.settings.put(ConventionKeys.BLANK_LINES_AFTER_PACKAGE, (String)this._linesAfterPackageComboBox.getSelectedItem());
        this.settings.put(ConventionKeys.BLANK_LINES_AFTER_DECLARATION, (String)this._linesAfterDeclarationComboBox.getSelectedItem());
        this.settings.put(ConventionKeys.BLANK_LINES_BEFORE_DECLARATION, (String)this._linesBeforeDeclarationComboBox.getSelectedItem());
        this.settings.put(ConventionKeys.BLANK_LINES_BEFORE_COMMENT_SINGLE_LINE, (String)this._linesBeforeSingleLineComboBox.getSelectedItem());
        this.settings.put(ConventionKeys.BLANK_LINES_BEFORE_COMMENT_MULTI_LINE, (String)this._linesBeforeMultiLineComboBox.getSelectedItem());
        this.settings.put(ConventionKeys.BLANK_LINES_BEFORE_CASE_BLOCK, (String)this._linesBeforeCaseComboBox.getSelectedItem());
        this.settings.put(ConventionKeys.BLANK_LINES_BEFORE_BLOCK, (String)this._linesBeforeBlockComboBox.getSelectedItem());
        this.settings.put(ConventionKeys.BLANK_LINES_AFTER_BLOCK, (String)this._linesAfterBlockComboBox.getSelectedItem());
        this.settings.put(ConventionKeys.BLANK_LINES_BEFORE_CONTROL, (String)this._linesBeforeControlComboBox.getSelectedItem());
        this.settings.put(ConventionKeys.BLANK_LINES_BEFORE_COMMENT_JAVADOC, (String)this._linesBeforeJavadocComboBox.getSelectedItem());
        this.settings.putBoolean(ConventionKeys.CHUNKS_BY_COMMENTS, this._chunksByCommentsCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.CHUNKS_BY_BLANK_LINES, this._chunksByBlankLinesCheckBox.isSelected());
        this.settings.put(ConventionKeys.SEPARATOR_STATIC_VAR_INIT, this._staticVarInitTextField.getText());
        this.settings.put(ConventionKeys.SEPARATOR_INSTANCE_VAR, this._instanceVarTextField.getText());
        this.settings.put(ConventionKeys.SEPARATOR_INSTANCE_INIT, this._instanceInitTextField.getText());
        this.settings.put(ConventionKeys.SEPARATOR_CTOR, this._constructorTextField.getText());
        this.settings.put(ConventionKeys.SEPARATOR_METHOD, this._methodTextField.getText());
        this.settings.put(ConventionKeys.SEPARATOR_INTERFACE, this._interfaceTextField.getText());
        this.settings.put(ConventionKeys.SEPARATOR_CLASS, this._classTextField.getText());
        this.settings.putBoolean(ConventionKeys.COMMENT_INSERT_SEPARATOR, this._separatorCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.COMMENT_INSERT_SEPARATOR_RECURSIVE, this._separatorRecursiveCheckBox.isSelected());
        this.settings.put(ConventionKeys.SEPARATOR_FILL_CHARACTER, (String)this._fillCharacterComboBox.getSelectedItem());
        if (this._blankLinesAfterLeftCurlyCheckBox.isSelected()) {
            this.settings.put(ConventionKeys.BLANK_LINES_AFTER_BRACE_LEFT, (String)this._blankLinesAfterLeftCurlyComboBox.getSelectedItem());
        } else {
            this.settings.put(ConventionKeys.BLANK_LINES_AFTER_BRACE_LEFT, "-1");
        }
        if (this._blankLinesBeforeRightCurlyCheckBox.isSelected()) {
            this.settings.put(ConventionKeys.BLANK_LINES_BEFORE_BRACE_RIGHT, (String)this._blankLinesBeforeRightCurlyComboBox.getSelectedItem());
        } else {
            this.settings.put(ConventionKeys.BLANK_LINES_BEFORE_BRACE_RIGHT, "-1");
        }
        if (this._keepBlankLinesCheckBox.isSelected()) {
            this.settings.put(ConventionKeys.BLANK_LINES_KEEP_UP_TO, (String)this._keepBlankLinesComboBox.getSelectedItem());
        } else {
            this.settings.put(ConventionKeys.BLANK_LINES_KEEP_UP_TO, "0");
        }
    }

    private JPanel createCommentsPane() {
        JPanel separatorPanel = new JPanel();
        GridBagLayout separatorPanelLayout = new GridBagLayout();
        separatorPanel.setLayout(separatorPanelLayout);
        separatorPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.bundle.getString("BDR_GENERAL")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        GridBagConstraints c = new GridBagConstraints();
        this._separatorCheckBox = new JCheckBox(this.bundle.getString("CHK_ADD_SEPARATOR_COMMENTS"), this.settings.getBoolean(ConventionKeys.COMMENT_INSERT_SEPARATOR, false));
        this._separatorCheckBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 0, 0, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
        separatorPanelLayout.setConstraints(this._separatorCheckBox, c);
        separatorPanel.add(this._separatorCheckBox);
        this._separatorRecursiveCheckBox = new JCheckBox(this.bundle.getString("CHK_ADD_SEPARATOR_COMMENTS_FOR_INNER"), this.settings.getBoolean(ConventionKeys.COMMENT_INSERT_SEPARATOR_RECURSIVE, false));
        this._separatorRecursiveCheckBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 0, 1, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
        separatorPanelLayout.setConstraints(this._separatorRecursiveCheckBox, c);
        separatorPanel.add(this._separatorRecursiveCheckBox);
        JPanel textPanel = new JPanel();
        textPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.bundle.getString("BDR_DESCRIPTIONS")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        GridBagLayout textPanelLayout = new GridBagLayout();
        textPanel.setLayout(textPanelLayout);
        c.insets.right = 10;
        JLabel staticVarInitLabel = new JLabel(this.bundle.getString("LBL_STATIC_VARS"));
        SwingHelper.setConstraints(c, 0, 0, 1, 1, 0.0, 0.0, 17, 0, c.insets, 0, 0);
        textPanelLayout.setConstraints(staticVarInitLabel, c);
        textPanel.add(staticVarInitLabel);
        this._staticVarInitTextField = new JTextField(this.settings.get(ConventionKeys.SEPARATOR_STATIC_VAR_INIT, "Static fields/initializers"), 30);
        c.insets.right = 0;
        SwingHelper.setConstraints(c, 1, 0, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
        textPanelLayout.setConstraints(this._staticVarInitTextField, c);
        textPanel.add(this._staticVarInitTextField);
        JLabel instanceVarLabel = new JLabel(this.bundle.getString("LBL_INSTANCE_VARS"));
        SwingHelper.setConstraints(c, 0, 1, 1, 1, 0.0, 0.0, 17, 0, c.insets, 0, 0);
        textPanelLayout.setConstraints(instanceVarLabel, c);
        textPanel.add(instanceVarLabel);
        this._instanceVarTextField = new JTextField(this.settings.get(ConventionKeys.SEPARATOR_INSTANCE_VAR, "Instance fields"), 30);
        SwingHelper.setConstraints(c, 1, 1, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
        textPanelLayout.setConstraints(this._instanceVarTextField, c);
        textPanel.add(this._instanceVarTextField);
        JLabel instanceInitLabel = new JLabel(this.bundle.getString("LBL_INSTANCE_INITS"));
        SwingHelper.setConstraints(c, 0, 2, 1, 1, 0.0, 0.0, 17, 0, c.insets, 0, 0);
        textPanelLayout.setConstraints(instanceInitLabel, c);
        textPanel.add(instanceInitLabel);
        this._instanceInitTextField = new JTextField(this.settings.get(ConventionKeys.SEPARATOR_INSTANCE_INIT, "Instance initializers"), 30);
        SwingHelper.setConstraints(c, 1, 2, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
        textPanelLayout.setConstraints(this._instanceInitTextField, c);
        textPanel.add(this._instanceInitTextField);
        JLabel constructorLabel = new JLabel(this.bundle.getString("LBL_CTORS"));
        SwingHelper.setConstraints(c, 0, 3, 1, 1, 0.0, 0.0, 17, 0, c.insets, 0, 0);
        textPanelLayout.setConstraints(constructorLabel, c);
        textPanel.add(constructorLabel);
        this._constructorTextField = new JTextField(this.settings.get(ConventionKeys.SEPARATOR_CTOR, "Constructors"), 30);
        SwingHelper.setConstraints(c, 1, 3, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
        textPanelLayout.setConstraints(this._constructorTextField, c);
        textPanel.add(this._constructorTextField);
        JLabel methodLabel = new JLabel(this.bundle.getString("LBL_METHODS"));
        SwingHelper.setConstraints(c, 0, 4, 1, 1, 0.0, 0.0, 17, 0, c.insets, 0, 0);
        textPanelLayout.setConstraints(methodLabel, c);
        textPanel.add(methodLabel);
        this._methodTextField = new JTextField(this.settings.get(ConventionKeys.SEPARATOR_METHOD, "Methods"), 30);
        SwingHelper.setConstraints(c, 1, 4, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
        textPanelLayout.setConstraints(this._methodTextField, c);
        textPanel.add(this._methodTextField);
        JLabel interfaceLabel = new JLabel(this.bundle.getString("LBL_INTERFACES"));
        SwingHelper.setConstraints(c, 0, 5, 1, 1, 0.0, 0.0, 17, 0, c.insets, 0, 0);
        textPanelLayout.setConstraints(interfaceLabel, c);
        textPanel.add(interfaceLabel);
        this._interfaceTextField = new JTextField(this.settings.get(ConventionKeys.SEPARATOR_INTERFACE, "Inner Interfaces"), 30);
        SwingHelper.setConstraints(c, 1, 5, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
        textPanelLayout.setConstraints(this._interfaceTextField, c);
        textPanel.add(this._interfaceTextField);
        JLabel classLabel = new JLabel(this.bundle.getString("LBL_CLASSES"));
        SwingHelper.setConstraints(c, 0, 6, 1, 1, 0.0, 0.0, 17, 0, c.insets, 0, 0);
        textPanelLayout.setConstraints(classLabel, c);
        textPanel.add(classLabel);
        this._classTextField = new JTextField(this.settings.get(ConventionKeys.SEPARATOR_CLASS, "Inner Classes"), 30);
        SwingHelper.setConstraints(c, 1, 6, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
        textPanelLayout.setConstraints(this._classTextField, c);
        textPanel.add(this._classTextField);
        JPanel characterPanel = new JPanel();
        GridBagLayout characterPanelLayout = new GridBagLayout();
        characterPanel.setLayout(characterPanelLayout);
        characterPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.bundle.getString("BDR_FILL_CHARACTER")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        Object[] items = new Object[]{"\u00b7", ".", "-", "=", "*", "/"};
        ComboBoxPanel fillCharacterComboBoxPanel = new ComboBoxPanel(this.bundle.getString("LBL_CHARACTER"), items, this.settings.get(ConventionKeys.SEPARATOR_FILL_CHARACTER, "-"));
        this._fillCharacterComboBox = fillCharacterComboBoxPanel.getComboBox();
        this._fillCharacterComboBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 0, 0, 0, 1, 1.0, 0.0, 17, 0, c.insets, 0, 0);
        characterPanelLayout.setConstraints(fillCharacterComboBoxPanel, c);
        characterPanel.add(fillCharacterComboBoxPanel);
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        c.insets.top = 10;
        c.insets.bottom = 0;
        c.insets.left = 5;
        c.insets.right = 5;
        SwingHelper.setConstraints(c, 0, 0, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
        layout.setConstraints(separatorPanel, c);
        panel.add(separatorPanel);
        SwingHelper.setConstraints(c, 0, 1, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
        layout.setConstraints(textPanel, c);
        panel.add(textPanel);
        c.insets.bottom = 10;
        SwingHelper.setConstraints(c, 0, 2, 0, 1, 1.0, 1.0, 18, 2, c.insets, 0, 0);
        layout.setConstraints(characterPanel, c);
        panel.add(characterPanel);
        return panel;
    }

    private JPanel createGeneralPane() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5));
        GridBagLayout panelLayout = new GridBagLayout();
        panel.setLayout(panelLayout);
        Object[] items = this.createItemList(new int[]{0, 1, 2, 3, 4, 5});
        JLabel packageLabel = new JLabel(this.bundle.getString("LBL_PACKAGE"));
        GridBagConstraints c = new GridBagConstraints();
        SwingHelper.setConstraints(c, 0, 0, 1, 1, 0.3, 0.0, 17, 0, c.insets, 0, 0);
        panelLayout.setConstraints(packageLabel, c);
        panel.add(packageLabel);
        NumberComboBoxPanel afterPackage = new NumberComboBoxPanel(this.bundle.getString("LBL_AFTER"), items, this.settings.get(ConventionKeys.BLANK_LINES_AFTER_PACKAGE, String.valueOf(1)));
        SwingHelper.setConstraints(c, 2, 0, 0, 1, 0.0, 0.0, 13, 0, c.insets, 0, 0);
        this._linesAfterPackageComboBox = afterPackage.getComboBox();
        this._linesAfterPackageComboBox.addActionListener(this.trigger);
        panelLayout.setConstraints(afterPackage, c);
        panel.add(afterPackage);
        JLabel importLabel = new JLabel(this.bundle.getString("LBL_LAST_IMPORT"));
        SwingHelper.setConstraints(c, 0, 1, 1, 1, 0.3, 0.0, 17, 0, c.insets, 0, 0);
        panelLayout.setConstraints(importLabel, c);
        panel.add(importLabel);
        NumberComboBoxPanel afterImport = new NumberComboBoxPanel(this.bundle.getString("LBL_AFTER"), items, this.settings.get(ConventionKeys.BLANK_LINES_AFTER_IMPORT, String.valueOf(2)));
        SwingHelper.setConstraints(c, 2, 1, 0, 1, 0.0, 0.0, 13, 0, c.insets, 0, 0);
        this._linesAfterImportComboBox = afterImport.getComboBox();
        this._linesAfterImportComboBox.addActionListener(this.trigger);
        panelLayout.setConstraints(afterImport, c);
        panel.add(afterImport);
        JLabel classLabel = new JLabel(this.bundle.getString("LBL_CLASSES"));
        SwingHelper.setConstraints(c, 0, 2, 1, 1, 0.3, 0.0, 17, 0, c.insets, 0, 0);
        panelLayout.setConstraints(classLabel, c);
        panel.add(classLabel);
        NumberComboBoxPanel afterClass = new NumberComboBoxPanel(this.bundle.getString("LBL_AFTER"), items, this.settings.get(ConventionKeys.BLANK_LINES_AFTER_CLASS, String.valueOf(1)));
        SwingHelper.setConstraints(c, 2, 2, 0, 1, 0.0, 0.0, 13, 0, c.insets, 0, 0);
        this._linesAfterClassComboBox = afterClass.getComboBox();
        this._linesAfterClassComboBox.addActionListener(this.trigger);
        panelLayout.setConstraints(afterClass, c);
        panel.add(afterClass);
        JLabel interfaceLabel = new JLabel(this.bundle.getString("LBL_INTERFACES"));
        SwingHelper.setConstraints(c, 0, 3, 1, 1, 0.3, 0.0, 17, 0, c.insets, 0, 0);
        panelLayout.setConstraints(interfaceLabel, c);
        panel.add(interfaceLabel);
        NumberComboBoxPanel afterInterface = new NumberComboBoxPanel(this.bundle.getString("LBL_AFTER"), items, this.settings.get(ConventionKeys.BLANK_LINES_AFTER_INTERFACE, String.valueOf(1)));
        SwingHelper.setConstraints(c, 2, 3, 0, 1, 0.0, 0.0, 13, 0, c.insets, 0, 0);
        this._linesAfterInterfaceComboBox = afterInterface.getComboBox();
        this._linesAfterInterfaceComboBox.addActionListener(this.trigger);
        panelLayout.setConstraints(afterInterface, c);
        panel.add(afterInterface);
        JLabel methodLabel = new JLabel(this.bundle.getString("LBL_METHODS"));
        SwingHelper.setConstraints(c, 0, 4, 1, 1, 0.3, 0.0, 17, 0, c.insets, 0, 0);
        panelLayout.setConstraints(methodLabel, c);
        panel.add(methodLabel);
        NumberComboBoxPanel afterMethod = new NumberComboBoxPanel(this.bundle.getString("LBL_AFTER"), items, this.settings.get(ConventionKeys.BLANK_LINES_AFTER_METHOD, String.valueOf(1)));
        SwingHelper.setConstraints(c, 2, 4, 0, 1, 0.0, 0.0, 13, 0, c.insets, 0, 0);
        this._linesAfterMethodComboBox = afterMethod.getComboBox();
        this._linesAfterMethodComboBox.addActionListener(this.trigger);
        panelLayout.setConstraints(afterMethod, c);
        panel.add(afterMethod);
        JLabel blockBeforeLabel = new JLabel(this.bundle.getString("LBL_BLOCKS"));
        SwingHelper.setConstraints(c, 0, 5, 1, 1, 0.3, 0.0, 17, 0, c.insets, 0, 0);
        panelLayout.setConstraints(blockBeforeLabel, c);
        panel.add(blockBeforeLabel);
        NumberComboBoxPanel beforeBlock = new NumberComboBoxPanel(this.bundle.getString("LBL_BEFORE"), items, this.settings.get(ConventionKeys.BLANK_LINES_BEFORE_BLOCK, String.valueOf(1)));
        SwingHelper.setConstraints(c, 1, 5, 1, 1, 0.0, 0.0, 13, 0, c.insets, 0, 0);
        this._linesBeforeBlockComboBox = beforeBlock.getComboBox();
        this._linesBeforeBlockComboBox.addActionListener(this.trigger);
        panelLayout.setConstraints(beforeBlock, c);
        panel.add(beforeBlock);
        NumberComboBoxPanel afterBlock = new NumberComboBoxPanel(this.bundle.getString("LBL_AFTER"), items, this.settings.get(ConventionKeys.BLANK_LINES_AFTER_BLOCK, String.valueOf(1)));
        SwingHelper.setConstraints(c, 2, 5, 0, 1, 0.0, 0.0, 13, 0, c.insets, 0, 0);
        this._linesAfterBlockComboBox = afterBlock.getComboBox();
        this._linesAfterBlockComboBox.addActionListener(this.trigger);
        panelLayout.setConstraints(afterBlock, c);
        panel.add(afterBlock);
        JLabel declarationLabel = new JLabel(this.bundle.getString("LBL_DECLARATIONS"));
        SwingHelper.setConstraints(c, 0, 6, 1, 1, 0.3, 0.0, 17, 0, c.insets, 0, 0);
        panelLayout.setConstraints(declarationLabel, c);
        panel.add(declarationLabel);
        NumberComboBoxPanel beforeDeclaration = new NumberComboBoxPanel(this.bundle.getString("LBL_BEFORE"), items, this.settings.get(ConventionKeys.BLANK_LINES_BEFORE_DECLARATION, String.valueOf(1)));
        SwingHelper.setConstraints(c, 1, 6, 0, 1, 0.7, 0.0, 17, 0, c.insets, 0, 0);
        this._linesBeforeDeclarationComboBox = beforeDeclaration.getComboBox();
        this._linesBeforeDeclarationComboBox.addActionListener(this.trigger);
        panelLayout.setConstraints(beforeDeclaration, c);
        panel.add(beforeDeclaration);
        NumberComboBoxPanel afterDeclaration = new NumberComboBoxPanel(this.bundle.getString("LBL_AFTER"), items, this.settings.get(ConventionKeys.BLANK_LINES_AFTER_DECLARATION, String.valueOf(0)));
        SwingHelper.setConstraints(c, 2, 6, 0, 1, 0.0, 0.0, 13, 0, c.insets, 0, 0);
        this._linesAfterDeclarationComboBox = afterDeclaration.getComboBox();
        this._linesAfterDeclarationComboBox.addActionListener(this.trigger);
        panelLayout.setConstraints(afterDeclaration, c);
        panel.add(afterDeclaration);
        JLabel caseLabel = new JLabel(this.bundle.getString("LBL_CASE_BLOCKS"));
        SwingHelper.setConstraints(c, 0, 7, 1, 1, 0.3, 0.0, 17, 0, c.insets, 0, 0);
        panelLayout.setConstraints(caseLabel, c);
        panel.add(caseLabel);
        NumberComboBoxPanel beforeCase = new NumberComboBoxPanel(this.bundle.getString("LBL_BEFORE"), items, this.settings.get(ConventionKeys.BLANK_LINES_BEFORE_CASE_BLOCK, String.valueOf(1)));
        SwingHelper.setConstraints(c, 1, 7, 0, 1, 0.7, 0.0, 17, 0, c.insets, 0, 0);
        this._linesBeforeCaseComboBox = beforeCase.getComboBox();
        this._linesBeforeCaseComboBox.addActionListener(this.trigger);
        panelLayout.setConstraints(beforeCase, c);
        panel.add(beforeCase);
        JLabel controlLabel = new JLabel(this.bundle.getString("LBL_CONTROL"));
        SwingHelper.setConstraints(c, 0, 8, 1, 1, 0.3, 0.0, 17, 0, c.insets, 0, 0);
        panelLayout.setConstraints(controlLabel, c);
        panel.add(controlLabel);
        NumberComboBoxPanel beforeControlPanel = new NumberComboBoxPanel(this.bundle.getString("LBL_BEFORE"), items, this.settings.get(ConventionKeys.BLANK_LINES_BEFORE_CONTROL, String.valueOf(1)));
        SwingHelper.setConstraints(c, 1, 8, 0, 1, 0.7, 0.0, 17, 0, c.insets, 0, 0);
        this._linesBeforeControlComboBox = beforeControlPanel.getComboBox();
        this._linesBeforeControlComboBox.addActionListener(this.trigger);
        panelLayout.setConstraints(beforeControlPanel, c);
        panel.add(beforeControlPanel);
        JLabel singleLineLabel = new JLabel(this.bundle.getString("LBL_SINGLE_LINE"));
        SwingHelper.setConstraints(c, 0, 9, 1, 1, 0.3, 0.0, 17, 0, c.insets, 0, 0);
        panelLayout.setConstraints(singleLineLabel, c);
        panel.add(singleLineLabel);
        NumberComboBoxPanel beforeSingleLine = new NumberComboBoxPanel(this.bundle.getString("LBL_BEFORE"), items, this.settings.get(ConventionKeys.BLANK_LINES_BEFORE_COMMENT_SINGLE_LINE, String.valueOf(1)));
        SwingHelper.setConstraints(c, 1, 9, 0, 1, 0.7, 0.0, 17, 0, c.insets, 0, 0);
        this._linesBeforeSingleLineComboBox = beforeSingleLine.getComboBox();
        this._linesBeforeSingleLineComboBox.addActionListener(this.trigger);
        panelLayout.setConstraints(beforeSingleLine, c);
        panel.add(beforeSingleLine);
        JLabel multiLineLabel = new JLabel(this.bundle.getString("LBL_MULTI_LINE"));
        SwingHelper.setConstraints(c, 0, 10, 1, 1, 0.3, 0.0, 17, 0, c.insets, 0, 0);
        panelLayout.setConstraints(multiLineLabel, c);
        panel.add(multiLineLabel);
        NumberComboBoxPanel beforeMultiLine = new NumberComboBoxPanel(this.bundle.getString("LBL_BEFORE"), items, this.settings.get(ConventionKeys.BLANK_LINES_BEFORE_COMMENT_MULTI_LINE, String.valueOf(1)));
        SwingHelper.setConstraints(c, 1, 10, 0, 1, 0.7, 0.0, 18, 0, c.insets, 0, 0);
        this._linesBeforeMultiLineComboBox = beforeMultiLine.getComboBox();
        this._linesBeforeMultiLineComboBox.addActionListener(this.trigger);
        panelLayout.setConstraints(beforeMultiLine, c);
        panel.add(beforeMultiLine);
        JLabel javadocLabel = new JLabel(this.bundle.getString("LBL_JAVADOC_COMMENTS"));
        SwingHelper.setConstraints(c, 0, 11, 1, 1, 0.3, 0.0, 17, 0, c.insets, 0, 0);
        panelLayout.setConstraints(javadocLabel, c);
        panel.add(javadocLabel);
        NumberComboBoxPanel beforeJavadocSettingsPage = new NumberComboBoxPanel(this.bundle.getString("LBL_BEFORE"), items, this.settings.get(ConventionKeys.BLANK_LINES_BEFORE_COMMENT_JAVADOC, String.valueOf(1)));
        SwingHelper.setConstraints(c, 1, 11, 0, 1, 0.7, 0.0, 18, 0, c.insets, 0, 0);
        this._linesBeforeJavadocComboBox = beforeJavadocSettingsPage.getComboBox();
        this._linesBeforeJavadocComboBox.addActionListener(this.trigger);
        panelLayout.setConstraints(beforeJavadocSettingsPage, c);
        panel.add(beforeJavadocSettingsPage);
        SwingHelper.setConstraints(c, 0, 12, 0, 1, 0.0, 1.0, 18, 0, c.insets, 0, 0);
        Component glue = Box.createVerticalGlue();
        panelLayout.setConstraints(glue, c);
        panel.add(glue);
        return panel;
    }

    private JPanel createMiscPane() {
        JPanel arrayPanel = new JPanel();
        arrayPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.bundle.getString("BDR_MISC")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        GridBagLayout arrayLayout = new GridBagLayout();
        arrayPanel.setLayout(arrayLayout);
        Object[] items = this.createItemList(new int[]{0, 1, 2, 3, 4, 5});
        int blankLinesAfterLeftCurly = this.settings.getInt(ConventionKeys.BLANK_LINES_AFTER_BRACE_LEFT, 0);
        NumberComboBoxPanelCheckBox blankLinesAfterLeftCurlyCheck = new NumberComboBoxPanelCheckBox(this.bundle.getString("LBL_BLANK_LINES_AFTER_LEFT"), blankLinesAfterLeftCurly > -1, EMPTY_STRING, items, blankLinesAfterLeftCurly > -1 ? String.valueOf(blankLinesAfterLeftCurly) : "0");
        this._blankLinesAfterLeftCurlyCheckBox = blankLinesAfterLeftCurlyCheck.getCheckBox();
        this._blankLinesAfterLeftCurlyCheckBox.addActionListener(this.trigger);
        this._blankLinesAfterLeftCurlyComboBox = blankLinesAfterLeftCurlyCheck.getComboBoxPanel().getComboBox();
        this._blankLinesAfterLeftCurlyComboBox.addActionListener(this.trigger);
        GridBagConstraints c = new GridBagConstraints();
        SwingHelper.setConstraints(c, 0, 0, 0, 1, 1.0, 0.0, 17, 2, c.insets, 0, 0);
        arrayLayout.setConstraints(blankLinesAfterLeftCurlyCheck, c);
        arrayPanel.add(blankLinesAfterLeftCurlyCheck);
        int blankLinesBeforeRightCurly = this.settings.getInt(ConventionKeys.BLANK_LINES_BEFORE_BRACE_RIGHT, 0);
        NumberComboBoxPanelCheckBox blankLinesBeforeRightCurlyCheck = new NumberComboBoxPanelCheckBox(this.bundle.getString("LBL_BLANK_LINES_BEFORE_RIGHT"), blankLinesBeforeRightCurly > -1, EMPTY_STRING, items, blankLinesBeforeRightCurly > -1 ? String.valueOf(blankLinesBeforeRightCurly) : "0");
        this._blankLinesBeforeRightCurlyCheckBox = blankLinesBeforeRightCurlyCheck.getCheckBox();
        this._blankLinesBeforeRightCurlyComboBox = blankLinesBeforeRightCurlyCheck.getComboBoxPanel().getComboBox();
        this._blankLinesBeforeRightCurlyCheckBox.addActionListener(this.trigger);
        this._blankLinesBeforeRightCurlyComboBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 0, 1, 0, 1, 1.0, 0.0, 17, 2, c.insets, 0, 0);
        arrayLayout.setConstraints(blankLinesBeforeRightCurlyCheck, c);
        arrayPanel.add(blankLinesBeforeRightCurlyCheck);
        int keepBlankLines = this.settings.getInt(ConventionKeys.BLANK_LINES_KEEP_UP_TO, 1);
        Object[] blankItems = this.createItemList(new int[]{1, 2, 3, 4, 5});
        NumberComboBoxPanelCheckBox keepBlankLinesCheck = new NumberComboBoxPanelCheckBox(this.bundle.getString("LBL_KEEP_BLANK_LINES"), keepBlankLines > 0, EMPTY_STRING, blankItems, keepBlankLines > 0 ? String.valueOf(keepBlankLines) : "1");
        this._keepBlankLinesCheckBox = keepBlankLinesCheck.getCheckBox();
        this._keepBlankLinesComboBox = keepBlankLinesCheck.getComboBoxPanel().getComboBox();
        this._keepBlankLinesCheckBox.addActionListener(this.trigger);
        this._keepBlankLinesComboBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 0, 2, 0, 1, 1.0, 1.0, 18, 2, c.insets, 0, 0);
        arrayLayout.setConstraints(keepBlankLinesCheck, c);
        arrayPanel.add(keepBlankLinesCheck);
        JPanel chunksPanel = new JPanel();
        chunksPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.bundle.getString("BDR_CHUNKS")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        GridBagLayout chunksPanelLayout = new GridBagLayout();
        chunksPanel.setLayout(chunksPanelLayout);
        this._chunksByCommentsCheckBox = new JCheckBox(this.bundle.getString("CHK_BY_COMMENTS"), this.settings.getBoolean(ConventionKeys.CHUNKS_BY_COMMENTS, true));
        this._chunksByCommentsCheckBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 0, 0, 0, 1, 1.0, 0.0, 17, 2, c.insets, 0, 0);
        chunksPanelLayout.setConstraints(this._chunksByCommentsCheckBox, c);
        chunksPanel.add(this._chunksByCommentsCheckBox);
        this._chunksByBlankLinesCheckBox = new JCheckBox(this.bundle.getString("CHK_BY_BLANK_LINES"), this.settings.getBoolean(ConventionKeys.CHUNKS_BY_BLANK_LINES, true));
        this._chunksByBlankLinesCheckBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 0, 1, 0, 1, 1.0, 1.0, 17, 2, c.insets, 0, 0);
        chunksPanelLayout.setConstraints(this._chunksByBlankLinesCheckBox, c);
        chunksPanel.add(this._chunksByBlankLinesCheckBox);
        this._chunksByBlankLinesCheckBox.setEnabled(this._keepBlankLinesCheckBox.isSelected());
        GridBagLayout layout = new GridBagLayout();
        JPanel panel = new JPanel();
        panel.setLayout(layout);
        c.insets.top = 10;
        c.insets.bottom = 10;
        c.insets.left = 5;
        c.insets.right = 5;
        SwingHelper.setConstraints(c, 0, 0, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
        layout.setConstraints(arrayPanel, c);
        panel.add(arrayPanel);
        c.insets.top = 0;
        SwingHelper.setConstraints(c, 0, 1, 0, 1, 1.0, 1.0, 18, 2, c.insets, 0, 0);
        layout.setConstraints(chunksPanel, c);
        panel.add(chunksPanel);
        this._keepBlankLinesCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                if (BlankLinesSettingsPage.this._keepBlankLinesCheckBox.isSelected()) {
                    BlankLinesSettingsPage.this._chunksByBlankLinesCheckBox.setEnabled(true);
                } else {
                    BlankLinesSettingsPage.this._chunksByBlankLinesCheckBox.setEnabled(false);
                }
            }
        });
        return panel;
    }

    private void initialize() {
        this._tabbedPane = new JTabbedPane();
        this._tabbedPane.add((Component)this.createGeneralPane(), this.bundle.getString("TAB_GENERAL"));
        this._tabbedPane.add((Component)this.createMiscPane(), this.bundle.getString("TAB_MISC"));
        this._tabbedPane.add((Component)this.createCommentsPane(), this.bundle.getString("TAB_COMMENTS"));
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        this.add((Component)this._tabbedPane, "Center");
        if (this.getContainer() != null) {
            this._tabbedPane.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent ev) {
                    String text = BlankLinesSettingsPage.this.getContainer().loadPreview(BlankLinesSettingsPage.this.getPreviewFileName());
                    BlankLinesSettingsPage.this.getContainer().getPreview().setText(text);
                }
            });
        }
    }
}

