/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import de.hunsicker.antlr.collections.AST;
import de.hunsicker.jalopy.language.JavaNode;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;

final class SwitchPrinter
extends AbstractPrinter {
    private static final Printer INSTANCE = new SwitchPrinter();

    protected SwitchPrinter() {
    }

    public static final Printer getInstance() {
        return INSTANCE;
    }

    public void print(AST node, NodeWriter out) throws IOException {
        boolean indentCaseFromSwitch;
        this.printCommentsBefore(node, out);
        int offset = out.print("switch", 101);
        this.trackPosition((JavaNode)node, out.line, offset, out);
        if (settings.getBoolean(ConventionKeys.SPACE_BEFORE_STATEMENT_PAREN, true)) {
            out.print(" ", 101);
        }
        AST lparen = node.getFirstChild();
        PrinterFactory.create(lparen).print(lparen, out);
        AST expr = lparen.getNextSibling();
        PrinterFactory.create(expr).print(expr, out);
        JavaNode rparen = (JavaNode)expr.getNextSibling();
        PrinterFactory.create(rparen).print(rparen, out);
        AST lcurly = rparen.getNextSibling();
        boolean leftBraceNewline = settings.getBoolean(ConventionKeys.BRACE_NEWLINE_LEFT, false);
        boolean commentsAfter = ((JavaNode)lcurly).hasCommentsAfter();
        if (out.newline) {
            out.printLeftBrace(false, !commentsAfter, false);
        } else {
            out.printLeftBrace(leftBraceNewline, !commentsAfter, true);
        }
        if (commentsAfter) {
            this.printCommentsAfter(lcurly, true, true, out);
        }
        if (!(indentCaseFromSwitch = settings.getBoolean(ConventionKeys.INDENT_CASE_FROM_SWITCH, false))) {
            out.unindent();
        }
        JavaNode rcurly = null;
        AST child = lcurly.getNextSibling();
        block3: while (child != null) {
            switch (child.getType()) {
                case 8: {
                    rcurly = (JavaNode)child;
                    break block3;
                }
                default: {
                    PrinterFactory.create(child).print(child, out);
                    child = child.getNextSibling();
                }
            }
        }
        if (!indentCaseFromSwitch) {
            out.indent();
        }
        this.printCommentsBefore(rcurly, out);
        out.printRightBrace(false);
        if (!this.printCommentsAfter(rcurly, false, true, out)) {
            out.printNewline();
        }
        out.last = 8;
    }
}

