/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import de.hunsicker.antlr.collections.AST;
import de.hunsicker.jalopy.language.JavaNode;
import de.hunsicker.jalopy.language.JavaNodeHelper;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;

class BlockPrinter
extends AbstractPrinter {
    private static final Printer INSTANCE = new BlockPrinter();

    protected BlockPrinter() {
    }

    public static Printer getInstance() {
        return INSTANCE;
    }

    public void print(AST node, NodeWriter out) throws IOException {
        int closeBraceType;
        boolean leftBraceNewline;
        boolean insertEmptyStatement;
        boolean cuddleEmpty;
        boolean freestanding;
        boolean treatDifferent;
        boolean forceNewlineBefore;
        JavaNode lcurly;
        block38: {
            block39: {
                lcurly = (JavaNode)node;
                forceNewlineBefore = out.state.newlineBeforeLeftBrace;
                treatDifferent = settings.getBoolean(ConventionKeys.BRACE_TREAT_DIFFERENT, false);
                if (treatDifferent) {
                    switch (lcurly.getParent().getType()) {
                        case 12: 
                        case 13: 
                        case 18: 
                        case 19: {
                            forceNewlineBefore = true;
                            break;
                        }
                        case 50: {
                            forceNewlineBefore = false;
                            treatDifferent = false;
                            break;
                        }
                        default: {
                            treatDifferent = false;
                        }
                    }
                }
                freestanding = JavaNodeHelper.isFreestandingBlock(lcurly);
                cuddleEmpty = settings.getBoolean(ConventionKeys.BRACE_EMPTY_CUDDLE, false);
                insertEmptyStatement = settings.getBoolean(ConventionKeys.BRACE_EMPTY_INSERT_STATEMENT, false);
                leftBraceNewline = settings.getBoolean(ConventionKeys.BRACE_NEWLINE_LEFT, false);
                int n = closeBraceType = node.getType() == 11 ? 8 : 10;
                if (!JavaNodeHelper.isEmptyBlock(node)) break block38;
                if (!insertEmptyStatement) break block39;
                switch (((JavaNode)node).getParent().getType()) {
                    case 12: 
                    case 13: 
                    case 18: 
                    case 19: {
                        break block38;
                    }
                    default: {
                        this.printBracesEmptyStatement(lcurly, leftBraceNewline, forceNewlineBefore, freestanding, closeBraceType, out);
                        return;
                    }
                }
            }
            if (cuddleEmpty && !lcurly.getParent().hasCommentsAfter()) {
                this.printBracesCuddled(closeBraceType, lcurly, true, out);
                return;
            }
        }
        switch (out.last) {
            case 103: 
            case 104: {
                break;
            }
            default: {
                if (node.getFirstChild() != null) break;
                if (insertEmptyStatement) {
                    this.printBracesEmptyStatement(lcurly, leftBraceNewline, forceNewlineBefore, freestanding, closeBraceType, out);
                } else if (cuddleEmpty && !lcurly.getParent().hasCommentsAfter()) {
                    this.printBracesCuddled(closeBraceType, lcurly, false, out);
                } else {
                    int offset = out.printLeftBrace();
                    this.trackPosition(lcurly, out.line - 1, offset, out);
                    if (out.state.newlineBeforeLeftBrace) {
                        out.state.newlineBeforeLeftBrace = false;
                    }
                    out.printRightBrace(8, !treatDifferent, true);
                    JavaNode rcurly = (JavaNode)lcurly.getFirstChild();
                    this.trackPosition(rcurly, out.line - 1, offset + 1, out);
                    out.last = closeBraceType;
                }
                return;
            }
        }
        boolean brace = true;
        boolean indent = false;
        boolean removeBlockBraces = settings.getBoolean(ConventionKeys.BRACE_REMOVE_BLOCK, true);
        if (freestanding) {
            if (removeBlockBraces && this.canRemoveBraces(lcurly)) {
                brace = false;
            }
            indent = false;
        } else {
            switch (out.last) {
                case 92: {
                    if (!settings.getBoolean(ConventionKeys.BRACE_REMOVE_IF_ELSE, false) || this.isBraceNecessary(node)) break;
                    brace = false;
                    indent = true;
                    out.printNewline();
                    break;
                }
                case 94: {
                    if (!settings.getBoolean(ConventionKeys.BRACE_REMOVE_FOR, false) || this.isBraceNecessary(node)) break;
                    brace = false;
                    indent = true;
                    out.printNewline();
                    break;
                }
                case 95: {
                    if (!settings.getBoolean(ConventionKeys.BRACE_REMOVE_WHILE, false) || this.isBraceNecessary(node)) break;
                    brace = false;
                    indent = true;
                    out.printNewline();
                    break;
                }
                case 96: {
                    if (!settings.getBoolean(ConventionKeys.BRACE_REMOVE_DO_WHILE, false) || this.isBraceNecessary(node)) break;
                    brace = false;
                    indent = true;
                    out.printNewline();
                    break;
                }
                case 103: 
                case 104: {
                    if (!this.isBraceNecessary(node)) {
                        brace = false;
                        indent = true;
                    }
                    leftBraceNewline = false;
                }
            }
        }
        if (brace) {
            this.printLeftBrace(lcurly, leftBraceNewline, forceNewlineBefore, freestanding, out);
        } else if (indent) {
            out.indent();
            out.last = 7;
        }
        JavaNode rcurly = null;
        AST child = node.getFirstChild();
        block20: while (child != null) {
            switch (child.getType()) {
                case 8: {
                    rcurly = (JavaNode)child;
                    break block20;
                }
                default: {
                    PrinterFactory.create(child).print(child, out);
                    child = child.getNextSibling();
                }
            }
        }
        if (brace) {
            this.printCommentsBefore(rcurly, out);
            boolean rightBraceNewline = this.isCloseBraceNewline(lcurly, closeBraceType, freestanding);
            int offset = out.printRightBrace(closeBraceType, !treatDifferent && !freestanding, rightBraceNewline);
            this.trackPosition(rcurly, rightBraceNewline ? out.line - 1 : out.line, offset, out);
            this.printCommentsAfter(rcurly, false, rightBraceNewline, out);
        } else if (indent) {
            out.unindent();
        }
    }

    private boolean isBraceNecessary(AST node) {
        switch (node.getType()) {
            case 10: {
                return true;
            }
        }
        int count = 0;
        AST child = node.getFirstChild();
        while (child != null) {
            block3 : switch (count++) {
                case 0: {
                    switch (child.getType()) {
                        case 14: {
                            return true;
                        }
                        case 32: 
                        case 42: 
                        case 97: 
                        case 99: 
                        case 100: 
                        case 102: {
                            break block3;
                        }
                        case 7: {
                            JavaNode lcurly = (JavaNode)child;
                            if (!lcurly.hasCommentsBefore() && !lcurly.hasCommentsAfter()) break block3;
                            return true;
                        }
                    }
                    return true;
                }
                case 1: {
                    switch (child.getType()) {
                        case 8: {
                            JavaNode rcurly = (JavaNode)child;
                            return rcurly.hasCommentsBefore() || rcurly.hasCommentsAfter();
                        }
                    }
                    break;
                }
                case 2: {
                    return true;
                }
            }
            child = child.getNextSibling();
        }
        return false;
    }

    private boolean isCloseBraceNewline(JavaNode node, int type, boolean freestanding) {
        boolean rightBraceNewline = true;
        if (type == 10) {
            return node.getParent().getType() != 146;
        }
        if (!freestanding) {
            JavaNode next = (JavaNode)node.getNextSibling();
            if (next != null) {
                switch (next.getType()) {
                    case 93: 
                    case 106: 
                    case 107: {
                        rightBraceNewline = settings.getBoolean(ConventionKeys.BRACE_NEWLINE_RIGHT, false);
                        break;
                    }
                    case 95: {
                        switch (next.getParent().getType()) {
                            case 96: {
                                rightBraceNewline = settings.getBoolean(ConventionKeys.BRACE_NEWLINE_RIGHT, false);
                            }
                        }
                    }
                }
            } else {
                JavaNode parent = node.getParent();
                switch (parent.getType()) {
                    case 106: {
                        AST n = parent.getNextSibling();
                        if (n == null) break;
                        switch (n.getType()) {
                            case 106: 
                            case 107: {
                                rightBraceNewline = settings.getBoolean(ConventionKeys.BRACE_NEWLINE_RIGHT, false);
                            }
                        }
                    }
                }
            }
        }
        return rightBraceNewline;
    }

    private boolean canRemoveBraces(JavaNode lcurly) {
        switch (lcurly.getParent().getType()) {
            case 15: {
                return false;
            }
        }
        AST child = lcurly.getFirstChild();
        while (child != null) {
            switch (child.getType()) {
                case 14: {
                    return false;
                }
            }
            child = child.getNextSibling();
        }
        return true;
    }

    private void printBracesCuddled(int type, JavaNode lcurly, boolean newlineAfter, NodeWriter out) throws IOException {
        JavaNode rcurly;
        out.print(out.getString(settings.getInt(ConventionKeys.INDENT_SIZE_BRACE_CUDDLED, 1)), 153);
        out.print("{}", type);
        if (out.state.newlineBeforeLeftBrace) {
            out.state.newlineBeforeLeftBrace = false;
        }
        if (!this.printCommentsAfter(rcurly = (JavaNode)lcurly.getFirstChild(), false, newlineAfter, out) && newlineAfter) {
            out.printNewline();
        }
    }

    private void printBracesEmptyStatement(JavaNode lcurly, boolean leftBraceNewline, boolean forceNewlineBefore, boolean freestanding, int type, NodeWriter out) throws IOException {
        JavaNode rcurly = (JavaNode)lcurly.getFirstChild();
        this.printLeftBrace(lcurly, leftBraceNewline, forceNewlineBefore, freestanding, out);
        if (out.state.newlineBeforeLeftBrace) {
            out.state.newlineBeforeLeftBrace = false;
        }
        out.print(";", out.last);
        out.printNewline();
        boolean newLineAfterBrace = this.isCloseBraceNewline(lcurly, type, freestanding);
        int offset = out.printRightBrace(type, false);
        this.trackPosition(rcurly, out.line, offset, out);
        if (!this.printCommentsAfter(rcurly, false, newLineAfterBrace, out) && newLineAfterBrace) {
            out.printNewline();
        }
        out.last = type;
    }

    private void printLeftBrace(JavaNode lcurly, boolean leftBraceNewline, boolean forceNewlineBefore, boolean freestanding, NodeWriter out) throws IOException {
        AST next;
        int offset;
        if (lcurly.hasCommentsBefore() || freestanding) {
            this.printCommentsBefore(lcurly, false, out);
        }
        boolean commentsAfter = lcurly.hasCommentsAfter();
        if (freestanding) {
            offset = out.printLeftBrace(false, !commentsAfter, false);
            this.trackPosition(lcurly, commentsAfter ? out.line : out.line - 1, offset, out);
        } else if (forceNewlineBefore) {
            offset = out.printLeftBrace(true, !commentsAfter, false);
            this.trackPosition(lcurly, commentsAfter ? out.line : out.line - 1, offset, out);
        } else if (out.newline) {
            offset = out.printLeftBrace(false, !commentsAfter, true);
            this.trackPosition(lcurly, commentsAfter ? out.line : out.line - 1, offset, out);
        } else {
            offset = out.printLeftBrace(leftBraceNewline, !commentsAfter, true);
            this.trackPosition(lcurly, commentsAfter ? out.line : out.line - 1, offset, out);
        }
        if (leftBraceNewline && commentsAfter && (next = lcurly.getFirstChild()) != null && next.getType() == 8) {
            out.printNewline();
        }
        if (out.state.newlineBeforeLeftBrace) {
            out.state.newlineBeforeLeftBrace = false;
        }
        if (commentsAfter) {
            this.printCommentsAfter(lcurly, true, true, out);
        }
    }
}

