/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import de.hunsicker.antlr.CommonHiddenStreamToken;
import de.hunsicker.antlr.collections.AST;
import de.hunsicker.jalopy.language.ExtendedToken;
import de.hunsicker.jalopy.language.JavaNode;
import de.hunsicker.jalopy.language.JavaNodeHelper;
import de.hunsicker.jalopy.language.Node;
import de.hunsicker.jalopy.printer.JavadocPrinter;
import de.hunsicker.jalopy.printer.Marker;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.storage.Convention;
import de.hunsicker.jalopy.storage.ConventionKeys;
import de.hunsicker.jalopy.storage.Loggers;
import de.hunsicker.util.StringHelper;
import java.io.IOException;
import java.util.List;

abstract class AbstractPrinter
implements Printer {
    static final String ASSERT_SPACE = "assert ";
    static final String ASSIGN = "=";
    static final String ASSIGN_PADDED = " = ";
    static final String SPACE_ASSIGN = " =";
    static final String BRACES = "{}";
    static final String BRACKETS = "[]";
    static final String BRACKET_LEFT = "[";
    static final String BRACKET_LEFT_SPACE = "[ ";
    static final String BRACKET_RIGHT = "]";
    static final String CASE_SPACE = "case ";
    static final String CATCH = "catch";
    static final String CLASS_SPACE = "class ";
    static final String COMMA = ",";
    static final String COMMA_SPACE = ", ";
    static final String COLON = ":";
    static final String COLON_SPACE = ": ";
    static final String DEFAULT_COLON = "default:";
    static final String DEFAULT_SPACE_COLON = "default :";
    static final String DO = "do";
    static final String DOT = ".";
    static final String ELSE = "else";
    static final String EMPTY_STRING = "".intern();
    static final String EXTENDS_SPACE = "extends ";
    static final String FINALLY = "finally";
    static final String FOR = "for";
    static final String FOR_SPACE = "for ";
    static final String IF = "if";
    static final String IF_SPACE = "if ";
    static final String IMPLEMENTS_SPACE = "implements ";
    static final String IMPORT_SPACE = "import ";
    static final String INTERFACE_SPACE = "interface ";
    static final String L = "L";
    static final String LCURLY = "{";
    static final String LCURLY_SPACE = "{ ";
    static final String LPAREN = "(";
    static final String LPAREN_SPACE = "( ";
    static final String NEW_SPACE = "new ";
    static final String PACKAGE_SPACE = "package ";
    static final String PARENTHESES = "()";
    static final String QUESTION_SPACE = "? ";
    static final String RCURLY = "}";
    static final String RCURLY_SPACE = " }";
    static final String RETURN = "return";
    static final String RPAREN = ")";
    static final String SEMI = ";";
    static final String SPACE = " ";
    static final String SPACE_BRACKET_RIGHT = " ]";
    static final String SPACE_BRACKETS = " []";
    static final String SPACE_COLON_SPACE = " : ";
    static final String SPACE_EXTENDS_SPACE = " extends ";
    static final String SPACE_LCURLY = " {";
    static final String SPACE_IMPLEMENTS_SPACE = " implements ";
    static final String SPACE_QUESTION = " ?";
    static final String SPACE_QUESTION_SPACE = " ? ";
    static final String SPACE_RPAREN = " )";
    static final String SPACE_THROWS_SPACE = " throws ";
    static final String STATIC = "static";
    static final String STRING = "String";
    static final String SUPER = "super";
    static final String SWITCH = "switch";
    static final String SYNCHRONIZED = "synchronized";
    static final String THIS = "this";
    static final String THROW_SPACE = "throw ";
    static final String THROWS_SPACE = "throws ";
    static final String TRY = "try";
    static final String VOID = "void";
    static final String WHILE = "while";
    static final String WHILE_SPACE = "while ";
    static final String QUESTION = "?";
    protected static final Convention settings = Convention.getInstance();
    private static final boolean WHITESPACE_NO = false;
    private static final boolean WHITESPACE_YES = true;
    private final Object[] _args = new Object[2];

    protected AbstractPrinter() {
    }

    public abstract void print(AST var1, NodeWriter var2) throws IOException;

    public void trackPosition(JavaNode node, NodeWriter out) {
        this.trackPosition(node, out.line, out.column, out);
    }

    public void trackPosition(JavaNode node, int line, int column, NodeWriter out) {
        if (out.tracking && out.mode == 1) {
            node.updatePosition(line, column);
        }
    }

    protected void printIndentation(NodeWriter out) throws IOException {
        this.printIndentation(0, out);
    }

    protected void printIndentation(Marker marker, NodeWriter out) throws IOException {
        if (out.mode == 1) {
            if (marker != null) {
                int indentLength = out.getIndentLength();
                int length = marker.column >= indentLength ? marker.column - indentLength : marker.column;
                out.print(out.getString(length), 153);
            } else if (settings.getBoolean(ConventionKeys.INDENT_DEEP, false) && out.state.markers.isMarked()) {
                int indentLength = out.getIndentLength();
                marker = out.state.markers.getLast();
                int length = marker.column > indentLength ? marker.column - indentLength : marker.column;
                out.print(out.getString(length), 153);
            } else {
                out.print(out.getString(out.state.paramLevel * out.indentSize), 153);
            }
        }
    }

    protected void printIndentation(int diff, NodeWriter out) throws IOException {
        if (out.mode == 1) {
            if (!settings.getBoolean(ConventionKeys.INDENT_DEEP, false)) {
                out.print(out.getString(out.state.paramLevel * out.indentSize + diff), 153);
            } else if (out.state.markers.isMarked()) {
                int length;
                int indentLength = out.getIndentLength();
                Marker marker = out.state.markers.getLast();
                int n = length = marker.column > indentLength ? marker.column - indentLength : marker.column;
                if (length + diff >= 0) {
                    out.print(out.getString(length + diff), 153);
                } else {
                    out.print(out.getString(length), 153);
                }
            }
        }
    }

    final boolean isChildOf(JavaNode node, JavaNode child) {
        block4: {
            block3: {
                JavaNode parent = child.getParent();
                if (parent == node) break block3;
                switch (parent.getType()) {
                    case 7: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 17: 
                    case 24: 
                    case 53: 
                    case 74: 
                    case 92: 
                    case 94: 
                    case 95: 
                    case 96: 
                    case 105: 
                    case 106: 
                    case 107: {
                        break block4;
                    }
                    default: {
                        return this.isChildOf(node, parent);
                    }
                }
            }
            return true;
        }
        return false;
    }

    int getOriginalBlankLines(JavaNode node) {
        int keepLinesUpTo = settings.getInt(ConventionKeys.BLANK_LINES_KEEP_UP_TO, 1);
        if (keepLinesUpTo <= 0) {
            return 0;
        }
        switch (node.getPreviousSibling().getType()) {
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 34: 
            case 49: {
                return 0;
            }
            case 14: {
                if (this.isLocalVariable(node)) break;
                return 0;
            }
        }
        switch (node.getType()) {
            case 32: {
                JavaNode child = (JavaNode)node.getFirstChild();
                while (child != null) {
                    CommonHiddenStreamToken t;
                    if (child.hasCommentsBefore() && (t = child.getCommentBefore()) != null) {
                        int l = t.getLine() - node.getPreviousSibling().getEndLine() - 1;
                        if (l > keepLinesUpTo) {
                            return keepLinesUpTo;
                        }
                        return Math.max(l, 0);
                    }
                    child = (JavaNode)child.getFirstChild();
                }
                break;
            }
            case 14: {
                if (this.isLocalVariable(node)) break;
                return 0;
            }
            case 8: {
                int blankLinesBeforeRcurly = settings.getInt(ConventionKeys.BLANK_LINES_BEFORE_BRACE_RIGHT, 0);
                if (blankLinesBeforeRcurly == -1) break;
                return blankLinesBeforeRcurly;
            }
        }
        JavaNode prev = node.getPreviousSibling();
        int result = 0;
        if (prev != null) {
            if (!node.hasCommentsBefore()) {
                if (node.getParent().getType() != 32) {
                    result = node.getStartLine() - prev.getEndLine() - 1;
                }
            } else if (node.getParent().getType() != 32) {
                result = node.getHiddenBefore().getLine() - prev.getEndLine() - 1;
            }
        }
        if (result > keepLinesUpTo) {
            return keepLinesUpTo;
        }
        return result;
    }

    void logIssues(AST node, NodeWriter out) {
        if (out.mode == 1 && out.issues.containsKey(node)) {
            Object value = out.issues.get(node);
            this._args[0] = out.filename;
            this._args[1] = String.valueOf(out.line);
            StringBuffer buf = new StringBuffer(250);
            if (value instanceof List) {
                List issues = (List)value;
                int i = 0;
                int size = issues.size();
                while (i < size) {
                    JavaNode n = (JavaNode)node;
                    buf.append(out.filename);
                    buf.append(':');
                    buf.append(out.line);
                    buf.append(':');
                    buf.append((String)issues.get(i));
                    Loggers.IO.warn((Object)buf.toString());
                    buf.setLength(0);
                    ++i;
                }
            } else {
                buf.append(out.filename);
                buf.append(':');
                buf.append(out.line);
                buf.append(':');
                buf.append((String)value);
                Loggers.IO.warn((Object)buf.toString());
            }
        }
    }

    void printBlankLinesBefore(JavaNode node, NodeWriter out) throws IOException {
        int blankLines = this.getBlankLinesBefore(node, out);
        out.printBlankLines(blankLines);
        switch (node.getType()) {
            case 32: {
                out.blankLines = blankLines;
                out.expression = node;
            }
        }
    }

    boolean printCommentsAfter(AST node, NodeWriter out) throws IOException {
        if (out.mode != 1) {
            return false;
        }
        JavaNode n = (JavaNode)node;
        if (n.getHiddenAfter() == null) {
            return false;
        }
        boolean result = false;
        switch (node.getType()) {
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 77: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 101: 
            case 105: 
            case 106: 
            case 107: {
                if (!settings.getBoolean(ConventionKeys.BRACE_NEWLINE_LEFT, false)) break;
                result = this.printCommentsAfter(node, false, false, out);
                break;
            }
            default: {
                result = this.printCommentsAfter(node, false, false, out);
            }
        }
        return result;
    }

    boolean printCommentsAfter(AST node, boolean newlineBefore, boolean newlineAfter, NodeWriter out) throws IOException {
        JavaNode n = (JavaNode)node;
        if (n.getHiddenAfter() == null) {
            return false;
        }
        if (node.getType() != 8 || out.getIndentLevel() != 0) {
            int offset = out.column - 1 + settings.getInt(ConventionKeys.INDENT_SIZE_COMMENT_ENDLINE, 1);
            CommonHiddenStreamToken firstComment = n.getHiddenAfter();
            if (firstComment.getHiddenAfter() != null) {
                this.printCommentAfter(n, firstComment, newlineBefore, true, true, true, out);
                if (out.mode != 1) {
                    return false;
                }
                int indentLength = out.getIndentLength();
                CommonHiddenStreamToken comment = firstComment.getHiddenAfter();
                while (comment != null) {
                    if (offset < indentLength) {
                        int indentLevel = out.getIndentLevel();
                        out.setIndentLevel(0);
                        out.print(out.getString(offset), 153);
                        out.setIndentLevel(indentLevel);
                    } else {
                        out.print(out.getString(offset - indentLength), 153);
                    }
                    this.printCommentAfter(n, comment, newlineBefore, newlineAfter, false, false, out);
                    comment = comment.getHiddenAfter();
                }
            } else {
                this.printCommentAfter(n, firstComment, newlineBefore, newlineAfter, true, true, out);
            }
        } else {
            boolean endlineComment;
            CommonHiddenStreamToken firstComment = n.getHiddenAfter();
            boolean bl = endlineComment = firstComment.getLine() == n.getEndLine();
            if (!endlineComment) {
                out.printNewline();
                out.printNewline();
            }
            this.printCommentAfter(node, firstComment, false, true, endlineComment, true, out);
            if (out.mode != 1) {
                return false;
            }
            CommonHiddenStreamToken comment = firstComment.getHiddenAfter();
            while (comment != null) {
                this.printCommentAfter(n, comment, newlineBefore, true, false, false, out);
                comment = comment.getHiddenAfter();
            }
        }
        out.last = node.getType();
        return true;
    }

    boolean printCommentsBefore(AST node, NodeWriter out) throws IOException {
        return this.printCommentsBefore(node, true, out);
    }

    boolean printCommentsBefore(AST node, boolean newlineBefore, NodeWriter out) throws IOException {
        if (out.mode == 2) {
            return false;
        }
        JavaNode n = (JavaNode)node;
        if (!n.hasCommentsBefore()) {
            this.printBlankLinesBefore(n, out);
            return false;
        }
        int linesToKeep = settings.getInt(ConventionKeys.BLANK_LINES_KEEP_UP_TO, 1);
        boolean keepLines = linesToKeep > -1;
        CommonHiddenStreamToken previousComment = null;
        CommonHiddenStreamToken token = ((JavaNode)node).getHiddenBefore();
        while (token != null) {
            if (token.getHiddenBefore() == null) {
                CommonHiddenStreamToken comment = token;
                while (comment != null) {
                    switch (comment.getType()) {
                        case 6: 
                        case 52: 
                        case 154: 
                        case 155: 
                        case 157: {
                            if (n.getStartLine() != comment.getLine()) {
                                switch (out.last) {
                                    case 52: {
                                        break;
                                    }
                                }
                                this.printCommentBefore(n, comment, comment == token, newlineBefore, true, out);
                                break;
                            }
                            this.printCommentBefore(n, comment, comment == token, newlineBefore, false, out);
                            out.print(SPACE, out.last);
                            out.column -= comment.getText().length() - 1;
                            break;
                        }
                        default: {
                            throw new RuntimeException("" + comment);
                        }
                    }
                    previousComment = comment;
                    comment = comment.getHiddenAfter();
                }
                return true;
            }
            token = token.getHiddenBefore();
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getBlankLinesBefore(JavaNode node, NodeWriter out) {
        int result = 0;
        if (!this.canHaveBlankLinesBefore(node)) return 0;
        block0 : switch (node.getType()) {
            case 89: {
                break;
            }
            case 32: {
                switch (node.getParent().getType()) {
                    case 11: 
                    case 50: {
                        break block0;
                    }
                    default: {
                        return 0;
                    }
                }
            }
            case 14: {
                switch (node.getParent().getType()) {
                    case 39: {
                        return 0;
                    }
                }
                switch (out.last) {
                    case 14: {
                        break;
                    }
                    case 12: 
                    case 13: 
                    case 15: 
                    case 16: 
                    case 18: 
                    case 19: {
                        result = 1;
                        break;
                    }
                    default: {
                        result = settings.getInt(ConventionKeys.BLANK_LINES_BEFORE_DECLARATION, 1);
                        break;
                    }
                }
                break;
            }
            case 8: {
                if (node.hasCommentsBefore()) break;
                switch (out.last) {
                    case 8: 
                    case 12: 
                    case 13: 
                    case 15: 
                    case 16: 
                    case 18: 
                    case 19: {
                        return settings.getInt(ConventionKeys.BLANK_LINES_BEFORE_BRACE_RIGHT, 0);
                    }
                }
                result = settings.getInt(ConventionKeys.BLANK_LINES_BEFORE_BRACE_RIGHT, 0);
                break;
            }
            case 92: {
                switch (out.last) {
                    case 26: 
                    case 93: {
                        break;
                    }
                    default: {
                        result = settings.getInt(ConventionKeys.BLANK_LINES_BEFORE_BLOCK, 1);
                        break;
                    }
                }
                break;
            }
            case 95: {
                if (node.getParent().getType() == 96) break;
            }
            case 53: 
            case 94: 
            case 96: 
            case 101: 
            case 105: {
                switch (out.last) {
                    case 26: {
                        break;
                    }
                    default: {
                        result = settings.getInt(ConventionKeys.BLANK_LINES_BEFORE_BLOCK, 1);
                        break;
                    }
                }
                break;
            }
            case 103: 
            case 104: {
                result = settings.getInt(ConventionKeys.BLANK_LINES_BEFORE_CASE_BLOCK, 1);
                break;
            }
            case 97: 
            case 99: 
            case 100: {
                result = settings.getInt(ConventionKeys.BLANK_LINES_BEFORE_CONTROL, 1);
                break;
            }
            case 11: {
                if (!JavaNodeHelper.isFreestandingBlock(node)) break;
                result = settings.getInt(ConventionKeys.BLANK_LINES_BEFORE_BLOCK, 1);
                break;
            }
            case 93: 
            case 106: 
            case 107: {
                if (settings.getBoolean(ConventionKeys.BRACE_NEWLINE_RIGHT, false)) break;
                --result;
                break;
            }
            case 20: 
            case 26: 
            case 33: 
            case 34: 
            case 42: 
            case 46: 
            case 47: 
            case 55: 
            case 98: 
            case 102: {
                break;
            }
            case 13: {
                JavaNode prev = node.getPreviousSibling();
                switch (prev.getType()) {
                    case 12: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 18: 
                    case 19: {
                        result = 1;
                        break;
                    }
                    case 13: {
                        result = settings.getInt(ConventionKeys.BLANK_LINES_AFTER_METHOD, 1);
                        break;
                    }
                }
                break;
            }
            case 12: {
                JavaNode prev = node.getPreviousSibling();
                switch (prev.getType()) {
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 18: 
                    case 19: {
                        result = 1;
                        break;
                    }
                    case 12: {
                        result = settings.getInt(ConventionKeys.BLANK_LINES_AFTER_METHOD, 1);
                        break;
                    }
                }
                break;
            }
            case 18: {
                JavaNode prev = node.getPreviousSibling();
                block47 : switch (prev.getType()) {
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: {
                        result = 1;
                        break;
                    }
                    case 19: {
                        if (out.indentLevel > 0) {
                            result = 1;
                            break;
                        }
                        result = 2;
                        break;
                    }
                    case 18: {
                        result = settings.getInt(ConventionKeys.BLANK_LINES_AFTER_CLASS, 1);
                        if (out.indentLevel != 0) break block0;
                        ++result;
                        break;
                    }
                    case 55: {
                        switch (node.getParent().getType()) {
                            case 20: 
                            case 34: 
                            case 49: {
                                break;
                            }
                            default: {
                                break block47;
                            }
                        }
                    }
                    case 34: {
                        result = settings.getInt(ConventionKeys.BLANK_LINES_AFTER_IMPORT, 2);
                        break;
                    }
                }
                break;
            }
            case 19: {
                JavaNode prev = node.getPreviousSibling();
                switch (prev.getType()) {
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: {
                        result = 1;
                        break;
                    }
                    case 18: {
                        if (out.indentLevel > 0) {
                            result = 1;
                            break;
                        }
                        result = 2;
                        break;
                    }
                    case 19: {
                        result = settings.getInt(ConventionKeys.BLANK_LINES_AFTER_INTERFACE, 1);
                        if (out.indentLevel != 0) break block0;
                        ++result;
                        break;
                    }
                    case 34: {
                        result = settings.getInt(ConventionKeys.BLANK_LINES_AFTER_IMPORT, 2);
                        break;
                    }
                }
                break;
            }
            case 15: {
                result = 1;
                break;
            }
            case 16: {
                result = 1;
                break;
            }
            default: {
                return 0;
            }
        }
        block63 : switch (out.last) {
            case 8: 
            case 15: 
            case 16: {
                switch (node.getType()) {
                    case 8: 
                    case 93: 
                    case 103: 
                    case 104: 
                    case 106: 
                    case 107: {
                        break block63;
                    }
                    case 95: {
                        switch (node.getParent().getType()) {
                            case 96: {
                                result = 0;
                            }
                        }
                        break block63;
                    }
                }
                int blankLinesAfterBlock = settings.getInt(ConventionKeys.BLANK_LINES_AFTER_BLOCK, 1);
                if (blankLinesAfterBlock <= result) break;
                result = blankLinesAfterBlock;
                break;
            }
            case 103: 
            case 104: {
                switch (node.getType()) {
                    case 97: 
                    case 100: 
                    case 103: 
                    case 104: {
                        result = 0;
                    }
                }
                break;
            }
            case 14: {
                switch (node.getType()) {
                    case 14: {
                        break block63;
                    }
                    case 8: 
                    case 12: 
                    case 13: 
                    case 15: 
                    case 16: 
                    case 18: 
                    case 19: {
                        break block63;
                    }
                }
                int blankLinesAfterDeclaration = settings.getInt(ConventionKeys.BLANK_LINES_AFTER_DECLARATION, 0);
                if (blankLinesAfterDeclaration <= result) break;
                result = blankLinesAfterDeclaration;
                break;
            }
            case 7: 
            case 92: 
            case 94: 
            case 95: 
            case 96: {
                int blankLinesAfterOpenCurly = settings.getInt(ConventionKeys.BLANK_LINES_AFTER_BRACE_LEFT, 0);
                if (blankLinesAfterOpenCurly <= -1) break;
                result = blankLinesAfterOpenCurly;
                break;
            }
        }
        switch (node.getType()) {
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: {
                return result;
            }
            default: {
                int original = this.getOriginalBlankLines(node);
                if (original <= result) return result;
                return original;
            }
        }
    }

    private int getCommentBlankLines(CommonHiddenStreamToken comment, JavaNode previous, NodeWriter out) {
        switch (out.last) {
            case 48: {
                return 0;
            }
            case 7: {
                int blankLinesAfterOpenCurly = settings.getInt(ConventionKeys.BLANK_LINES_AFTER_BRACE_LEFT, 0);
                if (blankLinesAfterOpenCurly <= -1) break;
                return blankLinesAfterOpenCurly;
            }
        }
        int result = 0;
        block4 : switch (comment.getType()) {
            case 155: {
                switch (out.last) {
                    case 155: {
                        result = 0;
                        break block4;
                    }
                }
                result = settings.getInt(ConventionKeys.BLANK_LINES_BEFORE_COMMENT_SINGLE_LINE, 1);
                break;
            }
            case 154: {
                result = settings.getInt(ConventionKeys.BLANK_LINES_BEFORE_COMMENT_SINGLE_LINE, 1);
                break;
            }
            case 157: {
                switch (out.last) {
                    case 157: {
                        result = 0;
                        break block4;
                    }
                }
                result = settings.getInt(ConventionKeys.BLANK_LINES_BEFORE_COMMENT_MULTI_LINE, 1);
                break;
            }
            case 6: {
                switch (out.last) {
                    case 6: {
                        result = 0;
                        break block4;
                    }
                }
                result = settings.getInt(ConventionKeys.BLANK_LINES_BEFORE_COMMENT_JAVADOC, 1);
                break;
            }
            case 52: {
                switch (out.last) {
                    case 8: {
                        result = 2;
                        break block4;
                    }
                }
                result = 1;
            }
        }
        switch (out.last) {
            case 20: {
                int linesAfterPackage = settings.getInt(ConventionKeys.BLANK_LINES_AFTER_PACKAGE, 1);
                if (result > linesAfterPackage) {
                    result -= linesAfterPackage;
                    break;
                }
                result = 0;
            }
        }
        int keepLinesUpTo = settings.getInt(ConventionKeys.BLANK_LINES_KEEP_UP_TO, 1);
        int l = comment.getLine() - previous.getEndLine() - 1;
        if (l > keepLinesUpTo) {
            return keepLinesUpTo;
        }
        return Math.max(result, l);
    }

    private boolean isLocalVariable(JavaNode node) {
        switch (node.getParent().getType()) {
            case 10: {
                return false;
            }
        }
        return true;
    }

    private boolean canHaveBlankLinesBefore(JavaNode node) {
        JavaNode parent = node.getParent();
        switch (parent.getType()) {
            case 7: 
            case 10: 
            case 11: 
            case 49: {
                return true;
            }
            case 9: {
                return parent.getFirstChild() == node;
            }
            case 18: 
            case 19: 
            case 20: 
            case 31: 
            case 32: 
            case 34: {
                return false;
            }
        }
        return this.canHaveBlankLinesBefore(parent);
    }

    private void printBlankLinesBefore(JavaNode node, CommonHiddenStreamToken comment, boolean first, NodeWriter out) throws IOException {
        int blankLines = 0;
        int blankLinesForComment = 0;
        block0 : switch (comment.getType()) {
            case 155: {
                switch (out.last) {
                    case 48: 
                    case 155: {
                        break block0;
                    }
                    case 6: 
                    case 8: 
                    case 14: 
                    case 18: 
                    case 19: 
                    case 52: 
                    case 154: 
                    case 157: {
                        if (first) {
                            blankLines = this.getBlankLinesBefore(node, out);
                        }
                        blankLinesForComment = 1;
                        break block0;
                    }
                }
                if (first) {
                    blankLines = this.getBlankLinesBefore(node, out);
                }
                blankLinesForComment = this.getCommentBlankLines(comment, node.getPreviousSibling(), out);
                break;
            }
            case 6: {
                switch (out.last) {
                    case 6: 
                    case 48: {
                        break block0;
                    }
                    case 8: 
                    case 14: 
                    case 18: 
                    case 19: 
                    case 52: 
                    case 154: 
                    case 155: 
                    case 157: {
                        if (first) {
                            blankLines = this.getBlankLinesBefore(node, out);
                        }
                        blankLinesForComment = this.getCommentBlankLines(comment, node.getPreviousSibling(), out);
                        break block0;
                    }
                }
                if (first) {
                    blankLines = this.getBlankLinesBefore(node, out);
                }
                blankLinesForComment = this.getCommentBlankLines(comment, node.getPreviousSibling(), out);
                break;
            }
            case 157: {
                switch (out.last) {
                    case 48: 
                    case 157: {
                        break block0;
                    }
                    case 6: 
                    case 52: 
                    case 154: 
                    case 155: {
                        if (first) {
                            blankLines = this.getBlankLinesBefore(node, out);
                        }
                        blankLinesForComment = 1;
                        break block0;
                    }
                }
                if (first) {
                    blankLines = this.getBlankLinesBefore(node, out);
                }
                blankLinesForComment = this.getCommentBlankLines(comment, node.getPreviousSibling(), out);
                break;
            }
            case 52: {
                switch (out.last) {
                    case 6: 
                    case 52: 
                    case 154: 
                    case 155: 
                    case 157: {
                        if (first) {
                            blankLines = this.getBlankLinesBefore(node, out);
                        }
                        blankLinesForComment = 1;
                        break block0;
                    }
                    case 48: {
                        break block0;
                    }
                }
                if (first) {
                    blankLines = this.getBlankLinesBefore(node, out);
                }
                blankLinesForComment = this.getCommentBlankLines(comment, node.getPreviousSibling(), out);
                break;
            }
            case 154: {
                switch (out.last) {
                    case 6: 
                    case 52: 
                    case 154: 
                    case 155: 
                    case 157: {
                        if (first) {
                            blankLines = this.getBlankLinesBefore(node, out);
                        }
                        blankLinesForComment = 1;
                        break block0;
                    }
                    case 48: {
                        break block0;
                    }
                }
                if (first) {
                    blankLines = this.getBlankLinesBefore(node, out);
                }
                blankLinesForComment = this.getCommentBlankLines(comment, node.getPreviousSibling(), out);
            }
        }
        if (this.canHaveBlankLinesBefore(node)) {
            out.printBlankLines(Math.max(blankLines, blankLinesForComment));
        } else if (out.expression != null) {
            if (this.isChildOf(out.expression, node)) {
                out.printBlankLines(blankLinesForComment - out.blankLines);
            }
        } else {
            out.printBlankLines(Math.max(blankLines, blankLinesForComment));
        }
    }

    private void printBlankLinesBetweenComments(CommonHiddenStreamToken comment, CommonHiddenStreamToken previousComment, int keepLines, NodeWriter out) throws IOException {
        int lines = 0;
        switch (previousComment.getType()) {
            case 154: {
                break;
            }
            default: {
                lines = comment.getLine() - previousComment.getLine() - 1;
            }
        }
        if (lines > keepLines) {
            out.printBlankLines(keepLines);
        } else if (lines > 0) {
            out.printBlankLines(lines);
        }
    }

    private void printCommentAfter(AST node, CommonHiddenStreamToken comment, boolean newlineBefore, boolean newlineAfter, boolean whitespaceBefore, boolean first, NodeWriter out) throws IOException {
        int last = out.last;
        boolean restore = false;
        int indent = 0;
        if (comment.getColumn() == 1 && !settings.getBoolean(ConventionKeys.INDENT_FIRST_COLUMN_COMMENT, true)) {
            restore = true;
            indent = out.getIndentLevel();
            out.setIndentLevel(0);
        }
        if (whitespaceBefore) {
            out.print(out.getString(settings.getInt(ConventionKeys.INDENT_SIZE_COMMENT_ENDLINE, 1)), 153);
        }
        switch (comment.getType()) {
            case 6: {
                throw new IllegalArgumentException("no valid endline comment -- " + comment + "(attached to " + node + RPAREN);
            }
            case 155: {
                out.print(comment.getText(), comment.getType());
                break;
            }
            case 157: {
                this.printMultiLineComment(comment, 157, out);
                break;
            }
            case 154: {
                this.printSpecialComment(comment, out);
                break;
            }
            case 52: {
                out.print(comment.getText(), comment.getType());
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid type -- " + comment);
            }
        }
        if (restore) {
            out.setIndentLevel(indent);
        }
        if (newlineAfter || this.shouldForceNewline(node, comment)) {
            out.printNewline();
        }
        out.last = last;
    }

    private void printCommentBefore(JavaNode node, CommonHiddenStreamToken comment, boolean first, boolean newlineBefore, boolean newlineAfter, NodeWriter out) throws IOException {
        this.printBlankLinesBefore(node, comment, first, out);
        boolean retain = false;
        int indent = 0;
        if (comment.getType() == 154 || comment.getColumn() == 1 && !settings.getBoolean(ConventionKeys.INDENT_FIRST_COLUMN_COMMENT, true)) {
            indent = out.getIndentLevel();
            out.setIndentLevel(0);
            retain = true;
        }
        int type = comment.getType();
        switch (type) {
            case 155: {
                out.print(comment.getText(), type);
                break;
            }
            case 6: {
                ExtendedToken t = (ExtendedToken)comment;
                Node c = t.getComment();
                if (c != null) {
                    ((JavadocPrinter)PrinterFactory.create(c)).print(node, c, out);
                    break;
                }
                this.printMultiLineComment(comment, 6, out);
                break;
            }
            case 157: {
                this.printMultiLineComment(comment, 157, out);
                break;
            }
            case 154: {
                this.printSpecialComment(comment, out);
                break;
            }
            case 52: {
                out.print(comment.getText(), comment.getType());
                if (comment.getHiddenAfter() != null) break;
                out.printNewline();
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid type -- " + comment);
            }
        }
        if (retain) {
            out.setIndentLevel(indent);
        }
        if (newlineAfter) {
            out.printNewline();
        }
    }

    private void printMultiLineComment(CommonHiddenStreamToken comment, int type, NodeWriter out) throws IOException {
        String[] lines = null;
        boolean format = settings.getBoolean(ConventionKeys.COMMENT_FORMAT_MULTI_LINE, false);
        lines = format ? StringHelper.wrapStringToArray(comment.getText(), Integer.MAX_VALUE, out.lineSeparator, false, 4) : StringHelper.split(comment.getText(), out.originalLineSeparator);
        int lastLine = lines.length - 1;
        int i = 0;
        while (i < lines.length) {
            if (lines[i].length() > 0) {
                out.print(StringHelper.trimTrailing(lines[i]), type);
            }
            if (i < lastLine) {
                out.printNewline();
            }
            ++i;
        }
    }

    private void printSpecialComment(CommonHiddenStreamToken comment, NodeWriter out) throws IOException {
        String[] lines = StringHelper.split(comment.getText(), out.originalLineSeparator);
        int lastLine = lines.length - 1;
        int i = 0;
        while (i < lines.length) {
            if (lines[i].length() > 0) {
                out.print(StringHelper.trimTrailing(lines[i]), 154);
            }
            if (i < lastLine) {
                out.printNewline();
            }
            ++i;
        }
    }

    private boolean shouldForceNewline(AST node, CommonHiddenStreamToken comment) {
        switch (comment.getType()) {
            case 52: 
            case 154: 
            case 155: {
                if (settings.getBoolean(ConventionKeys.BRACE_NEWLINE_LEFT, false)) {
                    return !JavaNodeHelper.isBlockNext(node);
                }
                return true;
            }
        }
        return false;
    }
}

