/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.wrapper;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Formatter;
import java.util.Properties;
import org.gradle.wrapper.BootstrapMainStarter;
import org.gradle.wrapper.Install;
import org.gradle.wrapper.WrapperConfiguration;

public class WrapperExecutor {
    public static final String DISTRIBUTION_URL_PROPERTY = "distributionUrl";
    public static final String DISTRIBUTION_BASE_PROPERTY = "distributionBase";
    public static final String ZIP_STORE_BASE_PROPERTY = "zipStoreBase";
    public static final String DISTRIBUTION_PATH_PROPERTY = "distributionPath";
    public static final String ZIP_STORE_PATH_PROPERTY = "zipStorePath";
    private final Properties properties;
    private final File propertiesFile;
    private final Appendable warningOutput;
    private final WrapperConfiguration config = new WrapperConfiguration();

    public static WrapperExecutor forProjectDirectory(File file, Appendable appendable) {
        return new WrapperExecutor(new File(file, "gradle/wrapper/gradle-wrapper.properties"), new Properties(), appendable);
    }

    public static WrapperExecutor forWrapperPropertiesFile(File file, Appendable appendable) {
        if (!file.exists()) {
            throw new RuntimeException(String.format("Wrapper properties file '%s' does not exist.", file));
        }
        return new WrapperExecutor(file, new Properties(), appendable);
    }

    WrapperExecutor(File file, Properties properties, Appendable appendable) {
        this.properties = properties;
        this.propertiesFile = file;
        this.warningOutput = appendable;
        if (file.exists()) {
            try {
                WrapperExecutor.loadProperties(file, properties);
                this.config.setDistribution(this.prepareDistributionUri());
                this.config.setDistributionBase(this.getProperty(DISTRIBUTION_BASE_PROPERTY, this.config.getDistributionBase()));
                this.config.setDistributionPath(this.getProperty(DISTRIBUTION_PATH_PROPERTY, this.config.getDistributionPath()));
                this.config.setZipBase(this.getProperty(ZIP_STORE_BASE_PROPERTY, this.config.getZipBase()));
                this.config.setZipPath(this.getProperty(ZIP_STORE_PATH_PROPERTY, this.config.getZipPath()));
            }
            catch (Exception exception) {
                throw new RuntimeException(String.format("Could not load wrapper properties from '%s'.", file), exception);
            }
        }
    }

    private URI prepareDistributionUri() throws URISyntaxException {
        URI uRI = this.readDistroUrl();
        if (uRI.getScheme() == null) {
            return new File(this.propertiesFile.getParentFile(), uRI.getSchemeSpecificPart()).toURI();
        }
        return uRI;
    }

    private URI readDistroUrl() throws URISyntaxException {
        if (this.properties.getProperty(DISTRIBUTION_URL_PROPERTY) != null) {
            return new URI(this.getProperty(DISTRIBUTION_URL_PROPERTY));
        }
        return this.readDistroUrlDeprecatedWay();
    }

    private URI readDistroUrlDeprecatedWay() throws URISyntaxException {
        String string = null;
        try {
            string = this.getProperty("urlRoot") + "/" + this.getProperty("distributionName") + "-" + this.getProperty("distributionVersion") + "-" + this.getProperty("distributionClassifier") + ".zip";
            Formatter formatter = new Formatter();
            formatter.format("Wrapper properties file '%s' contains deprecated entries 'urlRoot', 'distributionName', 'distributionVersion' and 'distributionClassifier'. These will be removed soon. Please use '%s' instead.%n", this.propertiesFile, DISTRIBUTION_URL_PROPERTY);
            this.warningOutput.append(formatter.toString());
        }
        catch (Exception exception) {
            this.reportMissingProperty(DISTRIBUTION_URL_PROPERTY);
        }
        return new URI(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadProperties(File file, Properties properties) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            properties.load(fileInputStream);
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
    }

    public URI getDistribution() {
        return this.config.getDistribution();
    }

    public WrapperConfiguration getConfiguration() {
        return this.config;
    }

    public void execute(String[] stringArray, Install install, BootstrapMainStarter bootstrapMainStarter) throws Exception {
        File file = install.createDist(this.config);
        bootstrapMainStarter.start(stringArray, file);
    }

    private String getProperty(String string) {
        return this.getProperty(string, null);
    }

    private String getProperty(String string, String string2) {
        String string3 = this.properties.getProperty(string);
        if (string3 != null) {
            return string3;
        }
        if (string2 != null) {
            return string2;
        }
        return this.reportMissingProperty(string);
    }

    private String reportMissingProperty(String string) {
        throw new RuntimeException(String.format("No value with key '%s' specified in wrapper properties file '%s'.", string, this.propertiesFile));
    }
}

