/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cli;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.cli.CommandLineOption;
import org.gradle.cli.ParsedCommandLineOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParsedCommandLine {
    private final Map<String, ParsedCommandLineOption> optionsByString = new HashMap<String, ParsedCommandLineOption>();
    private final Set<String> presentOptions = new HashSet<String>();
    private final List<String> extraArguments = new ArrayList<String>();

    ParsedCommandLine(Iterable<CommandLineOption> iterable) {
        for (CommandLineOption commandLineOption : iterable) {
            ParsedCommandLineOption parsedCommandLineOption = new ParsedCommandLineOption();
            for (String string : commandLineOption.getOptions()) {
                this.optionsByString.put(string, parsedCommandLineOption);
            }
        }
    }

    public String toString() {
        return String.format("options: %s, extraArguments: %s", this.quoteAndJoin(this.presentOptions), this.quoteAndJoin(this.extraArguments));
    }

    private String quoteAndJoin(Iterable<String> iterable) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (String string : iterable) {
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("'");
            stringBuilder.append(string);
            stringBuilder.append("'");
            bl = false;
        }
        return stringBuilder.toString();
    }

    public boolean hasOption(String string) {
        this.option(string);
        return this.presentOptions.contains(string);
    }

    public boolean hasAnyOption(Collection<String> collection) {
        for (String string : collection) {
            if (!this.hasOption(string)) continue;
            return true;
        }
        return false;
    }

    public ParsedCommandLineOption option(String string) {
        ParsedCommandLineOption parsedCommandLineOption = this.optionsByString.get(string);
        if (parsedCommandLineOption == null) {
            throw new IllegalArgumentException(String.format("Option '%s' not defined.", string));
        }
        return parsedCommandLineOption;
    }

    public List<String> getExtraArguments() {
        return this.extraArguments;
    }

    void addExtraValue(String string) {
        this.extraArguments.add(string);
    }

    ParsedCommandLineOption addOption(String string, CommandLineOption commandLineOption) {
        ParsedCommandLineOption parsedCommandLineOption = this.optionsByString.get(string);
        this.presentOptions.addAll(commandLineOption.getOptions());
        return parsedCommandLineOption;
    }
}

