/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cli;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineOption {
    private final Set<String> options = new HashSet<String>();
    private Class<?> argumentType = Void.TYPE;
    private String description;
    private String subcommand;
    private String deprecationWarning;
    private boolean experimental;

    public CommandLineOption(Iterable<String> iterable) {
        for (String string : iterable) {
            this.options.add(string);
        }
    }

    public Set<String> getOptions() {
        return this.options;
    }

    public CommandLineOption hasArgument() {
        this.argumentType = String.class;
        return this;
    }

    public CommandLineOption hasArguments() {
        this.argumentType = List.class;
        return this;
    }

    public String getSubcommand() {
        return this.subcommand;
    }

    public CommandLineOption mapsToSubcommand(String string) {
        this.subcommand = string;
        return this;
    }

    public String getDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.description != null) {
            stringBuilder.append(this.description);
        }
        if (this.deprecationWarning != null) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append("[deprecated - ");
            stringBuilder.append(this.deprecationWarning);
            stringBuilder.append("]");
        }
        if (this.experimental) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append("[experimental]");
        }
        return stringBuilder.toString();
    }

    public CommandLineOption hasDescription(String string) {
        this.description = string;
        return this;
    }

    public boolean getAllowsArguments() {
        return this.argumentType != Void.TYPE;
    }

    public boolean getAllowsMultipleArguments() {
        return this.argumentType == List.class;
    }

    public CommandLineOption deprecated(String string) {
        this.deprecationWarning = string;
        return this;
    }

    public CommandLineOption experimental() {
        this.experimental = true;
        return this;
    }

    public String getDeprecationWarning() {
        return this.deprecationWarning;
    }
}

