// -*- C++ -*-
// --------------------------------------------------------------------
// The PDF resources created by Pdflatex/Xelatex
// --------------------------------------------------------------------
/*

    This file is part of the extensible drawing editor Ipe.
    Copyright (C) 1993-2016  Otfried Cheong

    Ipe is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    As a special exception, you have permission to link Ipe with the
    CGAL library and distribute executables, as long as you follow the
    requirements of the Gnu General Public License in regard to all of
    the software in the executable aside from CGAL.

    Ipe is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
    License for more details.

    You should have received a copy of the GNU General Public License
    along with Ipe; if not, you can find it at
    "http://www.gnu.org/copyleft/gpl.html", or write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef IPERESOURCES_H
#define IPERESOURCES_H

#include "ipebase.h"
#include "ipegeo.h"
#include "ipepdfparser.h"

// --------------------------------------------------------------------

namespace ipe {

  class PdfResources {
  public:
    bool collect(const PdfDict *dict, PdfFile *file);
    const PdfObj *object(int num) const noexcept;
    const PdfDict *get(String key) const noexcept;
    const PdfDict *getFont(int id) const noexcept;
    inline const std::vector<int> &embedSequence() const noexcept {
      return iEmbedSequence; }
  private:
    void add(int num, PdfFile *file);
    void addIndirect(const PdfObj *q, PdfFile *file);
  private:
    struct Item {
      String iKey;
      PdfDict *iDict;
    };
    std::vector<Item> iItems;
    std::unordered_map<int, std::unique_ptr<const PdfObj>> iObjects;
    std::vector<int> iEmbedSequence;
    //! Maps /F<n> to object number
    std::map<int, int> iFontObjects;
  };

} // namespace

// --------------------------------------------------------------------
#endif
