# -*- makefile -*-
# --------------------------------------------------------------------
#
# Building Ipe --- common definitions
#
# --------------------------------------------------------------------
# Are we compiling for Windows?  For Mac OS X?
ifdef COMSPEC
  WIN32	=  1   
  IPEUI = WIN32
else ifdef IPECROSS
  # http://mingw-w64.sourceforge.net/
  WIN32 = 1
  IPEUI = WIN32
else
  UNAME = $(shell uname)
  ifeq "$(UNAME)" "Darwin"
    MACOS = 1
    IPEUI = QT
  endif
endif
# --------------------------------------------------------------------
# IPESRCDIR is Ipe's top "src" directory
# if 'common.mak' is included on a different level than a subdirectory
# of "src", then IPESRCDIR must be set before including 'common.mak'.

IPESRCDIR ?= ..

# User interface library
# Possible values are QT, WIN32, GTK,
# but GTK is unfinished and WIN32 only works on Windows

IPEUI ?= QT

# --------------------------------------------------------------------
# Read configuration options (not used on Win32)

ifndef WIN32
  include $(IPESRCDIR)/config.mak
  BUILDDIR = $(IPESRCDIR)/../build
endif

# --------------------------------------------------------------------

# set variables for UI choice
ifeq ($(IPEUI),QT)
CPPFLAGS += -DIPEUI_QT
IPEUI_QT := 1
UI_CFLAGS = $(QT_CFLAGS)
UI_LIBS = $(QT_LIBS)
moc_sources = $(addprefix moc_, $(subst .h,.cpp,$(moc_headers)))
all_sources = $(sources) $(qt_sources)
objects = $(addprefix $(OBJDIR)/, $(subst .cpp,.o,$(all_sources) \
	$(moc_sources)))
else
ifeq ($(IPEUI), WIN32)
CPPFLAGS += -DIPEUI_WIN32
IPEUI_WIN32 := 1
UI_CFLAGS := 
UI_LIBS := -lcomctl32 -lcomdlg32 -lgdi32
all_sources = $(sources) $(win_sources)
objects = $(addprefix $(OBJDIR)/, $(subst .cpp,.o,$(all_sources)))
else
ifeq ($(IPEUI), GTK)
CPPFLAGS += -DIPEUI_GTK
IPEUI_GTK := 1
UI_CFLAGS = $(GTK_CFLAGS)
UI_LIBS = $(GTK_LIBS)
all_sources = $(sources) $(gtk_sources)
BUILDDIR = $(IPESRCDIR)/../gtkbuild
objects = $(addprefix $(OBJDIR)/, $(subst .cpp,.o,$(all_sources)))
else
error("Unknown IPEUI selected")
endif
endif
endif

CXXFLAGS += -Wall

ifdef IPESTRICT
  CXXFLAGS += -Werror
endif

DEPEND ?= $(OBJDIR)/depend.mak

.PHONY: clean 
.PHONY: install
.PHONY: all

ifdef WIN32
  # iconv is not needed under windows
  IPE_USE_ICONV :=
  # Set just in case user has environment variables set
  IPEDOCDIR	:=
  IPEICONDIR	:=

  CPPFLAGS	+= -DWIN32 -DUNICODE -D_UNICODE
  DLL_LDFLAGS	+= -shared 
  DL_LIBS	:= 
  buildlib	= $(BUILDDIR)/bin
  exe_target	= $(BUILDDIR)/bin/$1.exe
  dll_target    = $(buildlib)/$1.dll
  soname        = 
  dll_symlinks  = 
  install_symlinks = 
  ipelet_target = $(BUILDDIR)/ipelets/$1.dll

  BUILDDIR = $(IPESRCDIR)/../mingw
  CXXFLAGS	+= -g -O2 -fno-rtti -fno-exceptions
ifdef IPECROSS
  # --------------- Cross compiling with Mingw-w64 ---------------
  CXX = i686-w64-mingw32-g++
  CC = i686-w64-mingw32-gcc
  STRIP_TARGET  = i686-w64-mingw32-strip $(TARGET)
  WINDRES	= i686-w64-mingw32-windres
  IPEDEPS	?= /sw/mingwlibs
else
  # --------------- Compiling with Mingw-w64 under Windows ---------------
  WINDRES	= windres.exe
  CXXFLAGS	+= -g -O2
  STRIP_TARGET  = strip $(TARGET)
  IPEDEPS	?= /mingwlibs
endif

  ZLIB_CFLAGS   := -I$(IPEDEPS)/include
  ZLIB_LIBS     := -L$(IPEDEPS)/lib -lz
  JPEG_CFLAGS   := -I$(IPEDEPS)/include/jpeg-turbo
  JPEG_LIBS     := -L$(IPEDEPS)/lib -lturbojpeg
  PNG_CFLAGS	:= -I$(IPEDEPS)/include/libpng15
  PNG_LIBS	:= -L$(IPEDEPS)/lib -lpng15
  FREETYPE_CFLAGS := -I$(IPEDEPS)/include/freetype2 \
       -I$(IPEDEPS)/include
  FREETYPE_LIBS := -L$(IPEDEPS)/lib -lfreetype
  CAIRO_CFLAGS  := -I$(IPEDEPS)/include/cairo
  CAIRO_LIBS    := -L$(IPEDEPS)/lib -lcairo
  LUA_CFLAGS    := -I$(IPEDEPS)/lua52/include
  LUA_LIBS      := $(IPEDEPS)/lua52/lua52.dll

else
  # -------------------- Unix --------------------
  CXXFLAGS	+= -g -O2
  ifdef MACOS
    DLL_LDFLAGS	+= -dynamiclib 
    # IPELIBDIRINFO can be overridden as @executable_path/../lib
    # on the command line or by an environment variable
    IPELIBDIRINFO ?= $(IPELIBDIR)
    soname      = -Wl,-dylib_install_name,$(IPELIBDIRINFO)/lib$1.$(IPEVERS).dylib
    dll_target    = $(buildlib)/lib$1.$(IPEVERS).dylib
    dll_symlinks  = ln -sf lib$1.$(IPEVERS).dylib $(buildlib)/lib$1.dylib
    install_symlinks = ln -sf lib$1.$(IPEVERS).dylib \
		$(INSTALL_ROOT)$(IPELIBDIR)/lib$1.dylib
    ipelet_target = $(BUILDDIR)/ipelets/$1.dylib
  else	
    DLL_LDFLAGS	+= -shared 
    soname      = -Wl,-soname,lib$1.so.$(IPEVERS)
    dll_target    = $(buildlib)/lib$1.so.$(IPEVERS)
    dll_symlinks  = ln -sf lib$1.so.$(IPEVERS) $(buildlib)/lib$1.so
    install_symlinks = ln -sf lib$1.so.$(IPEVERS) \
			$(INSTALL_ROOT)$(IPELIBDIR)/lib$1.so
    ipelet_target = $(BUILDDIR)/ipelets/$1.so
  endif
  buildlib	= $(BUILDDIR)/lib
  exe_target	= $(BUILDDIR)/bin/$1
endif

# Macros

INSTALL_DIR = install -d
INSTALL_FILES = install -m 0644
INSTALL_SCRIPTS = install -m 0755
ifdef MACOS
# stripping is faulty on Mac?
INSTALL_PROGRAMS = install -m 0755
else
INSTALL_PROGRAMS = install -s -m 0755
endif

MAKE_BINDIR = mkdir -p $(BUILDDIR)/bin

MAKE_LIBDIR = mkdir -p $(buildlib)

MAKE_IPELETDIR = mkdir -p $(BUILDDIR)/ipelets

MAKE_DEPEND = \
	mkdir -p $(OBJDIR); \
	echo "" > $@; \
	for f in $(all_sources); do \
	$(CXX) -MM -MT $(OBJDIR)/$${f%%.cpp}.o $(CPPFLAGS) $$f >> $@; done

# The rules

$(OBJDIR)/%.o:  %.cpp
	@echo Compiling $(<F)...
	$(COMPILE.cc) -o $@ $<

ifdef IPEUI_QT
moc_%.cpp:  %.h
	@echo Running moc on $(<F)...
	$(MOC) $(CPPFLAGS )-o $@ $<
endif

# --------------------------------------------------------------------
