/*
Copyright (c) 2002 Regents of The University of Michigan.
All Rights Reserved.

Permission to use, copy, modify, and distribute this software and
its documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appears in all copies and
that both that copyright notice and this permission notice appear
in supporting documentation, and that the name of The University
of Michigan not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior
permission. This software is supplied as is without expressed or
implied warranties of any kind.

Research Systems Unix Group
The University of Michigan
c/o Wesley Craig
4251 Plymouth Road B1F2, #2600
Ann Arbor, MI 48105-2785

http://rsug.itd.umich.edu/software/ihook
ihook@umich.edu
*/

#import <Cocoa/Cocoa.h>
#import "LHWindow.h"

#define HOOK_DEFAULT_PATH		@"/etc/logout.hook"

@interface LHController : NSObject
{
    IBOutlet NSImageView 		*mainImage;
    IBOutlet NSView 			*mainView;
    IBOutlet NSDrawer 			*stderrDrawer;
    IBOutlet NSView 			*stderrDrawerView;
    IBOutlet NSTextView 		*stderrTextView;
    IBOutlet NSTextField 		*stdoutField;
    IBOutlet NSProgressIndicator	*progBar;
    IBOutlet NSTextField		*progMessageField;
    IBOutlet NSView			*progBarView;
    IBOutlet NSTextField		*eTimeField;
    
    IBOutlet NSButton			*defaultButton;
    IBOutlet NSButton			*cancelButton;
    
    /* input */
    IBOutlet NSBox			*inputBox;
    IBOutlet NSButton			*inputButton;
    IBOutlet NSTextField		*inputField;
    IBOutlet NSTextField		*inputTitle;
    
    IBOutlet NSTextField		*titleField;
    IBOutlet NSBox			*superBox;
    
    LHWindow				*mainWindow;
    
@private
    BOOL				ihookInputEnabled;
    BOOL				ihookDebug;
    BOOL				ihookShowTimer;
    BOOL				ihookHadDirective;
    NSMutableArray			*ihookInputQueue;
    NSNumber				*ihookExitStatus;
    NSNumber				*ihookIsExecuting;
    NSOperationQueue			*ihookOperationQueue;
    NSString				*ihookConsoleUser;
    NSString				*ihookScriptPath;
    NSTimer				*ihookTimer;
    NSUInteger				ihookElapsedTime;
    int                                 logfd;
}

- ( void )error: ( NSString * )error;
- ( oneway void )setStdoutMessage: ( NSString * )msg;
- ( oneway void )addToStderrField: ( NSString * )msg;

- ( void )setConsoleUser;

- ( IBAction )errorQuit: ( id )sender;
- ( void )normalQuit: ( id )context;

- ( IBAction )toggleDrawer: ( id )sender;

- ( void )start;

- ( int )logFileDescriptor;
- ( void )setLogFileDescriptor: ( int )fd;
- ( void )logFileAppendText: ( NSString * )text;

- ( void )setInputEnabled: ( BOOL )enabled;
- ( BOOL )inputEnabled;
- ( void )inputQueueAddInput: ( NSString * )input;
- ( IBAction )writeToStdin: ( id )sender;

@property(readonly)	NSString	*consoleUser;
@property(copy)		NSString	*scriptPath;
@property(retain)	NSNumber	*isExecuting;
@property(retain)	NSNumber	*exitStatus;
@property		BOOL		inputEnabled;
@property		BOOL		showTimer;
@property		BOOL		debug;
@property		int		logFileDescriptor;
@property(readonly)	NSOperationQueue *operationQueue;

@end
