module Arg where

import HsShellScript
import Monad
import System

run_ee :: Bool            -- ob wirklich ausfhren (not --unecht)
       -> Bool            -- ob Kommando anzeigen (--echo)
       -> String          -- Programm
       -> [String]        -- Kommandozeilenparameter
       -> IO ()
run_ee echt echo prog args = do
    when echo $ putStrLn (shell_command prog args)
    when echt $ run prog args


system_ee :: Bool               -- ob wirklich ausfhren (not --unecht)
          -> Bool               -- ob Kommando anzeigen (--echo)
          -> String             -- Shellkommando
          -> IO ExitCode
system_ee echt echo cmd = do
    when echo $ putStrLn cmd
    if echt then system cmd
            else return ExitSuccess


-- Parser fr Grenangabe (z.B. d_groesse)
parse_gr :: String -> Integer
parse_gr txt =
    case (reads txt) of
        [(b, "")]   -> b
        [(kb, "k")] -> kb*1024
        [(mb, "M")] -> mb*1024*1024
        _           -> error ("Ungltige Grenangabe " ++ quote txt)



d_geraet = argdesc [ desc_at_most_once
                   , desc_value_required
                   , desc_argname "Gert"
                   , desc_short 'g'
                   , desc_long "geraet"
                   , desc_description "Gert. von dem gelesen wird: Mountpunkt relativ zu /mnt"
                   ]

d_name = argdesc [ desc_at_most_once
                 , desc_value_required
                 , desc_argname "CD-Name"
                 , desc_short 'n'
                 , desc_long "name"
                 , desc_description "Name der CD (falls nicht automatisch bestimmbar)"
                 ]

d_unecht   = argdesc [ desc_at_most_once
                     , desc_long "unecht"
                     , desc_description "Kommandos nicht ausfhren (zusammen mit --echo verwenden)"
                     ]

d_echo     = argdesc [ desc_at_most_once
                     , desc_long "echo"
                     , desc_description "Kommandos ausgeben"
                     ]

d_iso      = argdesc [ desc_at_most_once
                     , desc_short 'i'
                     , desc_long "iso"
                     , desc_description "nur ISO-Bild erstellen (nicht brennen)" 
                     ]

d_loop     = argdesc [ desc_at_most_once
                     , desc_short 'l'
                     , desc_long "loop"
                     , desc_description "nur ISO-Bild erstellen (nicht brennen) und dieses mounten" 
                     ]

d_blank    = argdesc [ desc_at_most_once
                     , desc_short 'b'
                     , desc_long "blank"
                     , desc_description "CD-RW vorher lschen" 
                     ]

d_speed    = argdesc [ desc_at_most_once
                     , desc_short 's'
                     , desc_long "speed"
                     , desc_argname "Geschw"
                     , desc_value_required
                     , desc_description "Brenngeschwindigkeit (normal 8)" 
                     ]

d_dirs     = argdesc [ desc_direct
                     , desc_at_least_once
                     , desc_description "Verzeichnisse, die gebrannt werden sollen; eins je CD" 
                     ]

d_labels   = argdesc [ desc_any_times
                     , desc_short 'L'
                     , desc_long "label"
                     , desc_argname "Label"
                     , desc_description "Labels (anstatt Verzeichnisnamen)"
                     , desc_value_required 
                     ]

d_overburn = argdesc [ desc_at_most_once
                     , desc_short 'o'
                     , desc_long "overburn"
                     , desc_description "berbrennen" 
                     ]

d_groesse = argdesc [ desc_at_most_once
                    , desc_value_required
                    , desc_short 'g'
                    , desc_long "gre"
                    , desc_argname "Gre"
                    , desc_description "Gre der CD; Suffixe 'k' und 'M'; normal 700M"
                    ]

d_neu           = argdesc [ desc_at_most_once
                          , desc_short 'n'
                          , desc_long "neu"
                          , desc_description "neue Serie oder neues Ziel"
                          ]
