/*
 * Hrsh2csv is a command line utility for converting PDB desktop files created by
 * the Hours (http://hours.sourceforge.net) Palm application on a handheld into
 * files in the CSV (comma separated value) format.
 * 
 * Copyright (C) 2002 Peter Novotnik
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


/*********************************************************************
 * file         pdblib.h
 *
 * library for palm database
 *
 * authors      donpedro <peternov1@gmx.de>
 *              Eric Santonacci <Eric.Santonacci@talc.fr>
 *
 * $Id: pdblib.h,v 1.2 2003/04/29 21:17:01 geppetto Exp $
 *
 *********************************************************************/

/*
 * NOTE THAT THIS FILE HAS BEEN MODIFIED AND IS NOT EQUAL TO THE
 * ONE FROM THE PDBLIB.
 * 20.jan.02 - pete
 */

#ifndef __PDBLIB_H__
#define __PDBLIB_H__

#include <stdio.h>    // because of FILE *

/********** Palm OS constants **********/
#define dmRecAttrCategoryMask	   0x0F	      // mask for category #
#define dmRecNumCategories       16          // number of categories
#define dmCategoryLength         16          // 15 chars + 1 null terminator
#define dmDBNameLength           32          // 31 chars + 1 null terminator

#define		dmRecAttrDelete			0x80	// delete this record next sync
#define		dmRecAttrDirty			0x40	// archive this record next sync
#define		dmRecAttrBusy				0x20	// record currently in use
#define		dmRecAttrSecret			0x10	// "secret" record - password protected



#ifdef __MAC2PC_CONVERSION__

/* WARNING: Intel specific! */
/* convert Motorola shorts and ints to Intel shorts and ints */
#define MAC2PC_SHORT(s) ((((s) & 0x00FF) << 8) | ((s) >> 8))
#define MAC2PC_INT(i) ((((i) & 0x000000FF) << 24) | (((i) & 0x0000FF00) << 8) | (((i) & 0x00FF0000) >> 8) | ((i) >> 24))

#endif //__MAC2PC_CONVERSION__

/**
 * generic Palm Database structure
 * see file format specification at
 * http://www.palmos.com
*/
struct _PDBHeaderType {
  char          name[32];        // name[31 + 1];
  unsigned short attributes;
  unsigned short version;
  unsigned int  creationDate;
  unsigned int  modificationDate;
  unsigned int  lastBackupDate;
  unsigned int  modificationNumber;
  unsigned int  appInfoID;
  unsigned int  sortInfoID;
  unsigned char type[4];
  unsigned char creator[4];
  unsigned int  uniqueIDSeed;
};

typedef struct _PDBHeaderType PDBHeaderType;


/**
 * generic Palm Database record structure
 * see pdb file specification for palm pdb files
 * http://www.palmos.com
 */
struct _PDBRecordType {
  unsigned int  localChunkID;
  char          attributes;
  char          uniqueID[3];
};

typedef struct _PDBRecordType PDBRecordType;


/* pdblib specific declarations */

/* callback functions */
/**< this fucntion is needed if you are using the pdbConvertDB routine */
typedef void  ( *pdbConvertRecordFunc )( FILE * outfile, int recIndex, void * recordP, PDBRecordType * recInfoP, PDBHeaderType * headerP, void * appInfoP );
/**< this fucntion is needed if you are using the pdbConvertDB routine */
typedef int   ( *pdbPrologParsingRecordsFunc )( FILE * outfile, int numRecords, PDBHeaderType * headerP, void * appInfoP );
/**< this fucntion is needed if you are using the pdbConvertDB routine */
typedef void	( *pdbEpilogParsingRecordsFunc )( FILE * outfile, int numRecords, PDBHeaderType * headerP, void * appInfoP );

/* new by pete 20.jan.02 */
typedef size_t (*pdbGetDBInfoTypeSize )( unsigned short version );

#define pdbErrNone                0
#define pdbErrInvalidParam        0xFFFF
#define pdbErrGeneralError        0xFFFE
#define pdbErrCreatorDifferent    0xFFFD
#define pdbErrTypeDifferent       0xFFFC
#define pdbErrNoRecords           0xFFFB

/******************************************************
 * pdblib funtions
 ******************************************************/

extern PDBHeaderType *  pdbLoadDBHeader( FILE * dbFile );
extern void *           pdbLoadDBRecord( FILE * dbFile, int index, PDBRecordType *headerP, int numRecords );
extern int              pdbLoadDBRecords( FILE * dbFile, PDBRecordType ** headerP );
extern void *           pdbLoadAppInfoType( FILE * dbFile, unsigned int appInfoID, size_t size );
/* modified by pete 20.jan.02 */
extern int              pdbConvertDB( FILE * dbFile, FILE * outfile, pdbGetDBInfoTypeSize getInfoSize, pdbPrologParsingRecordsFunc prologFunc, pdbConvertRecordFunc parseRecordFunc, pdbEpilogParsingRecordsFunc epilogFunc );


#endif //__PDBLIB_H__
