/*
 * Hrsh2csv is a command line utility for converting PDB desktop files created by
 * the Hours (http://hours.sourceforge.net) Palm application on a handheld into
 * files in the CSV (comma separated value) format.
 * 
 * Copyright (C) 2002 Peter Novotnik
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


/* FOR BEST FORMATING OF THIS FILE SET TABSTOP TO 2 */

#ifndef __HRSH2CSV_CONVERTER_H__
#define __HRSH2CSV_CONVERTER_H__

#include "pdblib.h"

#define HRSH2CSV_MAJOR_VERSION		1
#define HRSH2CSV_MINOR_VERSION		3

#define hrshErrDBVersionV18	1


#define HoursCreator				"HRSH"
#define HoursDBType					"DATA"

#define HoursDBVersionV15		0x00
#define HoursDBVersionV16		0x01
#define HoursDBVersionV18		0x02

#define kCurrencySymbolLength	4		// new on V18 dbs

/* these macros assume t to be the time format like on palm os. */
/* see palm sdk for a definition of TimeType */
#define TimeNoTime				0xFFFF
#define TimeGetHours(t)		((t) >> 8)
#define TimeGetMinutes(t) ((t) & 0x00FF)

/* these macros assume s to be the date format like on palm os. */
/* for a explanation of them see palm sdk for DateType definition */
#define DateGetYear( s ) 	(((s) & 0xFE00) >> 9)
#define DateGetMonth( s )	(((s) & 0x01E0) >> 5)
#define DateGetDay( s )		((s) & 0x001F)

#define firstYear 1904

#ifndef DATE_STRING_BUF_LEN
#	define DATE_STRING_BUF_LEN		32
#endif

#ifndef TIME_STRING_BUF_LEN
#	define TIME_STRING_BUF_LEN		16
#endif

#ifndef TOTAL_TIME_STRING_BUF_LEN
#	define TOTAL_TIME_STRING_BUF_LEN	16
#endif

#ifndef ENCLOSE_VALUE_STRING
#	define ENCLOSE_VALUE_STRING	"\""
#endif

/* hours specific structures ------------------------------------------------------------------- */

typedef struct
{
	unsigned short 	dollars;
	unsigned char		cents;
} HoursMoneyType;

typedef struct
{
	/* standard, requiered */
	unsigned short	renamedCategories;
	char						categoryLabels[dmRecNumCategories][dmCategoryLength];
	unsigned char		categoryUniqIDs[dmRecNumCategories];
	unsigned char		lastUniqID;
	unsigned char		reserved1;
	unsigned short	reserved2;

	/* hours specific */
	unsigned short	defaultLunchBreakMinutes;
	unsigned short	defaultBeginTime;
	unsigned short	defaultEndTime;

	unsigned short	lastCategory;
	unsigned short	sortOrder;
	unsigned short	flags;
	unsigned short	flags2;

	unsigned char		beginColX;
	unsigned char		endColX;
	unsigned char		hoursColX;
	unsigned char		descriptionColX;

	unsigned short	regular_minutes_per_record;
	unsigned char		row0_bgcolor_index;
	unsigned char		row1_bgcolor_index;
	unsigned char		vert_separator_color_index;
	unsigned char		date_separator_color_index;
	unsigned char		billed_strike_out_color_index;
	unsigned char		text_color_index;

} HoursDBInfoTypeV16;

typedef struct
{
	/* standard, requiered */
	unsigned short	renamedCategories;
	char						categoryLabels[dmRecNumCategories][dmCategoryLength];
	unsigned char		categoryUniqIDs[dmRecNumCategories];
	unsigned char		lastUniqID;
	unsigned char		reserved1;
	unsigned short	reserved2;

	/* hours specific */
	unsigned short	defaultLunchBreakMinutes;
	unsigned short	defaultBeginTime;
	unsigned short	defaultEndTime;

	unsigned short	lastCategory;
	unsigned short	sortOrder;
	unsigned short	flags;
	unsigned short	flags2;

	unsigned char		beginColX;
	unsigned char		endColX;
	unsigned char		hoursColX;
	unsigned char		descriptionColX;

	HoursMoneyType	def_rate_in_category[dmRecNumCategories];
	unsigned short	regular_minutes_per_record;
	char						currency_symbol[kCurrencySymbolLength];
	unsigned char		row0_bgcolor_index;
	unsigned char		row1_bgcolor_index;
	unsigned char		vert_separator_color_index;
	unsigned char		date_separator_color_index;
	unsigned char 	billed_strike_out_color_index;
	unsigned char		text_color_index;
	unsigned char		moneyColX;

} HoursDBInfoTypeV18;

typedef struct
{
	unsigned short 	date;				/* unsigned 16-bit value */
	unsigned short 	begin;			/* unsigned 16-bit value */
	unsigned short 	end;				/* unsigned 16-bit value */
	char 						s;
}
HoursRecordTypeV15;

typedef struct
{
	unsigned short 	date;
	unsigned short	begin;
	unsigned short	end;
	unsigned short	lunchminutes;		/* lunch break in minutes */
	char						s;
}
HoursRecordTypeV16;

typedef struct
{
	unsigned short 	date;
	unsigned short	begin;
	unsigned short	end;
	unsigned short	lunchminutes;		/* lunch break in minutes */

	HoursMoneyType	extra;
	HoursMoneyType	rate;

	char						s;
}
HoursRecordTypeV18;

/* converter public functions ------------------------------------------------------------------ */

extern size_t hrshGetSizeOfDBInfoType( unsigned short version );
extern void hrshConvertRecord( FILE * outfile, int recIndex, HoursRecordTypeV15 * recordP, PDBRecordType * recInfoP, PDBHeaderType * headerP, HoursDBInfoTypeV16 * appInfoP );
extern int hrshBeforeIterationCallback( FILE * outfile, int numRecords, PDBHeaderType * headerP, void * appInfoP );
extern void hrshAfterIterationCallback( FILE * outfile, int numRecords, PDBHeaderType * headerP, void * appInfoP );
extern int hrshPrintDBVersion( FILE * dbFile );
extern int hrshPrintDBInfo( FILE * dbFile );

#endif /* __HRSH2CSV_CONVERTER_H__ */
