/*
 * Hrsh2csv is a command line utility for converting PDB desktop files created by
 * the Hours (http://hours.sourceforge.net) Palm application on a handheld into
 * files in the CSV (comma separated value) format.
 *
 * Copyright (C) 2002 Peter Novotnik
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


/* FOR BEST FORMATING OF THIS FILE SET TABSTOP TO 2 */

#ifndef __HRSH2CSV_GLOBALS_H__
#define __HRSH2CSV_GLOBALS_H__

extern int			gDontEncloseValues;		/* non-zero if the values should not be enclosed by double quotes */
extern char *		gSeparatorString;			/* this points to the separator string to be used to separate columns */
extern int			gDontConvert0x95;			/* non-zero if the dot should not be converted */
extern int			gDontRemoveNL;				/* non-zero if newlines in a record's description should not be removed */
extern int			gRemoveNonASCII;			/* non-zero if non ascii chars should be replaced through a blank */
extern int			gPrintHeader;					/* non-zero if the converter should not print the column titels */
extern int			gPrintBanner;					/* non-zero if the program should print a banner after conversion (see hrshAfterIterationCallback function) */
extern int 			gVerbose;							/* non-zero if the program should be verbose */
extern char * 	gDatePattern;					/* points to the database pattern for the getDateString function */
extern char *		gTimePattern;					/* points to the time pattern for the getTimeString function */
extern char *		gTotalTimePattern;		/* points to the total time pattern for the getTotalTimeString function */

extern int			gARGC;								/* if gPrintHeader is 1 this varible gets initialized with the value from main */
extern char **  gARGV;								/* if gPrintHeader is 1 this varible gets initialized with the value from main */								

#define ERROR_PREFIX	"error:"

#endif /* __HRSH2CSV_GLOBALS_H__ */
