module Foreign.StablePtr
  ( StablePtr          -- abstract
  , newStablePtr       -- :: a -> IO (StablePtr a)
  , deRefStablePtr     -- :: StablePtr a -> IO a
  , freeStablePtr      -- :: StablePtr a -> IO ()
  , castStablePtrToPtr -- :: StablePtr a -> Ptr ()
  , castPtrToStablePtr -- :: Ptr () -> StablePtr a
  ) where

import PreludeBuiltinTypes
import Foreign.BuiltinTypes
import qualified TraceOrigForeign.StablePtr

foreign import haskell "Foreign.StablePtr.newStablePtr"
  newStablePtr :: a -> IO (StablePtr a)
foreign import haskell "Foreign.StablePtr.deRefStablePtr"
  deRefStablePtr :: StablePtr a -> IO a
foreign import haskell "Foreign.StablePtr.freeStablePtr"
  freeStablePtr :: StablePtr a -> IO ()
foreign import haskell "Foreign.StablePtr.castStablePtrToPtr"
  castStablePtrToPtr :: StablePtr a -> Ptr ()
foreign import haskell "Foreign.StablePtr.castPtrToStablePtr"
  castPtrToStablePtr:: Ptr () -> StablePtr a

