# This script renames all files that ends with *Darwin.dmg in the working 
# directory (these are files generated by CPack OSX Bundle generator) to
# *Darwin(OS_VERSION).dmg. E.g. *Darwin(10.8.1).dmg. This is used by the
# buildbot to differentiate for binaries created by buildslaves on different
# versions of OSX.

import subprocess
import os

# find all plugin libraries
files = os.listdir(".")

o = subprocess.Popen(['sw_vers', '-productVersion'], stdout=subprocess.PIPE)
os_version = o.stdout.readline().rstrip('\n')

for filename in files:
  if( filename.endswith( "Darwin.dmg" ) ):
      new_filename = filename.replace( "Darwin.dmg", "Darwin(" + os_version + ").dmg" )
      os.rename( filename, new_filename )




