/*
 * Decompiled with CFR 0.152.
 */
package org.testng.collections;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.testng.collections.Maps;

public abstract class MultiMap<K, V, C extends Collection<V>> {
    protected final Map<K, C> m_objects;

    protected MultiMap(boolean isSorted) {
        this.m_objects = isSorted ? Maps.newLinkedHashMap() : Maps.newHashMap();
    }

    protected abstract C createValue();

    public boolean put(K key, V method) {
        AtomicBoolean exists = new AtomicBoolean(true);
        return this.m_objects.computeIfAbsent(key, k -> {
            exists.set(false);
            return this.createValue();
        }).add(method) && exists.get();
    }

    public C get(K key) {
        return (C)this.m_objects.computeIfAbsent(key, k -> this.createValue());
    }

    public Set<K> keySet() {
        return new HashSet<K>(this.m_objects.keySet());
    }

    public boolean containsKey(K k) {
        return this.m_objects.containsKey(k);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        Set<K> indices = this.keySet();
        for (K i : indices) {
            result.append("\n    ").append(i).append(" <-- ");
            for (Object o : (Collection)this.m_objects.get(i)) {
                result.append(o).append(" ");
            }
        }
        return result.toString();
    }

    public boolean isEmpty() {
        return this.m_objects.size() == 0;
    }

    public int size() {
        return this.m_objects.size();
    }

    public boolean remove(K key, V value) {
        return this.get(key).remove(value);
    }

    public C removeAll(K key) {
        return (C)((Collection)this.m_objects.remove(key));
    }

    public Set<Map.Entry<K, C>> entrySet() {
        return this.m_objects.entrySet();
    }

    public Collection<C> values() {
        return this.m_objects.values();
    }

    public boolean putAll(K k, Collection<? extends V> values) {
        boolean result = false;
        for (V v : values) {
            result = this.put(k, v) || result;
        }
        return result;
    }
}

