/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.serial;

import groovyx.gpars.serial.SerialHandle;
import groovyx.gpars.serial.SerialHandles;
import groovyx.gpars.serial.SerialMsg;
import java.util.UUID;

public abstract class SerialContext {
    private static final ThreadLocal<SerialContext> threadContext = new ThreadLocal();
    protected final SerialHandles localHost;
    protected final UUID hostId;

    public SerialContext(SerialHandles localHost, UUID hostId) {
        this.localHost = localHost;
        this.hostId = hostId;
    }

    public static SerialContext get() {
        return threadContext.get();
    }

    public UUID getHostId() {
        return this.hostId;
    }

    public final void enter() {
        if (threadContext.get() != null) {
            throw new IllegalStateException("Serialization context already defined");
        }
        threadContext.set(this);
    }

    public final void leave() {
        if (threadContext.get() != this) {
            throw new IllegalStateException("Wrong serialization context");
        }
        threadContext.set(null);
    }

    public UUID getLocalHostId() {
        return this.localHost.getId();
    }

    public void add(SerialHandle serialHandle) {
        this.localHost.add(serialHandle);
    }

    public void remove(SerialHandle serialHandle) {
        this.localHost.remove(serialHandle);
    }

    public SerialHandle get(UUID id) {
        return this.localHost.get(id);
    }

    public void finalizeHandle(SerialHandle handle) {
        this.localHost.finalizeHandle(handle);
    }

    public SerialContext getSerialHost(UUID hostId, Object attachment) {
        return this.localHost.getSerialHost(hostId, attachment);
    }

    public abstract void write(SerialMsg var1);
}

