#### Contributing to Gravity
Everyone is welcome to contribute to Gravity. Contributing doesn’t just mean submitting pull requests,
there are many different ways for you to get involved, including reporting bugs, add new functionalities
or just participating in the project.

#### Where to make changes
Core libraries and documentation is probably the areas that need major contribution.
Any change to the core VM or other parts of the compiler are welcomed.

#### Code style and syntax rules
Looking at the Gravity source code I think you can easily follow the same coding style and syntax rule.
Private functions usually don't begin with a gravity_ prefix and are marked as static.
Feel free to expand this section with a more formal description of the syntax rules.

#### Testing rules
If you fix a bug or if you add a new functionality then a unit-test is required.
A unit-test is a single source code file that is able to run under the unittest executable file.
You are free to test your functionalities/fixes into a single unit-test file or split the test in more files.

#### Add Docs
If you add new functionality, or edit the way that current functionality works,
add or edit the docs to reflect this so that there is documentation of the new
changes for new users.

#### Contributors File
Don't forget to add your name and your email address to the official **CONTRIBUTORS** file!
