/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.compiler.grape;

import groovy.lang.GroovyClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.internal.impl.DefaultRepositorySystem;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.springframework.boot.cli.compiler.grape.DefaultRepositorySystemSessionAutoConfiguration;
import org.springframework.boot.cli.compiler.grape.DependencyResolutionContext;
import org.springframework.boot.cli.compiler.grape.MavenResolverGrapeEngine;
import org.springframework.boot.cli.compiler.grape.RepositoryConfiguration;
import org.springframework.boot.cli.compiler.grape.RepositorySystemSessionAutoConfiguration;

public abstract class MavenResolverGrapeEngineFactory {
    public static MavenResolverGrapeEngine create(GroovyClassLoader classLoader, List<RepositoryConfiguration> repositoryConfigurations, DependencyResolutionContext dependencyResolutionContext, boolean quiet) {
        RepositorySystem repositorySystem = MavenResolverGrapeEngineFactory.createRepositorySystem();
        DefaultRepositorySystemSession repositorySystemSession = MavenRepositorySystemUtils.newSession();
        repositorySystemSession.setSystemProperties((Map)System.getProperties());
        ServiceLoader<RepositorySystemSessionAutoConfiguration> autoConfigurations = ServiceLoader.load(RepositorySystemSessionAutoConfiguration.class);
        for (RepositorySystemSessionAutoConfiguration autoConfiguration : autoConfigurations) {
            autoConfiguration.apply(repositorySystemSession, repositorySystem);
        }
        new DefaultRepositorySystemSessionAutoConfiguration().apply(repositorySystemSession, repositorySystem);
        return new MavenResolverGrapeEngine(classLoader, repositorySystem, repositorySystemSession, MavenResolverGrapeEngineFactory.createRepositories(repositoryConfigurations), dependencyResolutionContext, quiet);
    }

    private static RepositorySystem createRepositorySystem() {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositorySystem.class, DefaultRepositorySystem.class);
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        return (RepositorySystem)locator.getService(RepositorySystem.class);
    }

    private static List<RemoteRepository> createRepositories(List<RepositoryConfiguration> repositoryConfigurations) {
        ArrayList<RemoteRepository> repositories = new ArrayList<RemoteRepository>(repositoryConfigurations.size());
        for (RepositoryConfiguration repositoryConfiguration : repositoryConfigurations) {
            RemoteRepository.Builder builder = new RemoteRepository.Builder(repositoryConfiguration.getName(), "default", repositoryConfiguration.getUri().toASCIIString());
            if (!repositoryConfiguration.getSnapshotsEnabled()) {
                builder.setSnapshotPolicy(new RepositoryPolicy(false, "never", "ignore"));
            }
            repositories.add(builder.build());
        }
        return repositories;
    }
}

