/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.spring.context.convert;

import io.micronaut.spring.beans.MicronautContextInternal;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;

@Singleton
@Named(value="conversionService")
public class MicronautConversionService
implements ConversionService,
MicronautContextInternal {
    private final io.micronaut.core.convert.ConversionService<?> conversionService;

    public MicronautConversionService(io.micronaut.core.convert.ConversionService<?> conversionService) {
        this.conversionService = conversionService;
    }

    public boolean canConvert(Class<?> sourceType, Class<?> targetType) {
        return this.conversionService.canConvert(sourceType, targetType);
    }

    public boolean canConvert(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return this.conversionService.canConvert(sourceType.getType(), targetType.getType());
    }

    public <T> T convert(Object source, Class<T> targetType) {
        return this.conversionService.convert(source, targetType).orElse(null);
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        return this.conversionService.convert(source.getClass(), targetType.getType()).orElse(null);
    }
}

