/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.core.connections;

import groovy.lang.MetaClass;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.grails.datastore.mapping.core.connections.AbstractConnectionSources;
import org.grails.datastore.mapping.core.connections.ConnectionSource;
import org.grails.datastore.mapping.core.connections.ConnectionSourceFactory;
import org.grails.datastore.mapping.core.connections.ConnectionSourceSettings;
import org.grails.datastore.mapping.core.connections.ConnectionSourcesListener;
import org.springframework.core.env.PropertyResolver;

public class InMemoryConnectionSources<T, S extends ConnectionSourceSettings>
extends AbstractConnectionSources<T, S> {
    protected final Map<String, ConnectionSource<T, S>> connectionSourceMap;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public InMemoryConnectionSources(ConnectionSource<T, S> defaultConnectionSource, ConnectionSourceFactory<T, S> connectionSourceFactory, PropertyResolver configuration) {
        super(defaultConnectionSource, connectionSourceFactory, configuration);
        MetaClass metaClass;
        ConcurrentHashMap<String, ConnectionSource<T, S>> concurrentHashMap = new ConcurrentHashMap<String, ConnectionSource<T, S>>();
        this.connectionSourceMap = concurrentHashMap;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.connectionSourceMap.put(ConnectionSource.DEFAULT, defaultConnectionSource);
        String name = null;
        Iterator<String> iterator = this.getConnectionSourceNames(connectionSourceFactory, configuration).iterator();
        while (iterator.hasNext()) {
            name = ShortTypeHandling.castToString((Object)iterator.next());
            if (name.equals("dataSource")) continue;
            ConnectionSource<T, S> connectionSource = connectionSourceFactory.create(name, configuration, defaultConnectionSource.getSettings());
            if (!(connectionSource != null)) continue;
            this.connectionSourceMap.put(name, connectionSource);
        }
    }

    @Override
    public Iterable<ConnectionSource<T, S>> getAllConnectionSources() {
        return Collections.unmodifiableCollection(this.connectionSourceMap.values());
    }

    @Override
    public ConnectionSource<T, S> getConnectionSource(String name) {
        return (ConnectionSource)ScriptBytecodeAdapter.castToType(this.connectionSourceMap.get(name), ConnectionSource.class);
    }

    @Override
    public ConnectionSource<T, S> addConnectionSource(String name, PropertyResolver configuration) {
        if (name == null) {
            throw (Throwable)new IllegalArgumentException("Argument [name] cannot be null");
        }
        if (configuration == null) {
            throw (Throwable)new IllegalArgumentException("Argument [configuration] cannot be null");
        }
        ConnectionSource connectionSource = this.connectionSourceFactory.createRuntime(name, configuration, (ConnectionSourceSettings)this.getDefaultConnectionSource().getSettings());
        if (connectionSource == null) {
            throw (Throwable)new IllegalStateException("ConnectionSource factory returned null");
        }
        this.connectionSourceMap.put(name, connectionSource);
        Object var4_4 = null;
        for (ConnectionSourcesListener connectionSourcesListener : this.listeners) {
            connectionSourcesListener.newConnectionSource(connectionSource);
        }
        return connectionSource;
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != InMemoryConnectionSources.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }
}

