/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.codec;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.core.type.Argument;
import io.micronaut.http.MediaType;
import io.micronaut.http.codec.CodecException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;

public interface MediaTypeCodec {
    public Collection<MediaType> getMediaTypes();

    public <T> T decode(Argument<T> var1, InputStream var2) throws CodecException;

    public <T> void encode(T var1, OutputStream var2) throws CodecException;

    public <T> byte[] encode(T var1) throws CodecException;

    public <T, B> ByteBuffer<B> encode(T var1, ByteBufferFactory<?, B> var2) throws CodecException;

    default public <T> void encode(@NonNull Argument<T> type, @NonNull T object, @NonNull OutputStream outputStream) throws CodecException {
        this.encode(object, outputStream);
    }

    @NonNull
    default public <T> byte[] encode(@NonNull Argument<T> type, T object) throws CodecException {
        return this.encode(object);
    }

    @NonNull
    default public <T, B> ByteBuffer<B> encode(@NonNull Argument<T> type, T object, @NonNull ByteBufferFactory<?, B> allocator) throws CodecException {
        return this.encode(object, allocator);
    }

    default public <T> T decode(Class<T> type, InputStream inputStream) throws CodecException {
        return this.decode(Argument.of(type), inputStream);
    }

    default public <T> T decode(Class<T> type, byte[] bytes) throws CodecException {
        return this.decode(type, (InputStream)new ByteArrayInputStream(bytes));
    }

    default public <T> T decode(Argument<T> type, byte[] bytes) throws CodecException {
        return this.decode(type, (InputStream)new ByteArrayInputStream(bytes));
    }

    default public <T> T decode(Class<T> type, ByteBuffer<?> buffer) throws CodecException {
        return this.decode(type, buffer.toInputStream());
    }

    default public <T> T decode(Argument<T> type, ByteBuffer<?> buffer) throws CodecException {
        return this.decode(type, buffer.toInputStream());
    }

    default public <T> T decode(Class<T> type, String data) throws CodecException {
        return this.decode(type, (InputStream)new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8)));
    }

    default public <T> T decode(Argument<T> type, String data) throws CodecException {
        return this.decode(type, (InputStream)new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8)));
    }

    default public boolean supportsType(Class<?> type) {
        return true;
    }
}

