/*
 * Decompiled with CFR 0.152.
 */
package grails.web.servlet.context.support;

import grails.core.GrailsApplication;
import grails.util.Environment;
import java.util.Set;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;
import org.springframework.web.context.support.StandardServletEnvironment;

public class GrailsEnvironment
extends StandardServletEnvironment {
    GrailsApplication grailsApplication;

    public GrailsEnvironment(GrailsApplication grailsApplication) {
        this.grailsApplication = grailsApplication;
        this.getPropertySources().addFirst((PropertySource)new GrailsConfigPropertySource());
        this.getPropertySources().addFirst((PropertySource)new PropertiesPropertySource("systemProperties", System.getProperties()));
    }

    protected Set<String> doGetActiveProfiles() {
        Set activeProfiles = super.doGetActiveProfiles();
        activeProfiles.add(Environment.getCurrent().getName());
        return activeProfiles;
    }

    private class GrailsConfigPropertySource
    extends PropertySource<GrailsApplication> {
        public GrailsConfigPropertySource() {
            super(StringUtils.hasText((String)GrailsEnvironment.this.grailsApplication.getMetadata().getApplicationName()) ? GrailsEnvironment.this.grailsApplication.getMetadata().getApplicationName() : "grailsApplication", (Object)GrailsEnvironment.this.grailsApplication);
        }

        public Object getProperty(String key) {
            return GrailsEnvironment.this.grailsApplication.getConfig().getProperty(key, Object.class);
        }
    }
}

