/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.visitor;

import io.micronaut.annotation.processing.GenericUtils;
import io.micronaut.annotation.processing.visitor.JavaClassElement;
import io.micronaut.annotation.processing.visitor.JavaConstructorElement;
import io.micronaut.annotation.processing.visitor.JavaElementFactory;
import io.micronaut.annotation.processing.visitor.JavaFieldElement;
import io.micronaut.annotation.processing.visitor.JavaMethodElement;
import io.micronaut.annotation.processing.visitor.JavaVisitorContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.order.Ordered;
import io.micronaut.core.reflect.GenericTypeUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ConstructorElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

@Internal
public class LoadedVisitor
implements Ordered {
    private static final String OBJECT_CLASS = Object.class.getName();
    private final TypeElementVisitor visitor;
    private final String classAnnotation;
    private final String elementAnnotation;
    private final JavaVisitorContext visitorContext;
    private final JavaElementFactory elementFactory;
    private JavaClassElement rootClassElement;

    public LoadedVisitor(TypeElementVisitor visitor, JavaVisitorContext visitorContext, GenericUtils genericUtils, ProcessingEnvironment processingEnvironment) {
        this.visitorContext = visitorContext;
        this.elementFactory = visitorContext.getElementFactory();
        this.visitor = visitor;
        Class<?> aClass = visitor.getClass();
        TypeElement typeElement = processingEnvironment.getElementUtils().getTypeElement(aClass.getName());
        if (typeElement != null) {
            List<? extends TypeMirror> generics = genericUtils.interfaceGenericTypesFor(typeElement, TypeElementVisitor.class.getName());
            String typeName = generics.get(0).toString();
            this.classAnnotation = typeName.equals(OBJECT_CLASS) ? visitor.getClassType() : typeName;
            String elementName = generics.get(1).toString();
            this.elementAnnotation = elementName.equals(OBJECT_CLASS) ? visitor.getElementType() : elementName;
        } else {
            Class[] classes = GenericTypeUtils.resolveInterfaceTypeArguments(aClass, TypeElementVisitor.class);
            if (classes != null && classes.length == 2) {
                Class classGeneric = classes[0];
                this.classAnnotation = classGeneric == Object.class ? visitor.getClassType() : classGeneric.getName();
                Class elementGeneric = classes[1];
                this.elementAnnotation = elementGeneric == Object.class ? visitor.getElementType() : elementGeneric.getName();
            } else {
                this.classAnnotation = Object.class.getName();
                this.elementAnnotation = Object.class.getName();
            }
        }
    }

    public int getOrder() {
        return this.visitor.getOrder();
    }

    public TypeElementVisitor getVisitor() {
        return this.visitor;
    }

    public boolean matches(TypeElement typeElement) {
        if (this.classAnnotation.equals("java.lang.Object")) {
            return true;
        }
        AnnotationMetadata annotationMetadata = this.visitorContext.getAnnotationUtils().getAnnotationMetadata(typeElement);
        return annotationMetadata.hasStereotype(this.classAnnotation);
    }

    public boolean matches(AnnotationMetadata annotationMetadata) {
        if (this.elementAnnotation.equals("java.lang.Object")) {
            return true;
        }
        return annotationMetadata.hasStereotype(this.elementAnnotation);
    }

    @Nullable
    public Element visit(javax.lang.model.element.Element element, AnnotationMetadata annotationMetadata) {
        if (element instanceof VariableElement) {
            JavaFieldElement e = this.elementFactory.newFieldElement((ClassElement)this.rootClassElement, (VariableElement)element, annotationMetadata);
            this.visitor.visitField((FieldElement)e, (VisitorContext)this.visitorContext);
            return e;
        }
        if (element instanceof ExecutableElement) {
            ExecutableElement executableElement = (ExecutableElement)element;
            if (this.rootClassElement != null) {
                if (executableElement.getSimpleName().toString().equals("<init>")) {
                    JavaConstructorElement e = this.elementFactory.newConstructorElement((ClassElement)this.rootClassElement, executableElement, annotationMetadata);
                    this.visitor.visitConstructor((ConstructorElement)e, (VisitorContext)this.visitorContext);
                    return e;
                }
                JavaMethodElement e = this.elementFactory.newSourceMethodElement((ClassElement)this.rootClassElement, executableElement, annotationMetadata);
                this.visitor.visitMethod((MethodElement)e, (VisitorContext)this.visitorContext);
                return e;
            }
        } else if (element instanceof TypeElement) {
            TypeElement typeElement = (TypeElement)element;
            this.rootClassElement = this.elementFactory.newSourceClassElement(typeElement, annotationMetadata);
            this.visitor.visitClass((ClassElement)this.rootClassElement, (VisitorContext)this.visitorContext);
            return this.rootClassElement;
        }
        return null;
    }

    public String toString() {
        return this.visitor.toString();
    }
}

