/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.spring.context.factory;

import io.micronaut.context.BeanContext;
import io.micronaut.context.Qualifier;
import io.micronaut.context.annotation.DefaultScope;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.context.exceptions.NoSuchBeanException;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.naming.NameResolver;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.BeanDefinitionReference;
import io.micronaut.inject.DisposableBeanDefinition;
import io.micronaut.inject.ParametrizedBeanFactory;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.spring.context.aware.SpringAwareListener;
import io.micronaut.spring.context.factory.MicronautBeanFactoryConfiguration;
import jakarta.inject.Singleton;
import java.io.Closeable;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.HierarchicalBeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Scope;
import org.springframework.core.ResolvableType;
import org.springframework.stereotype.Component;
import org.springframework.util.ConcurrentReferenceHashMap;

@Singleton
@Internal
public class MicronautBeanFactory
extends DefaultListableBeanFactory
implements ListableBeanFactory,
AutowireCapableBeanFactory,
HierarchicalBeanFactory,
ConfigurableListableBeanFactory {
    private final BeanContext beanContext;
    private final Map<String, io.micronaut.inject.BeanDefinition<?>> beanDefinitionMap = new LinkedHashMap(200);
    private final Map<String, io.micronaut.inject.BeanDefinition<?>> beanDefinitionsByName = new LinkedHashMap(200);
    private final SpringAwareListener springAwareListener;
    private final Map<String, Optional<Class<?>>> beanTypeCache = new ConcurrentReferenceHashMap();
    private final Map<Class, String[]> beanNamesForTypeCache = new ConcurrentReferenceHashMap();
    private final MicronautBeanFactoryConfiguration configuration;
    private final List<Class<?>> beanExcludes;

    public MicronautBeanFactory(BeanContext beanContext, SpringAwareListener awareListener, MicronautBeanFactoryConfiguration configuration) {
        this.beanContext = beanContext;
        this.springAwareListener = awareListener;
        this.configuration = configuration;
        this.beanExcludes = configuration.getBeanExcludes();
        Collection references = beanContext.getBeanDefinitionReferences();
        for (BeanDefinitionReference reference : references) {
            Optional v;
            io.micronaut.inject.BeanDefinition definition = reference.load(beanContext);
            if (definition instanceof ParametrizedBeanFactory || !(definition instanceof io.micronaut.inject.BeanFactory) || this.beanExcludes.contains(definition.getBeanType()) || !definition.isEnabled(beanContext)) continue;
            if (definition.isIterable()) {
                Collection beanDefinitions = beanContext.getBeanDefinitions(definition.getBeanType());
                for (io.micronaut.inject.BeanDefinition beanDefinition : beanDefinitions) {
                    String beanName = this.computeBeanName(beanDefinition);
                    this.beanDefinitionMap.put(beanName, beanDefinition);
                }
            } else {
                String beanName = this.computeBeanName(definition);
                this.beanDefinitionMap.put(beanName, definition);
            }
            if (definition.isAnnotationPresent(Component.class)) {
                v = definition.getValue(Component.class, String.class);
                v.ifPresent(s -> this.beanDefinitionsByName.put((String)s, (io.micronaut.inject.BeanDefinition<?>)definition));
            }
            if (!definition.isAnnotationPresent(Bean.class)) continue;
            v = definition.getValue(Bean.class, String.class);
            v.ifPresent(s -> this.beanDefinitionsByName.put((String)s, (io.micronaut.inject.BeanDefinition<?>)definition));
        }
    }

    public static boolean isSingleton(AnnotationMetadata annotationMetadata) {
        if (annotationMetadata.hasDeclaredStereotype(Bean.class)) {
            String scope = annotationMetadata.stringValue(Scope.class).orElse(null);
            return scope == null || "singleton".equalsIgnoreCase(scope);
        }
        if (annotationMetadata.hasDeclaredStereotype("javax.inject.Singleton")) {
            return true;
        }
        if (!annotationMetadata.hasDeclaredStereotype("javax.inject.Scope") && annotationMetadata.hasDeclaredStereotype(DefaultScope.class)) {
            return annotationMetadata.stringValue(DefaultScope.class).map(t -> t.equals(Singleton.class.getName()) || t.equals("javax.inject.Singleton")).orElse(false);
        }
        return false;
    }

    private String computeBeanName(io.micronaut.inject.BeanDefinition<?> definition) {
        String name = definition instanceof NameResolver ? ((NameResolver)definition).resolveName().orElse(Primary.class.getSimpleName()) : definition.getValue("javax.inject.Named", String.class).orElseGet(() -> definition.getAnnotationTypeByStereotype("javax.inject.Qualifier").map(Class::getSimpleName).orElse(definition.getClass().getSimpleName()));
        return definition.getBeanType().getName() + "(" + name + ")";
    }

    @NonNull
    public Object getBean(@NonNull String name) throws BeansException {
        io.micronaut.inject.BeanDefinition<?> definition;
        if (super.isAlias(name)) {
            String[] aliases;
            for (String alias : aliases = super.getAliases(name)) {
                if (!this.containsBean(alias)) continue;
                return this.getBean(alias);
            }
        }
        if (super.containsSingleton(name)) {
            Object singleton = super.getSingleton(name, true);
            if (singleton == null) {
                throw new NoSuchBeanDefinitionException(name);
            }
            return singleton;
        }
        Class type = this.getType(name);
        if (type != null) {
            definition = this.beanDefinitionMap.get(name);
        } else {
            definition = this.beanDefinitionsByName.get(name);
            if (definition != null) {
                type = definition.getBeanType();
            }
        }
        if (definition != null && type != null) {
            AnnotationMetadata annotationMetadata = definition.getAnnotationMetadata();
            Optional<Qualifier> q = annotationMetadata.getAnnotationNameByStereotype("javax.inject.Qualifier").map(clazz -> Qualifiers.byAnnotation((AnnotationMetadata)annotationMetadata, (String)clazz));
            if (!q.isPresent() && (name = definition instanceof NameResolver ? (String)((NameResolver)definition).resolveName().orElse(null) : (String)definition.stringValue("javax.inject.Named").orElse(null)) != null) {
                q = Optional.of(Qualifiers.byName((String)name));
            }
            if (q.isPresent()) {
                try {
                    return this.beanContext.getBean(type, q.get());
                }
                catch (NoSuchBeanException e) {
                    throw new NoSuchBeanDefinitionException(type, e.getMessage());
                }
                catch (Exception e) {
                    throw new BeanCreationException(name, e.getMessage(), (Throwable)e);
                }
            }
            return this.getBean(type);
        }
        throw new NoSuchBeanDefinitionException(name);
    }

    @NonNull
    public <T> T getBean(@NonNull String name, @NonNull Class<T> requiredType) throws BeansException {
        ArgumentUtils.requireNonNull((String)"requiredType", requiredType);
        if (this.beanExcludes.contains(requiredType)) {
            throw new NoSuchBeanDefinitionException(requiredType);
        }
        try {
            Object o;
            if (this.isAlias(name)) {
                String[] aliases;
                for (String alias : aliases = this.getAliases(name)) {
                    if (!super.containsSingleton(alias)) continue;
                    return (T)super.getBean(alias, requiredType);
                }
            }
            if (super.containsSingleton(name) && requiredType.isInstance(o = super.getBean(name))) {
                return (T)o;
            }
            return (T)this.beanContext.getBean(requiredType, Qualifiers.byName((String)name));
        }
        catch (NoSuchBeanException e) {
            throw new NoSuchBeanDefinitionException(requiredType, e.getMessage());
        }
        catch (Exception e) {
            throw new BeanCreationException(name, e.getMessage(), (Throwable)e);
        }
    }

    @NonNull
    public Object getBean(@NonNull String name, Object ... args) throws BeansException {
        Class<?> type = this.getType(name);
        if (type != null) {
            return this.beanContext.createBean(type, args);
        }
        throw new NoSuchBeanDefinitionException(name);
    }

    @NonNull
    public <T> T getBean(@NonNull Class<T> requiredType) throws BeansException {
        ArgumentUtils.requireNonNull((String)"requiredType", requiredType);
        if (this.beanExcludes.contains(requiredType)) {
            throw new NoSuchBeanDefinitionException(requiredType);
        }
        try {
            Object[] beanNamesForType = super.getBeanNamesForType(requiredType, false, false);
            if (ArrayUtils.isNotEmpty((Object[])beanNamesForType)) {
                return this.getBean((String)beanNamesForType[0], requiredType);
            }
            return (T)this.beanContext.getBean(requiredType);
        }
        catch (NoSuchBeanException e) {
            throw new NoSuchBeanDefinitionException(requiredType, e.getMessage());
        }
    }

    @NonNull
    public <T> T getBean(@NonNull Class<T> requiredType, Object ... args) throws BeansException {
        try {
            return (T)this.beanContext.createBean(requiredType, args);
        }
        catch (NoSuchBeanException e) {
            throw new NoSuchBeanDefinitionException(requiredType, e.getMessage());
        }
    }

    @NonNull
    public <T> ObjectProvider<T> getBeanProvider(final @NonNull Class<T> requiredType) {
        return new ObjectProvider<T>(){

            public T getObject(Object ... args) throws BeansException {
                return MicronautBeanFactory.this.beanContext.createBean(requiredType, args);
            }

            public T getIfAvailable() throws BeansException {
                if (MicronautBeanFactory.this.beanContext.containsBean(requiredType)) {
                    return MicronautBeanFactory.this.beanContext.getBean(requiredType);
                }
                return null;
            }

            public T getIfUnique() throws BeansException {
                Collection beansOfType = MicronautBeanFactory.this.beanContext.getBeansOfType(requiredType);
                if (beansOfType.size() == 1) {
                    return beansOfType.stream().findFirst().orElse(null);
                }
                return null;
            }

            public T getObject() throws BeansException {
                return MicronautBeanFactory.this.beanContext.getBean(requiredType);
            }
        };
    }

    @NonNull
    public <T> ObjectProvider<T> getBeanProvider(@NonNull ResolvableType requiredType) {
        Class resolved = requiredType.resolve();
        return this.getBeanProvider(resolved);
    }

    public boolean containsBean(@NonNull String name) {
        return super.containsSingleton(name) || this.beanDefinitionMap.containsKey(name) || this.beanDefinitionsByName.containsKey(name) || this.isAlias(name);
    }

    public boolean isSingleton(@NonNull String name) throws NoSuchBeanDefinitionException {
        if (super.containsSingleton(name)) {
            return true;
        }
        io.micronaut.inject.BeanDefinition<?> definition = this.beanDefinitionMap.get(name);
        if (definition != null) {
            return MicronautBeanFactory.isSingleton(definition);
        }
        return false;
    }

    protected boolean isSingleton(@NonNull BeanDefinitionReference<?> definition) {
        AnnotationMetadata annotationMetadata = definition.getAnnotationMetadata();
        return MicronautBeanFactory.isSingleton(annotationMetadata);
    }

    public boolean isPrototype(@NonNull String name) throws NoSuchBeanDefinitionException {
        if (super.containsSingleton(name)) {
            return false;
        }
        io.micronaut.inject.BeanDefinition<?> definition = this.beanDefinitionMap.get(name);
        if (definition != null) {
            AnnotationMetadata annotationMetadata = definition.getAnnotationMetadata();
            if (annotationMetadata.hasDeclaredStereotype(Prototype.class)) {
                return true;
            }
            boolean hasScope = annotationMetadata.getAnnotationNamesByStereotype("javax.inject.Scope").isEmpty();
            return !hasScope;
        }
        return false;
    }

    public boolean isTypeMatch(@NonNull String name, @NonNull ResolvableType typeToMatch) throws NoSuchBeanDefinitionException {
        Class resolved = typeToMatch.resolve();
        if (resolved != null) {
            return this.isTypeMatch(name, resolved);
        }
        return false;
    }

    public boolean isTypeMatch(@NonNull String name, @NonNull Class<?> typeToMatch) throws NoSuchBeanDefinitionException {
        Class<?> beanType = this.getType(name);
        if (beanType != null) {
            return typeToMatch.isAssignableFrom(beanType);
        }
        return false;
    }

    public Class<?> getType(@NonNull String beanName) throws NoSuchBeanDefinitionException {
        Optional<Class<?>> opt = this.beanTypeCache.get(beanName);
        if (opt == null) {
            io.micronaut.inject.BeanDefinition<?> definition = this.beanDefinitionMap.get(beanName);
            if (definition != null) {
                opt = Optional.of(definition.getBeanType());
            } else {
                BeanDefinition parentDef;
                Object beanInstance = super.getSingleton(beanName = this.transformedBeanName(beanName), false);
                if (beanInstance != null && !beanInstance.getClass().getSimpleName().equals("NullBean")) {
                    if (beanInstance instanceof FactoryBean && !BeanFactoryUtils.isFactoryDereference((String)beanName)) {
                        return this.getTypeForFactoryBean((FactoryBean)beanInstance);
                    }
                    return beanInstance.getClass();
                }
                BeanFactory parentBeanFactory = this.getParentBeanFactory();
                if (parentBeanFactory != null && !this.containsBeanDefinition(beanName)) {
                    return parentBeanFactory.getType(this.originalBeanName(beanName));
                }
                try {
                    parentDef = super.getBeanDefinition(beanName);
                }
                catch (NoSuchBeanDefinitionException e) {
                    this.beanTypeCache.put(beanName, Optional.empty());
                    return null;
                }
                if (parentDef instanceof RootBeanDefinition) {
                    Class beanClass;
                    RootBeanDefinition mbd = (RootBeanDefinition)parentDef;
                    BeanDefinitionHolder dbd = mbd.getDecoratedDefinition();
                    if (dbd != null && !BeanFactoryUtils.isFactoryDereference((String)beanName)) {
                        RootBeanDefinition tbd = super.getMergedBeanDefinition(dbd.getBeanName(), dbd.getBeanDefinition(), (BeanDefinition)mbd);
                        Class targetClass = this.predictBeanType(dbd.getBeanName(), tbd, new Class[0]);
                        if (targetClass != null && !FactoryBean.class.isAssignableFrom(targetClass)) {
                            return targetClass;
                        }
                    }
                    if ((beanClass = this.predictBeanType(beanName, mbd, new Class[0])) != null && FactoryBean.class.isAssignableFrom(beanClass)) {
                        if (!BeanFactoryUtils.isFactoryDereference((String)beanName)) {
                            return super.getTypeForFactoryBean(beanName, mbd);
                        }
                        return beanClass;
                    }
                    return !BeanFactoryUtils.isFactoryDereference((String)beanName) ? beanClass : null;
                }
            }
            this.beanTypeCache.put(beanName, opt);
        }
        return opt.orElse(null);
    }

    public boolean containsBeanDefinition(@NonNull String beanName) {
        return this.beanDefinitionMap.containsKey(beanName);
    }

    public int getBeanDefinitionCount() {
        return this.beanDefinitionMap.size();
    }

    @NonNull
    public String[] getBeanDefinitionNames() {
        return this.beanDefinitionMap.keySet().toArray(new String[0]);
    }

    @NonNull
    public String[] getBeanNamesForType(@NonNull ResolvableType type) {
        Class resolved = type.resolve();
        if (resolved != null) {
            return this.getBeanNamesForType(resolved);
        }
        return StringUtils.EMPTY_STRING_ARRAY;
    }

    @NonNull
    public String[] getBeanNamesForType(Class<?> type) {
        return this.getBeanNamesForType(type, true, true);
    }

    @NonNull
    public String[] getBeanNamesForType(Class<?> type, boolean includeNonSingletons, boolean allowEagerInit) {
        if (type == null || Object.class == type || List.class == type || this.beanExcludes.contains(type)) {
            return StringUtils.EMPTY_STRING_ARRAY;
        }
        Object[] names = this.beanNamesForTypeCache.get(type);
        if (names == null) {
            Object[] superResult = MicronautBeanFactory.super.getBeanNamesForType(type, includeNonSingletons, allowEagerInit);
            if (ArrayUtils.isNotEmpty((Object[])superResult)) {
                names = superResult;
            } else {
                Collection beanDefinitions = this.beanContext.getBeanDefinitions(type);
                names = this.beansToNames(beanDefinitions);
            }
            this.beanNamesForTypeCache.put(type, (String[])names);
        }
        return names;
    }

    @NonNull
    public <T> Map<String, T> getBeansOfType(Class<T> type, boolean includeNonSingletons, boolean allowEagerInit) throws BeansException {
        if (type == null || this.beanExcludes.contains(type)) {
            return Collections.emptyMap();
        }
        Map springSingletons = super.getBeansOfType(type, false, false);
        Collection beansOfType = this.beanContext.getBeansOfType(type);
        HashMap beans = new HashMap(beansOfType.size());
        beans.putAll(springSingletons);
        for (Object bean : beansOfType) {
            if (springSingletons.containsValue(bean)) continue;
            Optional reg = this.beanContext.findBeanRegistration(bean);
            reg.ifPresent(registration -> beans.put(registration.getBeanDefinition().getClass().getName(), bean));
        }
        return beans;
    }

    @NonNull
    public String[] getBeanNamesForAnnotation(@NonNull Class<? extends Annotation> annotationType) {
        Object[] beanNamesForAnnotation = super.getBeanNamesForAnnotation(annotationType);
        Collection beanDefinitions = this.beanContext.getBeanDefinitions(Qualifiers.byStereotype(annotationType));
        return (String[])ArrayUtils.concat((Object[])this.beansToNames(beanDefinitions), (Object[])beanNamesForAnnotation);
    }

    public <A extends Annotation> A findAnnotationOnBean(@NonNull String beanName, @NonNull Class<A> annotationType) throws NoSuchBeanDefinitionException {
        if (super.containsSingleton(beanName)) {
            return (A)super.findAnnotationOnBean(beanName, annotationType);
        }
        io.micronaut.inject.BeanDefinition<?> ref = this.beanDefinitionMap.get(beanName);
        if (ref != null) {
            return (A)ref.getAnnotationMetadata().synthesize(annotationType);
        }
        return null;
    }

    private String[] beansToNames(Collection<? extends io.micronaut.inject.BeanDefinition<?>> beanDefinitions) {
        return (String[])beanDefinitions.stream().filter(bd -> !(bd instanceof ParametrizedBeanFactory)).map(this::computeBeanName).toArray(String[]::new);
    }

    @NonNull
    public <T> T createBean(@NonNull Class<T> beanClass) throws BeansException {
        return (T)this.beanContext.createBean(beanClass);
    }

    public void autowireBean(@NonNull Object existingBean) throws BeansException {
        if (existingBean != null) {
            this.beanContext.inject(existingBean);
        }
    }

    public Object configureBean(Object existingBean, String beanName) throws BeansException {
        Object injected = this.beanContext.inject(existingBean);
        return this.initializeBean(injected, beanName);
    }

    public Object createBean(Class<?> beanClass, int autowireMode, boolean dependencyCheck) throws BeansException {
        return this.createBean(beanClass);
    }

    public Object autowire(Class<?> beanClass, int autowireMode, boolean dependencyCheck) throws BeansException {
        return this.beanContext.getBean(beanClass);
    }

    public void autowireBeanProperties(Object existingBean, int autowireMode, boolean dependencyCheck) throws BeansException {
        this.autowireBean(existingBean);
    }

    public void applyBeanPropertyValues(Object existingBean, String beanName) throws BeansException {
        this.autowireBean(existingBean);
    }

    public Object initializeBean(Object existingBean, String beanName) throws BeansException {
        return this.springAwareListener.onBeanCreated(existingBean);
    }

    public void destroyBean(Object existingBean) {
        block11: {
            if (existingBean instanceof Closeable) {
                try {
                    ((Closeable)existingBean).close();
                }
                catch (Exception e) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Invocation of destroy method failed for bean [" + existingBean + "]: " + e.getMessage()), (Throwable)e);
                    }
                    break block11;
                }
            }
            if (existingBean instanceof DisposableBean) {
                try {
                    ((DisposableBean)existingBean).destroy();
                }
                catch (Exception e) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Invocation of destroy method failed for bean [" + existingBean + "]: " + e.getMessage()), (Throwable)e);
                    }
                    break block11;
                }
            }
            if (existingBean instanceof AutoCloseable) {
                try {
                    ((AutoCloseable)existingBean).close();
                }
                catch (Exception e) {
                    if (!this.logger.isDebugEnabled()) break block11;
                    this.logger.debug((Object)("Invocation of destroy method failed for bean [" + existingBean + "]: " + e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    public boolean containsLocalBean(String name) {
        return super.containsLocalBean(name) || this.beanDefinitionMap.containsKey(name) || this.beanDefinitionsByName.containsKey(name);
    }

    public BeanContext getBeanContext() {
        return this.beanContext;
    }

    public boolean isAutowireCandidate(String beanName, DependencyDescriptor descriptor) throws NoSuchBeanDefinitionException {
        return false;
    }

    public BeanDefinition getBeanDefinition(String beanName) throws NoSuchBeanDefinitionException {
        io.micronaut.inject.BeanDefinition<?> definition = this.beanDefinitionMap.get(beanName);
        if (definition != null && definition.isEnabled(this.beanContext)) {
            GenericBeanDefinition genericBeanDefinition = new GenericBeanDefinition();
            genericBeanDefinition.setBeanClass(definition.getBeanType());
            return genericBeanDefinition;
        }
        throw new NoSuchBeanDefinitionException(beanName);
    }

    protected <T> T doGetBean(String name, Class<T> requiredType, Object[] args, boolean typeCheckOnly) throws BeansException {
        io.micronaut.inject.BeanDefinition<?> def;
        io.micronaut.inject.BeanDefinition<?> definition;
        if (this.beanExcludes.contains(requiredType)) {
            throw new NoSuchBeanDefinitionException(name);
        }
        if (super.containsSingleton(name)) {
            Object o = super.getSingleton(name);
            if (requiredType == null || requiredType.isInstance(o)) {
                return (T)o;
            }
        }
        if ((definition = this.beanDefinitionMap.get(name)) == null && (def = this.beanDefinitionsByName.get(name)) != null) {
            if (requiredType != null) {
                if (requiredType.isAssignableFrom(def.getBeanType())) {
                    definition = def;
                }
            } else {
                definition = def;
            }
        }
        if (definition != null && definition.isEnabled(this.beanContext)) {
            if (requiredType == null) {
                requiredType = definition.getBeanType();
            }
            io.micronaut.inject.BeanDefinition<?> finalDefinition = definition;
            Qualifier q = (Qualifier)definition.getValue("javax.inject.Named", String.class).map(n -> {
                if (Primary.class.getName().equals(n)) {
                    return n;
                }
                return Qualifiers.byName((String)n);
            }).orElseGet(() -> {
                if (finalDefinition.hasDeclaredStereotype(Primary.class)) {
                    return null;
                }
                String annotationType = finalDefinition.getAnnotationNameByStereotype("javax.inject.Qualifier").orElse(null);
                if (annotationType != null) {
                    return Qualifiers.byAnnotation((AnnotationMetadata)finalDefinition, (String)annotationType);
                }
                if (finalDefinition instanceof NameResolver) {
                    return ((NameResolver)finalDefinition).resolveName().map(Qualifiers::byName).orElse(null);
                }
                return null;
            });
            if (q != null) {
                return (T)this.beanContext.getBean(requiredType, q);
            }
            return (T)this.beanContext.getBean(requiredType);
        }
        BeanFactory parentBeanFactory = this.getParentBeanFactory();
        if (parentBeanFactory != null) {
            if (parentBeanFactory instanceof AbstractBeanFactory) {
                return (T)((AbstractBeanFactory)parentBeanFactory).getBean(name, requiredType, args);
            }
            if (args != null) {
                return (T)parentBeanFactory.getBean(name, args);
            }
            if (requiredType != null) {
                return (T)parentBeanFactory.getBean(name, requiredType);
            }
            return (T)parentBeanFactory.getBean(name);
        }
        if (requiredType != null) {
            try {
                return (T)this.beanContext.getBean(requiredType, Qualifiers.byName((String)name));
            }
            catch (NoSuchBeanException e) {
                throw new NoSuchBeanDefinitionException(name);
            }
        }
        throw new NoSuchBeanDefinitionException(name);
    }

    protected Object getSingleton(String beanName, boolean allowEarlyReference) {
        if (super.containsSingleton(beanName)) {
            return super.getSingleton(beanName, allowEarlyReference);
        }
        return this.getBean(beanName);
    }

    public Object getSingleton(String beanName, ObjectFactory<?> singletonFactory) {
        if (super.containsSingleton(beanName)) {
            return super.getSingleton(beanName, singletonFactory);
        }
        return this.getBean(beanName);
    }

    public Iterator<String> getBeanNamesIterator() {
        return Arrays.asList(this.getBeanDefinitionNames()).iterator();
    }

    public boolean isFactoryBean(String name) throws NoSuchBeanDefinitionException {
        return false;
    }

    public void destroyBean(String beanName, Object beanInstance) {
        io.micronaut.inject.BeanDefinition<?> definition = this.beanDefinitionMap.get(beanName);
        if (definition instanceof DisposableBeanDefinition) {
            ((DisposableBeanDefinition)definition).dispose(this.beanContext, beanInstance);
        }
    }

    public void registerSingleton(String beanName, Object singletonObject) {
        Class<?> type = singletonObject.getClass();
        this.beanContext.registerSingleton(type, singletonObject, Qualifiers.byName((String)beanName));
        super.registerSingleton(beanName, singletonObject);
    }

    public boolean containsSingleton(String beanName) {
        return this.isSingleton(beanName);
    }

    public void registerBeanDefinition(String beanName, BeanDefinition beanDefinition) throws BeanDefinitionStoreException {
        AbstractBeanDefinition abstractBeanDefinition;
        Supplier instanceSupplier;
        if (beanDefinition instanceof AbstractBeanDefinition && (instanceSupplier = (abstractBeanDefinition = (AbstractBeanDefinition)beanDefinition).getInstanceSupplier()) != null) {
            this.registerSingleton(beanName, instanceSupplier.get());
        }
    }

    protected boolean isPrimary(String beanName, Object beanInstance) {
        io.micronaut.inject.BeanDefinition<?> definition = this.beanDefinitionMap.get(beanName);
        if (definition == null) {
            definition = this.beanDefinitionsByName.get(beanName);
        }
        if (definition != null) {
            return definition.hasDeclaredStereotype(Primary.class) || definition.getValue("javax.inject.Named", String.class).map(n -> Primary.class.getName().equals(n)).orElse(false) != false;
        }
        return false;
    }
}

