/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.AbstractMessageSource;
import io.micronaut.context.MessageSource;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.StringUtils;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class StaticMessageSource
extends AbstractMessageSource {
    private final Map<AbstractMessageSource.MessageKey, String> messageMap = new ConcurrentHashMap<AbstractMessageSource.MessageKey, String>(40);

    @NonNull
    public StaticMessageSource addMessage(@NonNull String code, @NonNull String message) {
        if (StringUtils.isNotEmpty((CharSequence)code) && StringUtils.isNotEmpty((CharSequence)message)) {
            this.messageMap.put(new AbstractMessageSource.MessageKey(this, Locale.getDefault(), code), message);
        }
        return this;
    }

    @NonNull
    public StaticMessageSource addMessage(@NonNull Locale locale, @NonNull String code, @NonNull String message) {
        ArgumentUtils.requireNonNull((String)"locale", (Object)locale);
        if (StringUtils.isNotEmpty((CharSequence)code) && StringUtils.isNotEmpty((CharSequence)message)) {
            this.messageMap.put(new AbstractMessageSource.MessageKey(this, locale, code), message);
        }
        return this;
    }

    @Override
    @NonNull
    public Optional<String> getRawMessage(@NonNull String code, @NonNull MessageSource.MessageContext context) {
        ArgumentUtils.requireNonNull((String)"code", (Object)code);
        ArgumentUtils.requireNonNull((String)"context", (Object)context);
        String msg = this.messageMap.get(new AbstractMessageSource.MessageKey(this, context.getLocale(), code));
        if (msg != null) {
            return Optional.of(msg);
        }
        return Optional.ofNullable(this.messageMap.get(new AbstractMessageSource.MessageKey(this, Locale.getDefault(), code)));
    }
}

