/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aop.chain;

import io.micronaut.aop.Interceptor;
import io.micronaut.aop.InvocationContext;
import io.micronaut.aop.chain.InterceptorChain;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.MutableArgumentValue;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
abstract class AbstractInterceptorChain<B, R>
implements InvocationContext<B, R> {
    protected static final Logger LOG = LoggerFactory.getLogger(InterceptorChain.class);
    protected final Interceptor<B, R>[] interceptors;
    protected final Object[] originalParameters;
    protected final int interceptorCount;
    protected MutableConvertibleValues<Object> attributes;
    protected int index = 0;
    protected Map<String, MutableArgumentValue<?>> parameters;

    AbstractInterceptorChain(Interceptor<B, R>[] interceptors, Object ... originalParameters) {
        this.interceptors = interceptors;
        this.interceptorCount = interceptors.length;
        this.originalParameters = originalParameters;
    }

    @Override
    @NonNull
    public Object[] getParameterValues() {
        return this.originalParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public MutableConvertibleValues<Object> getAttributes() {
        MutableConvertibleValues attributes = this.attributes;
        if (attributes == null) {
            AbstractInterceptorChain abstractInterceptorChain = this;
            synchronized (abstractInterceptorChain) {
                attributes = this.attributes;
                if (attributes == null) {
                    this.attributes = attributes = MutableConvertibleValues.of(new ConcurrentHashMap(5));
                }
            }
        }
        return attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public Map<String, MutableArgumentValue<?>> getParameters() {
        Map<String, MutableArgumentValue<?>> parameters = this.parameters;
        if (parameters == null) {
            AbstractInterceptorChain abstractInterceptorChain = this;
            synchronized (abstractInterceptorChain) {
                parameters = this.parameters;
                if (parameters == null) {
                    Argument[] arguments = this.getArguments();
                    parameters = new LinkedHashMap(arguments.length);
                    int i = 0;
                    while (i < arguments.length) {
                        final Argument argument = arguments[i];
                        final int finalIndex = i++;
                        parameters.put(argument.getName(), new MutableArgumentValue<Object>(){

                            public AnnotationMetadata getAnnotationMetadata() {
                                return argument.getAnnotationMetadata();
                            }

                            public Optional<Argument<?>> getFirstTypeVariable() {
                                return argument.getFirstTypeVariable();
                            }

                            public Argument[] getTypeParameters() {
                                return argument.getTypeParameters();
                            }

                            public Map<String, Argument<?>> getTypeVariables() {
                                return argument.getTypeVariables();
                            }

                            @NonNull
                            public String getName() {
                                return argument.getName();
                            }

                            @NonNull
                            public Class<Object> getType() {
                                return argument.getType();
                            }

                            public boolean equalsType(@Nullable Argument<?> other) {
                                return argument.equalsType(other);
                            }

                            public int typeHashCode() {
                                return argument.typeHashCode();
                            }

                            public Object getValue() {
                                return AbstractInterceptorChain.this.originalParameters[finalIndex];
                            }

                            public void setValue(Object value) {
                                AbstractInterceptorChain.this.originalParameters[finalIndex] = value;
                            }
                        });
                    }
                    parameters = Collections.unmodifiableMap(parameters);
                    this.parameters = parameters;
                }
            }
        }
        return parameters;
    }

    @Override
    public R proceed(@NonNull Interceptor from) throws RuntimeException {
        for (int i = 0; i < this.interceptors.length; ++i) {
            Interceptor<B, R> interceptor = this.interceptors[i];
            if (interceptor != from) continue;
            this.index = i + 1;
            return this.proceed();
        }
        throw new IllegalArgumentException("Argument [" + from + "] is not within the interceptor chain");
    }
}

