/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.qualifiers;

import io.micronaut.context.Qualifier;
import io.micronaut.context.annotation.Any;
import io.micronaut.context.annotation.Type;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.qualifiers.AnnotationMetadataQualifier;
import io.micronaut.inject.qualifiers.AnnotationQualifier;
import io.micronaut.inject.qualifiers.AnnotationStereotypeQualifier;
import io.micronaut.inject.qualifiers.AnyQualifier;
import io.micronaut.inject.qualifiers.ClosestTypeArgumentQualifier;
import io.micronaut.inject.qualifiers.CompositeQualifier;
import io.micronaut.inject.qualifiers.ExactTypeArgumentNameQualifier;
import io.micronaut.inject.qualifiers.InterceptorBindingQualifier;
import io.micronaut.inject.qualifiers.NameQualifier;
import io.micronaut.inject.qualifiers.NamedAnnotationStereotypeQualifier;
import io.micronaut.inject.qualifiers.RepeatableAnnotationQualifier;
import io.micronaut.inject.qualifiers.TypeAnnotationQualifier;
import io.micronaut.inject.qualifiers.TypeArgumentQualifier;
import jakarta.inject.Named;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Qualifiers {
    public static <T> Qualifier<T> any() {
        return AnyQualifier.INSTANCE;
    }

    @Nullable
    public static <T> Qualifier<T> forArgument(@NonNull Argument<?> argument) {
        List qualifierTypes;
        AnnotationMetadata annotationMetadata = Objects.requireNonNull(argument, "Argument cannot be null").getAnnotationMetadata();
        boolean hasMetadata = annotationMetadata != AnnotationMetadata.EMPTY_METADATA;
        List list = qualifierTypes = hasMetadata ? annotationMetadata.getAnnotationNamesByStereotype("javax.inject.Qualifier") : null;
        if (CollectionUtils.isNotEmpty((Collection)qualifierTypes)) {
            if (qualifierTypes.size() == 1) {
                return Qualifiers.byAnnotation(annotationMetadata, (String)qualifierTypes.iterator().next());
            }
            Qualifier[] qualifiers = new Qualifier[qualifierTypes.size()];
            int i = 0;
            for (String type : qualifierTypes) {
                qualifiers[i++] = Qualifiers.byAnnotation(annotationMetadata, type);
            }
            return Qualifiers.byQualifiers(qualifiers);
        }
        return null;
    }

    public static <T> Qualifier<T> byQualifiers(Qualifier<T> ... qualifiers) {
        return new CompositeQualifier(qualifiers);
    }

    public static <T> Qualifier<T> byName(String name) {
        return new NameQualifier(null, name);
    }

    public static <T> Qualifier<T> byAnnotation(Annotation annotation) {
        if (annotation instanceof Type) {
            Type typeAnn = (Type)annotation;
            return Qualifiers.byType(typeAnn.value());
        }
        if (annotation instanceof Named) {
            Named nameAnn = (Named)annotation;
            return Qualifiers.byName(nameAnn.value());
        }
        if (annotation instanceof Any) {
            return AnyQualifier.INSTANCE;
        }
        return new AnnotationQualifier(annotation);
    }

    public static <T> Qualifier<T> byAnnotation(AnnotationMetadata metadata, Class<? extends Annotation> type) {
        Optional value;
        if (Any.class == type) {
            return AnyQualifier.INSTANCE;
        }
        if (Type.class == type) {
            Optional aClass = metadata.classValue(type);
            if (aClass.isPresent()) {
                return Qualifiers.byType((Class)aClass.get());
            }
        } else if ((Named.class == type || "javax.inject.Named".equals(type.getName())) && (value = metadata.stringValue(type)).isPresent()) {
            return Qualifiers.byName((String)value.get());
        }
        return new AnnotationMetadataQualifier(metadata, type);
    }

    public static <T> Qualifier<T> byAnnotation(AnnotationMetadata metadata, String type) {
        if (Type.NAME.equals(type)) {
            Optional aClass = metadata.classValue(type);
            if (aClass.isPresent()) {
                return Qualifiers.byType((Class)aClass.get());
            }
        } else {
            String n;
            if (Any.NAME.equals(type)) {
                return AnyQualifier.INSTANCE;
            }
            if ((Named.class.getName().equals(type) || "javax.inject.Named".equals(type)) && (n = (String)metadata.stringValue(type).orElse(null)) != null) {
                return Qualifiers.byName(n);
            }
        }
        return new AnnotationMetadataQualifier(metadata, type);
    }

    public static <T> Qualifier<T> byRepeatableAnnotation(AnnotationMetadata metadata, String repeatableType) {
        return new RepeatableAnnotationQualifier(metadata, repeatableType);
    }

    @Internal
    public static <T> Qualifier<T> byAnnotationSimple(AnnotationMetadata metadata, String type) {
        return new AnnotationMetadataQualifier(metadata, type);
    }

    public static <T> Qualifier<T> byStereotype(Class<? extends Annotation> stereotype) {
        return new AnnotationStereotypeQualifier(stereotype);
    }

    public static <T> Qualifier<T> byStereotype(String stereotype) {
        return new NamedAnnotationStereotypeQualifier(stereotype);
    }

    public static <T> Qualifier<T> byTypeArguments(Class ... typeArguments) {
        return new TypeArgumentQualifier(typeArguments);
    }

    @NonNull
    public static <T> Qualifier<T> byExactTypeArgumentName(@NonNull String typeName) {
        return new ExactTypeArgumentNameQualifier(typeName);
    }

    public static <T> Qualifier<T> byTypeArgumentsClosest(Class ... typeArguments) {
        return new ClosestTypeArgumentQualifier(typeArguments);
    }

    public static <T> Qualifier<T> byType(Class ... typeArguments) {
        return new TypeAnnotationQualifier(typeArguments);
    }

    @NonNull
    public static <T> Qualifier<T> byInterceptorBinding(@NonNull AnnotationMetadata annotationMetadata) {
        return new InterceptorBindingQualifier(annotationMetadata);
    }

    @NonNull
    public static <T> Qualifier<T> byInterceptorBinding(@NonNull Collection<String> bindingAnnotationNames) {
        return new InterceptorBindingQualifier(bindingAnnotationNames);
    }
}

